<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-header {
        z-index: 2;
        text-align: center;
        font-size: 2.2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-grid-masonry {
        columns: 2;
        column-gap: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-card {
        break-inside: avoid;
        -webkit-column-break-inside: avoid;
        background-color: {$data['color_5']};
        border-radius: 12px;
        padding: 24px;
        margin-bottom: 20px;
        display: inline-block;
        width: 100%;
        border-top: 3px solid {$data['color_6']};
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
        transition: box-shadow 0.25s ease, transform 0.25s ease;
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-card:hover {
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .{$name}-{$id} .{$name}-{$id}-grid-number {
        position: absolute;
        top: -8px;
        right: 12px;
        font-size: 3.5rem;
        font-weight: 900;
        color: {$data['color_2']};
        opacity: 0.25;
        line-height: 1;
        pointer-events: none;
        user-select: none;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-question {
        color: {$data['color_1']};
        font-weight: 700;
        font-size: 1.05rem;
        line-height: 1.5;
        margin-bottom: 12px;
        text-align: left;
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-answer {
        color: {$data['color_4']};
        font-size: 0.92rem;
        line-height: 1.7;
        text-align: left;
        position: relative;
        z-index: 1;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-grid-masonry {
            columns: 1;
        }

        .{$name}-{$id} .{$name}-{$id}-grid-header {
            font-size: 1.6rem;
        }

        .{$name}-{$id} .{$name}-{$id}-grid-card {
            padding: 20px;
        }

        .{$name}-{$id} .{$name}-{$id}-grid-number {
            font-size: 2.5rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-grid-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-grid-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-grid-masonry">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-grid-card">
                    <div class="{$name}-{$id}-grid-number">{if $key < 10}0{/if}{$key}</div>
                    <div class="{$name}-{$id}-grid-question">{$value['question']}</div>
                    <div class="{$name}-{$id}-grid-answer">{$value['answer']}</div>
                </div>
            {/foreach}
        </div>
    </div>
</div>