<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-container {
        position: relative;
        z-index: 2;
        display: inline-block;
        width: 100%;
        text-align: center;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-cards-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0 1.5rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-cards-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 16px;
        text-align: left;
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-cards-grid {
            grid-template-columns: 1fr;
        }
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card {
        background-color: {$data['color_5']};
        border: 1px solid {$data['color_2']};
        border-radius: 14px;
        padding: 24px;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.06);
        cursor: pointer;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-question {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-question-text {
        color: {$data['color_1']};
        font-weight: 700;
        font-size: 1rem;
        flex: 1;
        line-height: 1.4;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-icon-btn {
        width: 28px;
        height: 28px;
        min-width: 28px;
        border-radius: 50%;
        background-color: {$data['color_6']};
        display: flex;
        align-items: center;
        justify-content: center;
        transition: transform 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-icon-btn i {
        color: #fff;
        font-size: 0.7rem;
        line-height: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-answer {
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-answer-inner {
        padding-top: 16px;
        margin-top: 16px;
        border-top: 1px solid {$data['color_2']};
        color: {$data['color_4']};
        font-size: 0.95rem;
        line-height: 1.6;
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-cards-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-cards-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-cards-grid">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-cards-card" onclick="puqqacards{$id}({$key})">
                    <div class="{$name}-{$id}-cards-question">
                        <div class="{$name}-{$id}-cards-question-text">{$value['question']}</div>
                        <div class="{$name}-{$id}-cards-icon-btn">
                            <i class="fas fa-plus {$name}-{$id}-cards-icon"></i>
                        </div>
                    </div>
                    <div class="{$name}-{$id}-cards-answer">
                        <div class="{$name}-{$id}-cards-answer-inner">{$value['answer']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    function puqqacards{$id}(item) {
        var contents = document.getElementsByClassName("{$name}-{$id}-cards-answer");
        var icons = document.getElementsByClassName("{$name}-{$id}-cards-icon");

        for (var i = 0; i < contents.length; i++) {
            if (i + 1 === item) {
                if (contents[i].style.maxHeight) {
                    contents[i].style.maxHeight = null;
                    icons[i].classList.remove("fa-minus");
                    icons[i].classList.add("fa-plus");
                } else {
                    contents[i].style.maxHeight = contents[i].scrollHeight + "px";
                    icons[i].classList.remove("fa-plus");
                    icons[i].classList.add("fa-minus");
                }
            } else {
                contents[i].style.maxHeight = null;
                icons[i].classList.remove("fa-minus");
                icons[i].classList.add("fa-plus");
            }
        }
    }
</script>