<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-border-container {
        position: relative;
        z-index: 2;
        display: inline-block;
        width: 100%;
        text-align: left;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-border-header {
        z-index: 2;
        text-align: left;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 0.5rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-border-header-line {
        width: 60px;
        height: 3px;
        background-color: {$data['color_6']};
        margin-bottom: 1.5rem;
    }

    .{$name}-{$id} .{$name}-{$id}-border-list {
        display: flex;
        flex-direction: column;
        gap: 1px;
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-border-question {
        background-color: {$data['color_2']};
        padding: 18px 24px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 16px;
        border-left: 4px solid {$data['color_6']};
        transition: border-left-width 0.2s ease, background-color 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-border-question:hover {
        border-left-width: 6px;
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-border-question-text {
        color: {$data['color_1']};
        font-weight: 600;
        font-size: 1rem;
        flex: 1;
        line-height: 1.4;
    }

    .{$name}-{$id} .{$name}-{$id}-border-toggle {
        color: {$data['color_1']};
        font-size: 1.25rem;
        font-weight: 300;
        line-height: 1;
        min-width: 20px;
        text-align: center;
        user-select: none;
        transition: transform 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-border-answer {
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
    }

    .{$name}-{$id} .{$name}-{$id}-border-answer-inner {
        background-color: {$data['color_5']};
        color: {$data['color_4']};
        border-left: 4px solid {$data['color_2']};
        padding: 20px 24px;
        font-size: 0.95rem;
        line-height: 1.6;
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-border-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-border-header">{$data['header']}</h2>
            <div class="{$name}-{$id}-border-header-line"></div>
        {/if}

        <div class="{$name}-{$id}-border-list">
            {foreach $data['qa'] as $key=>$value}
                <div class="{$name}-{$id}-border-item">
                    <div class="{$name}-{$id}-border-question" onclick="puqqaborder{$id}({$key})">
                        <div class="{$name}-{$id}-border-question-text">{$value['question']}</div>
                        <span class="{$name}-{$id}-border-toggle {$name}-{$id}-border-icon">+</span>
                    </div>
                    <div class="{$name}-{$id}-border-answer">
                        <div class="{$name}-{$id}-border-answer-inner">{$value['answer']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<script>
    function puqqaborder{$id}(item) {
        var contents = document.getElementsByClassName("{$name}-{$id}-border-answer");
        var icons = document.getElementsByClassName("{$name}-{$id}-border-icon");

        for (var i = 0; i < contents.length; i++) {
            if (i + 1 === item) {
                if (contents[i].style.maxHeight) {
                    contents[i].style.maxHeight = null;
                    icons[i].textContent = "+";
                } else {
                    contents[i].style.maxHeight = contents[i].scrollHeight + "px";
                    icons[i].textContent = "\u2212";
                }
            } else {
                contents[i].style.maxHeight = null;
                icons[i].textContent = "+";
            }
        }
    }
</script>