<style>
    .{$name}-{$id} {
        padding-left: 0 !important;
        padding-right: 0 !important;
    {if $data['width']}
        display: flex;
        align-items: center;
        justify-content: center;
    {/if}
    }

    .{$name}-{$id}-slider-wrap- {
    {if $data['width']}
        width: {$data['width']};
        max-width: 100%;
    {else}
        width: 100%;
    {/if}
        position: relative;
        overflow: hidden;
    {if $data['height']}
        height: {$data['height']};
    {else}
        height: 500px;
    {/if}
    }

    .{$name}-{$id}-track- {
        display: flex;
        height: 100%;
        transition: transform 0.7s cubic-bezier(0.45, 0, 0.15, 1);
    }

    .{$name}-{$id}-slide- {
        flex: 0 0 100%;
        width: 100%;
        display: flex;
        height: 100%;
    }

    .{$name}-{$id}-left- {
        width: 50%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        padding: 40px 50px;
        box-sizing: border-box;
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id}-right- {
        width: 50%;
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id}-right- img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
    }

    .{$name}-{$id}-right-bg- {
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
    }

    .{$name}-{$id}-title- {
        margin: 0 0 16px 0;
        line-height: 1.2;
        font-weight: 700;
        word-wrap: break-word;
    }

    .{$name}-{$id}-desc- {
        margin: 0 0 28px 0;
        line-height: 1.6;
        word-wrap: break-word;
    }

    .{$name}-{$id}-btn- {
        display: inline-block;
        padding: 12px 32px;
        font-size: 15px;
        font-weight: 600;
        text-decoration: none;
        border-radius: 6px;
        border-width: 2px;
        border-style: solid;
        transition: opacity 0.25s ease, transform 0.25s ease;
        cursor: pointer;
        align-self: flex-start;
    }

    .{$name}-{$id}-btn-:hover {
        opacity: 0.85;
        transform: translateY(-1px);
    }

    .{$name}-{$id}-progress-wrap- {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 3px;
        z-index: 10;
        overflow: hidden;
    }

    .{$name}-{$id}-progress-bg- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0.2;
    }

    .{$name}-{$id}-progress-bar- {
        position: absolute;
        top: 0;
        left: 0;
        width: 0%;
        height: 100%;
        transition: width 0.1s linear;
    }

    .{$name}-{$id}-dots-wrap- {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 10px;
        padding: 14px 0;
    }

    .{$name}-{$id}-dot- {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        border: none;
        cursor: pointer;
        transition: transform 0.25s ease, opacity 0.25s ease;
        padding: 0;
        opacity: 0.35;
    }

    .{$name}-{$id}-dot-active- {
        transform: scale(1.35);
        opacity: 1;
    }

    .{$name}-{$id}-dot-:hover {
        opacity: 0.7;
    }

    @media screen and (max-width: 768px) {
        .{$name}-{$id}-slide- {
            flex-direction: column-reverse;
        }

        .{$name}-{$id}-left- {
            width: 100%;
            padding: 28px 24px;
        }

        .{$name}-{$id}-right- {
            width: 100%;
            height: 220px;
            flex-shrink: 0;
        }

        .{$name}-{$id}-slider-wrap- {
            height: auto;
        }

        .{$name}-{$id}-track- {
            height: auto;
        }

        .{$name}-{$id}-title- {
            font-size: 24px !important;
        }

        .{$name}-{$id}-desc- {
            font-size: 14px !important;
        }
    }

    {$i = 0}
    {foreach $data['members'] as $member}
    .{$name}-{$id}-btn-{$i}- {
        background-color: {$member['member_button_color']};
        color: {$member['member_button_color_text']};
        border-color: {$member['member_button_color_border']};
    }
    {$i = $i + 1}
    {/foreach}
</style>

<div class="{$name}-{$id}">
    <div class="{$name}-{$id}-slider-wrap-" id="{$name}-{$id}-slider-wrap">
        <div class="{$name}-{$id}-track-" id="{$name}-{$id}-track">
            {$i = 0}
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-slide-">
                    <div class="{$name}-{$id}-left-" style="background-color: {$member['member_background_color']};">
                        {if $member['member_header']}
                            <div class="{$name}-{$id}-title-" style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">{$member['member_header']}</div>
                        {/if}
                        {if $member['member_description']}
                            <div class="{$name}-{$id}-desc-" style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">{$member['member_description']}</div>
                        {/if}
                        {if $member['member_button_text']}
                            <a href="{$member['member_button_url']}" {if $member['mmnew_tab']}target="_blank"{/if} class="{$name}-{$id}-btn- {$name}-{$id}-btn-{$i}-">{$member['member_button_text']}</a>
                        {/if}
                    </div>
                    <div class="{$name}-{$id}-right-">
                        {if $member['member_img']}
                            <img src="{$member['member_img']}" alt="{$member['member_header']}" />
                        {elseif $member['member_background_img']}
                            <div class="{$name}-{$id}-right-bg-" style="background-image: url('{$member['member_background_img']}'); background-color: {$member['member_background_color']};"></div>
                        {else}
                            <div class="{$name}-{$id}-right-bg-" style="background-color: {$member['member_background_color']};"></div>
                        {/if}
                    </div>
                </div>
                {$i = $i + 1}
            {/foreach}
        </div>

        <div class="{$name}-{$id}-progress-wrap-">
            <div class="{$name}-{$id}-progress-bg-" id="{$name}-{$id}-progress-bg"></div>
            <div class="{$name}-{$id}-progress-bar-" id="{$name}-{$id}-progress-bar"></div>
        </div>
    </div>

    {if !$data['disable_nav_button']}
    <div class="{$name}-{$id}-dots-wrap-" id="{$name}-{$id}-dots">
        {$i = 0}
        {foreach $data['members'] as $member}
            <button type="button" class="{$name}-{$id}-dot-" data-slide-{$name}-{$id}="{$i}" style="background-color: {$member['member_header_color']};"></button>
            {$i = $i + 1}
        {/foreach}
    </div>
    {/if}
</div>

<script>
    (function() {
        var PREFIX = "{$name}-{$id}";
        var track = document.getElementById(PREFIX + "-track");
        var wrap = document.getElementById(PREFIX + "-slider-wrap");
        var progressBar = document.getElementById(PREFIX + "-progress-bar");
        var progressBg = document.getElementById(PREFIX + "-progress-bg");
        var dots = document.querySelectorAll("[data-slide-" + PREFIX + "]");
        var slides = track.children;
        var total = slides.length;
        var current = 0;
        var interval = null;
        var paused = false;
        var DELAY = 5000;
        var progressStart = 0;
        var progressRaf = null;

        if (total === 0) return;

        /* set first slide active colors on progress */
        var firstSlide = slides[0];
        var firstLeftBg = firstSlide.querySelector("." + PREFIX + "-left-");
        if (firstLeftBg) {
            var cs = window.getComputedStyle(firstLeftBg);
            progressBg.style.backgroundColor = cs.backgroundColor;
            progressBar.style.backgroundColor = cs.backgroundColor;
        }

        function goTo(index) {
            if (index < 0) index = total - 1;
            if (index >= total) index = 0;
            current = index;
            track.style.transform = "translateX(-" + (current * 100) + "%)";

            /* update progress bar color from current slide */
            var curSlide = slides[current];
            var leftPanel = curSlide.querySelector("." + PREFIX + "-left-");
            if (leftPanel) {
                var bgColor = window.getComputedStyle(leftPanel).backgroundColor;
                progressBg.style.backgroundColor = bgColor;
                progressBar.style.backgroundColor = bgColor;
            }

            /* update dots */
            for (var d = 0; d < dots.length; d++) {
                dots[d].classList.remove(PREFIX + "-dot-active-");
            }
            if (dots[current]) {
                dots[current].classList.add(PREFIX + "-dot-active-");
            }

            resetProgress();
        }

        function resetProgress() {
            progressBar.style.transition = "none";
            progressBar.style.width = "0%";
            if (progressRaf) cancelAnimationFrame(progressRaf);
            progressStart = performance.now();
            animateProgress();
        }

        function animateProgress() {
            if (paused) return;
            var elapsed = performance.now() - progressStart;
            var pct = Math.min((elapsed / DELAY) * 100, 100);
            progressBar.style.transition = "none";
            progressBar.style.width = pct + "%";
            if (pct < 100) {
                progressRaf = requestAnimationFrame(animateProgress);
            }
        }

        function startAuto() {
            stopAuto();
            progressStart = performance.now();
            animateProgress();
            interval = setInterval(function() {
                goTo(current + 1);
            }, DELAY);
        }

        function stopAuto() {
            if (interval) clearInterval(interval);
            interval = null;
            if (progressRaf) cancelAnimationFrame(progressRaf);
        }

        /* dot clicks */
        for (var i = 0; i < dots.length; i++) {
            (function(idx) {
                dots[idx].addEventListener("click", function() {
                    goTo(idx);
                    startAuto();
                });
            })(i);
        }

        /* hover pause */
        wrap.addEventListener("mouseenter", function() {
            paused = true;
            stopAuto();
        });

        wrap.addEventListener("mouseleave", function() {
            paused = false;
            startAuto();
        });

        /* touch swipe */
        var touchStartX = 0;
        var touchEndX = 0;

        wrap.addEventListener("touchstart", function(e) {
            touchStartX = e.changedTouches[0].screenX;
            paused = true;
            stopAuto();
        }, { passive: true });

        wrap.addEventListener("touchend", function(e) {
            touchEndX = e.changedTouches[0].screenX;
            var diff = touchStartX - touchEndX;
            if (Math.abs(diff) > 50) {
                if (diff > 0) {
                    goTo(current + 1);
                } else {
                    goTo(current - 1);
                }
            }
            paused = false;
            startAuto();
        }, { passive: true });

        /* init */
        goTo(0);
        startAuto();
    })();
</script>
