<style>
    .{$name}-{$id} {
    {if $data['full_width']}
        padding-left: 0 !important;
        padding-right: 0 !important;
        padding-top: 0 !important;
        padding-bottom: 0 !important;
    {/if}
        overflow: hidden;
        z-index: 0;
    }

    .{$name}-{$id}-slider- {
        position: relative;
    {if $data['width']}
        width: {$data['width']};
        margin: 0 auto;
    {else}
        width: 100%;
    {/if}
    {if $data['height']}
        height: {$data['height']};
    {else}
        height: 600px;
    {/if}
        overflow: hidden;
    }

    .{$name}-{$id}-slide- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        transition: opacity 1s ease-in-out;
        overflow: hidden;
    }

    .{$name}-{$id}-slide-active- {
        opacity: 1;
    }

    .{$name}-{$id}-bg- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center center;
        background-repeat: no-repeat;
        transform: scale(1);
        transition: transform 0s ease;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-bg- {
        animation: {$name}-{$id}-kenburns 6s ease-out forwards;
    }

    @keyframes {$name}-{$id}-kenburns {
        from { transform: scale(1); }
        to { transform: scale(1.15); }
    }

    .{$name}-{$id}-overlay- {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
    }

    .{$name}-{$id}-content- {
        position: relative;
        z-index: 2;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        height: 100%;
        padding: 40px 20px;
        text-align: center;
    }

    .{$name}-{$id}-avatar- {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        object-fit: cover;
        margin-bottom: 20px;
        opacity: 0;
        transform: translateY(30px);
        transition: opacity 0.6s ease, transform 0.6s ease;
        transition-delay: 0.4s;
        border: 3px solid rgba(255, 255, 255, 0.3);
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-avatar- {
        opacity: 1;
        transform: translateY(0);
    }

    .{$name}-{$id}-title- {
        margin: 0 0 16px 0;
        font-weight: 700;
        line-height: 1.2;
        opacity: 0;
        transform: translateY(30px);
        transition: opacity 0.6s ease, transform 0.6s ease;
        transition-delay: 0.6s;
        max-width: 800px;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-title- {
        opacity: 1;
        transform: translateY(0);
    }

    .{$name}-{$id}-desc- {
        margin: 0 0 28px 0;
        line-height: 1.6;
        opacity: 0;
        transform: translateY(30px);
        transition: opacity 0.6s ease, transform 0.6s ease;
        transition-delay: 0.8s;
        max-width: 600px;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-desc- {
        opacity: 1;
        transform: translateY(0);
    }

    .{$name}-{$id}-btn- {
        display: inline-block;
        padding: 14px 40px;
        border-radius: 50px;
        text-decoration: none;
        font-size: 15px;
        font-weight: 600;
        letter-spacing: 0.5px;
        transition: opacity 0.6s ease, transform 0.6s ease, filter 0.3s ease;
        transition-delay: 1.0s;
        opacity: 0;
        transform: translateY(30px);
        cursor: pointer;
    }

    .{$name}-{$id}-slide-active- .{$name}-{$id}-btn- {
        opacity: 1;
        transform: translateY(0);
    }

    .{$name}-{$id}-btn-:hover {
        filter: brightness(1.15);
    }

    .{$name}-{$id}-dots- {
        position: absolute;
        right: 30px;
        top: 50%;
        transform: translateY(-50%);
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 12px;
        z-index: 10;
    }

    .{$name}-{$id}-dot- {
        width: 10px;
        height: 10px;
        border-radius: 5px;
        background: rgba(255, 255, 255, 0.4);
        border: none;
        cursor: pointer;
        transition: height 0.3s ease, background 0.3s ease;
        padding: 0;
    }

    .{$name}-{$id}-dot-:hover {
        background: rgba(255, 255, 255, 0.7);
    }

    .{$name}-{$id}-dot-active- {
        height: 30px;
        background: rgba(255, 255, 255, 0.9);
    }

    @media screen and (max-width: 767px) {
        .{$name}-{$id}-slider- {
        {if !$data['height']}
            height: 450px;
        {/if}
        }

        .{$name}-{$id}-title- {
            max-width: 90%;
        }

        .{$name}-{$id}-desc- {
            max-width: 90%;
        }

        .{$name}-{$id}-avatar- {
            width: 70px;
            height: 70px;
        }

        .{$name}-{$id}-dots- {
            right: auto;
            bottom: 16px;
            top: auto;
            transform: none;
            flex-direction: row;
            gap: 10px;
            width: 100%;
            justify-content: center;
        }

        .{$name}-{$id}-dot- {
            width: 10px;
            height: 10px;
        }

        .{$name}-{$id}-dot-active- {
            width: 30px;
            height: 10px;
        }

        .{$name}-{$id}-content- {
            padding: 30px 16px 50px 16px;
        }

        .{$name}-{$id}-btn- {
            padding: 12px 30px;
            font-size: 14px;
        }
    }
</style>

<div class="{$name}-{$id}">
    <div class="{$name}-{$id}-slider-" id="{$name}-{$id}-slider">
        {$i = 1}
        {foreach $data['members'] as $member}
            <div class="{$name}-{$id}-slide-{if $i == 1} {$name}-{$id}-slide-active-{/if}" id="{$name}-{$id}-slide-{$i}">
                <div class="{$name}-{$id}-bg-" style="
                    {if $member['member_background_img'] neq ''}background-image: url('{$member['member_background_img']}');{/if}
                    background-color: {$member['member_background_color']};
                "></div>
                <div class="{$name}-{$id}-overlay-" style="background-color: {$member['member_background_color']}; opacity: 0.5;"></div>
                <div class="{$name}-{$id}-content-">
                    {if $member['member_img'] neq ''}
                        <img class="{$name}-{$id}-avatar-" src="{$member['member_img']}" alt="{$member['member_header']}" />
                    {/if}
                    <h2 class="{$name}-{$id}-title-" style="color: {$member['member_header_color']}; font-size: {$member['member_header_size']};">{$member['member_header']}</h2>
                    <p class="{$name}-{$id}-desc-" style="color: {$member['member_description_color']}; font-size: {$member['member_description_size']};">{$member['member_description']}</p>
                    {if $member['member_button_text'] neq ''}
                        <a class="{$name}-{$id}-btn-" href="{$member['member_button_url']}" {if $member['mmnew_tab']}target="_blank"{/if} style="
                            background-color: {$member['member_button_color']};
                            color: {$member['member_button_color_text']};
                            border: 2px solid {$member['member_button_color_border']};
                        ">{$member['member_button_text']}</a>
                    {/if}
                </div>
            </div>
            {$i = $i + 1}
        {/foreach}

        {if !$data['disable_nav_button']}
            <div class="{$name}-{$id}-dots-" id="{$name}-{$id}-dots">
                {$i = 1}
                {foreach $data['members'] as $member}
                    <button class="{$name}-{$id}-dot-{if $i == 1} {$name}-{$id}-dot-active-{/if}" id="{$name}-{$id}-dot-{$i}" aria-label="Go to slide {$i}"></button>
                    {$i = $i + 1}
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
    (function() {
        var prefix = "{$name}-{$id}";
        var slider = document.getElementById(prefix + "-slider");
        if (!slider) return;

        var slides = slider.querySelectorAll("." + prefix + "-slide-");
        var totalSlides = slides.length;
        if (totalSlides === 0) return;

        var dots = slider.querySelectorAll("." + prefix + "-dot-");
        var current = 0;
        var interval = null;
        var paused = false;

        function goTo(index) {
            slides[current].classList.remove(prefix + "-slide-active-");
            if (dots.length > 0) {
                dots[current].classList.remove(prefix + "-dot-active-");
            }

            current = (index + totalSlides) % totalSlides;

            var bgEl = slides[current].querySelector("." + prefix + "-bg-");
            if (bgEl) {
                bgEl.style.animation = "none";
                bgEl.offsetHeight;
                bgEl.style.animation = "";
            }

            slides[current].classList.add(prefix + "-slide-active-");
            if (dots.length > 0) {
                dots[current].classList.add(prefix + "-dot-active-");
            }
        }

        function nextSlide() {
            goTo(current + 1);
        }

        function startAutoplay() {
            if (interval) clearInterval(interval);
            interval = setInterval(function() {
                if (!paused) nextSlide();
            }, 5000);
        }

        for (var d = 0; d < dots.length; d++) {
            (function(idx) {
                dots[idx].addEventListener("click", function() {
                    goTo(idx);
                    startAutoplay();
                });
            })(d);
        }

        slider.addEventListener("mouseenter", function() {
            paused = true;
        });

        slider.addEventListener("mouseleave", function() {
            paused = false;
        });

        startAutoplay();
    })();
</script>
