class PUQPromoSlider {
    static get toolbox() {
        return {
            title: 'Promo Slider',
            icon: '<i class="fas fa-film"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQPromoSlider');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td  class="fieldlabel"><h1 style="color: blue;">Promo Slider</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select><br/>
            <label for="height">height: </label>
            <input type="text" name="height" class="form-control input-inline input-100" value="">
        </td>
    </tr>
   
    
    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">
        
        <input type="color" name="background_color" class="form-control input-inline input-50">
        
        <label class="checkbox-inline"><input type="checkbox" name="disable_nav_button"><b>Disable Navigation Buttons</b></label>
        
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>
        
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>     
        
        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>   
        </td>
    </tr>
   
    
    <tr>
        <td class="fieldlabel"><a type="button" name="add-row"><div style="font-size: 24px;" class="fa fa-plus"></div></a></td>
        <td colspan="3" class="fieldarea"></td>
    </tr>
    
    <tr>
        <td class="fieldlabel"></td>
        <td colspan="3" class="fieldarea">
            <table name="PromoSliderTable" class="datatable">
                <thead>
                <tr>
                    <th class="text-center" style="width: 405px;"><b>Header/Description/IMG</b></th>
                    <th class="text-center"><b>Colors/Size</b></th>
                    <th class="text-center"></th>
                    <th class="text-center"></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </td>
    </tr>
    
    </tbody>
</table>
`);
        const table = render.querySelector("[name='PromoSliderTable']");
        const addRowButton = render.querySelector("[name='add-row']");

        const members = this.data && this.data.members ? this.data.members : "";
        const tbody = table.querySelector("tbody");

        Object.entries(members).forEach(([key, value]) => {
            const row = document.createElement("tr");
            const optionBoxesHeader = generateOptionBoxes(value.member_header_size);
            const optionBoxesDescription = generateOptionBoxes(value.member_description_size);
            var mmnew_tab = '';
            var header__ = '';
            var description__ =  '';
            if (this.isBase64(value.member_header)) {
                header__ = decodeURIComponent(atob(value.member_header));
            } else {
                header__ = value.member_header;
            }
            if (this.isBase64(value.member_description)) {
                description__ = decodeURIComponent(atob(value.member_description));
            } else {
                description__ = value.member_description;
            }
            if ('mmnew_tab' in value && value.mmnew_tab) {
                mmnew_tab = 'checked';
            }

            row.innerHTML = `
                
                <style>
                    .button_colors_slider {
                        width: 40px;
                        padding: 4px 8px;
                        border-radius: 2px;
                        height: 30px;
                    }
                    
                    .flex-container-slider {
                        display: flex;
                        justify-content: space-between;
                    }
                </style>

                <td class="text-left" style="width: 605px;">
                
                    <label for="member_header">Header: </label>
                    <input type="text" name="member_header" value="${header__}" class="form-control input-inline input-800"><br>
                    
                    <label for="member_description">Description: </label>
                    <textarea name="member_description" rows="4" class="form-control input-800" style="height: 85px; resize: none;">${description__}</textarea>
                    
                    <label for="member_img">IMG: </label>
                    <input type="text" name="member_img" value="${value.member_img}" class="form-control input-inline input-800"><br>
                    
                    <label for="member_background_img">Background IMG: </label>
                    <input type="text" name="member_background_img" value="${value.member_background_img}" class="form-control input-inline input-800"><br>
                    
                    <label for="member_button_text">Button text: </label>
                    <input type="text" name="member_button_text" value="${value.member_button_text}" class="form-control input-inline input-800"><br>
                    
                    <label for="member_button_url">Button URL: </label>
                    <input type="text" name="member_button_url" value="${value.member_button_url}" class="form-control input-inline input-800"><br>
           
                </td>
                
                <td class="text-left">
                    <label for="member_header_size">Header size: </label>
                    <select name="member_header_size" class="form-control input-inline">
                        ${optionBoxesHeader}
                    </select><br>
                    
                    <label for="member_header_color">Header color: </label>
                    <input type="color" name="member_header_color" value="${value.member_header_color}" class="form-control input-inline"><br>
                  
                    <label for="member_description_size">Description size: </label>
                    <select name="member_description_size" class="form-control input-inline">
                        ${optionBoxesDescription}
                    </select><br>
                    
                    <label for="member_description_color">Description color: </label>
                    <input type="color" name="member_description_color" value="${value.member_description_color}" class="form-control input-inline"><br>
                  
                    <label for="member_background_color">Background color: </label>
                    <input type="color" name="member_background_color" value="${value.member_background_color}" class="form-control input-inline"><br>
                                    
                    <label for="member_background_color">Button colors: </label>
                    <label for="member_background_color">bkgd / text / bord</label>
                    <div class="flex-container-slider">
                        <input type="color" name="member_button_color" value="${value.member_button_color}" class="form-control button_colors_slider">
                        <input type="color" name="member_button_color_text" value="${value.member_button_color_text}" class="form-control button_colors_slider">
                        <input type="color" name="member_button_color_border" value="${value.member_button_color_border}" class="form-control button_colors_slider">
                    </div><br>
                      
                    <label for="mmnew_tab">Open in new tab: </label>
                    <input type="checkbox" name="mmnew_tab" ${mmnew_tab}><br>
                  
                </td>

                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
            `;
            tbody.appendChild(row);
            addRowListeners(row);
        });

        function addRow() {
            const tbody = table.querySelector("tbody");
            const row = document.createElement("tr");
            const optionBoxesHeader = generateOptionBoxes('');
            const optionBoxesDescription = generateOptionBoxes('');

            row.innerHTML = `

                <style>
                    .button_colors_slider {
                        width: 40px;
                        padding: 4px 8px;
                        border-radius: 2px;
                        height: 30px;
                    }
                    
                    .flex-container-slider {
                        display: flex;
                        justify-content: space-between;
                    }
                </style>
                
                <td class="text-left" style="width: 605px;">
                
                    <label for="member_header">Header: </label>
                    <input type="text" name="member_header" value="Your header" class="form-control input-inline input-800"><br>
                                      
                    <label for="member_description">Description: </label>
                    <textarea name="member_description" rows="4" class="form-control input-800" style="height: 85px; resize: none;">Your description</textarea>
                    
                    <label for="member_img">IMG: </label>
                    <input type="text" name="member_img" value="" class="form-control input-inline input-800"><br>
                    
                    <label for="member_background_img">Bacdground IMG: </label>
                    <input type="text" name="member_background_img" value="" class="form-control input-inline input-800"><br>
                    
                    <label for="member_button_text">Button text: </label>
                    <input type="text" name="member_button_text" value="" class="form-control input-inline input-800"><br>
                    
                    <label for="member_button_url">Button URL: </label>
                    <input type="text" name="member_button_url" value="" class="form-control input-inline input-800"><br>
                </td>
                
                <td class="text-left">
                    <label for="member_header_size">Header size: </label>
                    <select name="member_header_size" class="form-control input-inline">
                        ${optionBoxesHeader}
                    </select><br>
                    
                    <label for="member_header_color">Header color: </label>
                    <input type="color" name="member_header_color" value="#5900ff" class="form-control input-inline"><br>
                    
                    <label for="member_description_size">Description size: </label>
                    <select name="member_description_size" class="form-control input-inline">
                        ${optionBoxesDescription}
                    </select><br>
                    
                    <label for="member_description_color">Description color: </label>
                    <input type="color" name="member_description_color" value="#2e273a" class="form-control input-inline"><br>
                    
                    <label for="member_background_color">Background color: </label>
                    <input type="color" name="member_background_color" value="#c9c9c9" class="form-control input-inline"><br>
                                      
                    <label for="member_button_color">Button colors: </label>
                    <label for="member_background_color">bkgd / text / bord</label>
                    <div class="flex-container-slider">
                        <input type="color" name="member_button_color" value="#7600ad" class="form-control button_colors_slider">
                        <input type="color" name="member_button_color_text" value="#fad6ff" class="form-control button_colors_slider">
                        <input type="color" name="member_button_color_border" value="#6c008a" class="form-control button_colors_slider">
                    </div><br>
                    
                    <label for="mmnew_tab">Open in new tab: </label>
                    <input type="checkbox" name="mmnew_tab">
                  
                </td>
                
                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
  `;
            tbody.appendChild(row);
            addRowListeners(row);
        }

        function removeRow(row) {
            row.remove();
        }

        function moveRow(row, direction) {
            const tbody = row.parentNode;
            const rows = Array.from(tbody.children);
            const index = rows.indexOf(row);
            const newIndex = index + direction;

            if (newIndex >= 0 && newIndex < rows.length) {
                const siblingRow = rows[newIndex];
                if (direction === 1) {
                    tbody.insertBefore(row, siblingRow.nextSibling);
                } else {
                    tbody.insertBefore(row, siblingRow);
                }
            } else if (newIndex === -1) {
                tbody.insertBefore(row, rows[0]);
            } else if (newIndex === rows.length) {
                tbody.insertBefore(row, null);
            }
        }

        function addRowListeners(row) {
            const removeButton = row.querySelector("[name='remove-row']");
            const moveUpButton = row.querySelector("[name='move-up']");
            const moveDownButton = row.querySelector("[name='move-down']");

            removeButton.addEventListener("click", () => {
                removeRow(row);
            });

            moveUpButton.addEventListener("click", () => {
                moveRow(row, -1);
            });

            moveDownButton.addEventListener("click", () => {
                moveRow(row, 1);
            });
        }

        addRowButton.addEventListener("click", () => {
            addRow();
        });

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const height = this.data && this.data.height ? this.data.height : "";
        $(render).find("[name='height']").val(height);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#ffffff');
        }

        if (this.data.disable_nav_button === true) {
            $(render).find("[name='disable_nav_button']").attr('checked', 'checked');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }

        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }

        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }
        function generateOptionBoxes(select) {
            let sizes = ['8px', '10px', '12px', '14px', '18px', '24px', '38px', '42px', '54px', '62px'];
            let options = "";
            for (let i = 0; i < sizes.length; i++) {
                if (select === ""){
                    select = '24px';
                }
                if (sizes[i] === select) {
                    options += '<option selected value="' + sizes[i] + '">' + sizes[i] + '</option>';
                }else{
                    options += '<option value="' + sizes[i] + '">' + sizes[i] + '</option>';
                }
            }
            return options;
        }
        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {

        var disable_nav_button = false;
        if ($(content).find("[name='disable_nav_button']").is(':checked')) {
            disable_nav_button = true;
        }

        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }

        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }

        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }

        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }

        var disable_header = false;
        if ($(content).find("[name='disable_header']").is(':checked')) {
            disable_header = true;
        }

        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        const table = content.querySelector("[name='PromoSliderTable']")
        const rows = table.querySelectorAll('tbody tr');
        const data = {};
        rows.forEach((row, index) => {
            const inputs = row.querySelectorAll('input');
            const textareas = row.querySelectorAll('textarea');
            const selects = row.querySelectorAll('select');
            const values = {};
            inputs.forEach(input => {
                const name = input.getAttribute('name');
                if (name === 'member_header') {
                    values[name] = btoa(encodeURIComponent(input.value));
                }
                if (name === 'member_img') {
                    values[name] = input.value;
                }
                if (name === 'member_background_img') {
                    values[name] = input.value;
                }
                if (name === 'member_header_color') {
                    values[name] = input.value;
                }
                if (name === 'member_description_color') {
                    values[name] = input.value;
                }
                if (name === 'member_background_color') {
                    values[name] = input.value;
                }
                if (name === 'member_button_text') {
                    values[name] = input.value;
                }
                if (name === 'member_button_url') {
                    values[name] = input.value;
                }
                if (name === 'member_button_url') {
                    values[name] = input.value;
                }
                if (name === 'member_button_color') {
                    values[name] = input.value;
                }
                if (name === 'member_button_color_text') {
                    values[name] = input.value;
                }
                if (name === 'member_button_color_border') {
                    values[name] = input.value;
                }
                if (name === 'mmnew_tab') {
                    if ($(inputs).is(':checked')) {
                        values[name] = true;
                    }else{
                        values[name] = false;
                    }
                }
            });

            textareas.forEach(textarea => {
                const name = textarea.getAttribute('name');
                if (name === 'member_description') {
                    values[name] = btoa(encodeURIComponent(textarea.value));
                }
            });

            selects.forEach(select => {
                const name = select.getAttribute('name');
                if (name === 'member_header_size') {
                    values[name] = select.value;
                }
                if (name === 'member_description_size') {
                    values[name] = select.value;
                }
            });

            if (Object.keys(values).length > 0) {
                data[index] = values;
            }
        });

        return {
            "background_image": $(content).find("[name='background_image']").val().replace(/	/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/	/g, ""),
            "width": $(content).find("[name='width']").val().replace(/	/g, ""),
            "height": $(content).find("[name='height']").val().replace(/	/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/	/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/	/g, ""),
            "style": style.replace(/	/g, ""),

            "disable_nav_button": disable_nav_button,
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,
            "members": data
        };
    }
    isBase64(str) {
        try {
            return btoa(atob(str)) == str;
        } catch (err) {
            return false;
        }
    }
}

