<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
        padding-bottom: 40px;
    }

    .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        padding: 48px 20px 36px 20px;
    {if !$data['disable_header']}
        background-color: {$data['header_background_color']};
        {if $data['header_background_img'] neq ''}
            background-image: url("{$data['header_background_img']}");
            background-size: cover;
            background-position: center;
            {if $data['header_background_fix']}
                background-attachment: fixed;
            {/if}
        {/if}
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    {/if}
    }

    {if !$data['disable_header'] && $data['header_background_darken']}
    .{$name}-{$id}-header::before {
        content: "";
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    }
    {/if}

    .{$name}-{$id}-header-title {
        position: relative;
        z-index: 1;
        font-size: 2rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 8px 0;
        line-height: 1.3;
    }

    .{$name}-{$id}-header-desc {
        position: relative;
        z-index: 1;
        font-size: 1.05rem;
        color: {$data['header_description_color']};
        margin: 0;
        line-height: 1.6;
        max-width: 620px;
        margin-left: auto;
        margin-right: auto;
    }

    .{$name}-{$id}-grid {
        position: relative;
        z-index: 2;
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        align-items: stretch;
        gap: 28px;
        max-width: {$data['width']};
        margin: 0 auto;
        padding-top: 32px;
    }

    .{$name}-{$id}-card {
        position: relative;
        display: flex;
        flex-direction: column;
        width: {$data['card_width']};
        background: {$data['color_6']};
        border: 1px solid {$data['color_7']};
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 2px 12px {$data['color_7']}33;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .{$name}-{$id}-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 12px 32px {$data['color_7']}55;
    }

    .{$name}-{$id}-card-img {
        width: 100%;
        height: 180px;
        object-fit: cover;
        display: block;
    }

    .{$name}-{$id}-card-body {
        display: flex;
        flex-direction: column;
        flex: 1;
        padding: 24px;
    }

    .{$name}-{$id}-label {
        position: absolute;
        top: 14px;
        right: 14px;
        padding: 4px 14px;
        border-radius: 50px;
        font-size: 0.7rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1px;
        z-index: 3;
        line-height: 1.5;
    }

    .{$name}-{$id}-label-hot {
        background: {$data['hot_color']};
        color: {$data['hot_text_color']};
    }

    .{$name}-{$id}-label-new {
        background: {$data['new_color']};
        color: {$data['new_text_color']};
    }

    .{$name}-{$id}-label-sale {
        background: {$data['sale_color']};
        color: {$data['sale_text_color']};
    }

    .{$name}-{$id}-group {
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        color: {$data['color_2']};
        margin-bottom: 6px;
    }

    .{$name}-{$id}-product-name {
        font-size: 1.25rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 14px;
        line-height: 1.3;
    }

    .{$name}-{$id}-price-block {
        margin-bottom: 16px;
    }

    .{$name}-{$id}-price {
        font-size: 1.5rem;
        font-weight: 800;
        color: {$data['color_3']};
        line-height: 1.2;
    }

    .{$name}-{$id}-cycle {
        font-size: 0.8rem;
        color: {$data['color_4']};
        margin-top: 2px;
    }

    .{$name}-{$id}-desc {
        font-size: 0.88rem;
        color: {$data['color_5']};
        line-height: 1.65;
        flex: 1;
        margin-bottom: 20px;
    }

    .{$name}-{$id}-btn {
        display: inline-block;
        width: 100%;
        text-align: center;
        padding: 12px 24px;
        margin-top: auto;
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        border: none;
        border-radius: 8px;
        font-size: 0.95rem;
        font-weight: 600;
        text-decoration: none;
        transition: filter 0.25s ease, transform 0.25s ease;
        cursor: pointer;
        box-sizing: border-box;
    }

    .{$name}-{$id}-btn:hover {
        filter: brightness(1.1);
        transform: translateY(-2px);
        color: {$data['order_now_button_text_color']};
        text-decoration: none;
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-grid {
            gap: 20px;
            padding-top: 24px;
        }
        .{$name}-{$id}-card {
            width: 100%;
            max-width: 400px;
        }
        .{$name}-{$id}-header-title {
            font-size: 1.5rem;
        }
        .{$name}-{$id}-header {
            padding: 32px 16px 28px 16px;
        }
        .{$name}-{$id}-card-body {
            padding: 18px;
        }
        .{$name}-{$id}-price {
            font-size: 1.3rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if !$data['disable_header'] && ($data['header_text'] neq '' || $data['header_description'] neq '')}
        <div class="{$name}-{$id}-header">
            {if $data['header_text'] neq ''}
                <h2 class="{$name}-{$id}-header-title">{$data['header_text']}</h2>
            {/if}
            {if $data['header_description'] neq ''}
                <p class="{$name}-{$id}-header-desc">{$data['header_description']}</p>
            {/if}
        </div>
    {/if}

    <div class="{$name}-{$id}-grid">
        {foreach $data['products'] as $product}
            <div class="{$name}-{$id}-card">
                {if $product['product_label']}
                    {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                    <span class="{$name}-{$id}-label {$name}-{$id}-label-{$product['product_label']}">{$data[$lbl_key]}</span>
                {/if}

                {if $product['product_img'] neq ''}
                    <img class="{$name}-{$id}-card-img" src="{$product['product_img']}" alt="{$product['product_name']}" />
                {/if}

                <div class="{$name}-{$id}-card-body">
                    {if $product['product_group_name'] neq ''}
                        <div class="{$name}-{$id}-group">{$product['product_group_name']}</div>
                    {/if}

                    <div class="{$name}-{$id}-product-name">{$product['product_name']}</div>

                    <div class="{$name}-{$id}-price-block">
                        <div class="{$name}-{$id}-price">{$product['product_price']['amount_string']}</div>
                        {if !$product['product_price_free'] && $product['product_price']['cycle'] neq ''}
                            <div class="{$name}-{$id}-cycle">{$product['product_price']['cycle']}</div>
                        {/if}
                    </div>

                    {if $product['product_description'] neq ''}
                        <div class="{$name}-{$id}-desc">{$product['product_description']}</div>
                    {/if}

                    <a href="{$product['product_order_url']}" class="{$name}-{$id}-btn">{$data['order_now_button_name']}</a>
                </div>
            </div>
        {/foreach}
    </div>
</div>
