<style>
    .{$name}-{$id}-wave-wrap {
        position: relative;
        z-index: 2;
        max-width: {if $data['width'] neq ''}{$data['width']}{else}1200px{/if};
        margin: 0 auto;
        padding: 0 16px;
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    }

    /* ---- header ---- */
    {if !$data['disable_header']}
    .{$name}-{$id}-wave-header {
        position: relative;
        text-align: center;
        padding: 48px 24px;
        margin-bottom: 32px;
        border-radius: 14px;
        overflow: hidden;
        background-color: {$data['header_background_color']};
    {if $data['header_background_img'] neq ''}
        background-image: url("{$data['header_background_img']}");
        background-size: cover;
        background-position: center;
        {if $data['header_background_fix']}
        background-attachment: fixed;
        {/if}
    {/if}
    }
    {if $data['header_background_darken']}
    .{$name}-{$id}-wave-header::before {
        content: "";
        position: absolute;
        inset: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        z-index: 0;
    }
    {/if}
    .{$name}-{$id}-wave-header > * {
        position: relative;
        z-index: 1;
    }
    .{$name}-{$id}-wave-htitle {
        font-size: 2rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 8px 0;
    }
    .{$name}-{$id}-wave-hdesc {
        font-size: 1.05rem;
        color: {$data['header_description_color']};
        margin: 0;
    }
    {/if}

    /* ---- grid ---- */
    .{$name}-{$id}-wave-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax({if $data['card_width'] neq ''}{$data['card_width']}{else}300px{/if}, 1fr));
        gap: 28px;
    }

    /* ---- card ---- */
    .{$name}-{$id}-wave-card {
        position: relative;
        display: flex;
        flex-direction: column;
        background: {$data['color_6']};
        border: 1px solid {$data['color_7']};
        border-radius: 16px;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .{$name}-{$id}-wave-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 16px 40px {$data['color_7']};
    }

    /* ---- accent top section ---- */
    .{$name}-{$id}-wave-top {
        position: relative;
        background: {$data['color_7']};
        padding: 28px 24px 40px 24px;
        text-align: center;
    }
    .{$name}-{$id}-wave-top-hasimg {
        background-size: cover;
        background-position: center;
    }
    .{$name}-{$id}-wave-top-hasimg::after {
        content: "";
        position: absolute;
        inset: 0;
        background: {$data['color_7']};
        opacity: 0.75;
    }
    .{$name}-{$id}-wave-top > * {
        position: relative;
        z-index: 2;
    }

    .{$name}-{$id}-wave-grp {
        font-size: 0.7rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        color: {$data['color_2']};
        margin-bottom: 6px;
    }
    .{$name}-{$id}-wave-pname {
        font-size: 1.3rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0;
        line-height: 1.3;
    }

    /* ---- wave SVG separator ---- */
    .{$name}-{$id}-wave-svg {
        position: relative;
        display: block;
        width: 100%;
        height: 36px;
        margin-top: -1px;
    }
    .{$name}-{$id}-wave-svg svg {
        display: block;
        width: 100%;
        height: 100%;
    }

    /* ---- diagonal ribbon badge (top-right) ---- */
    .{$name}-{$id}-wave-ribbon {
        position: absolute;
        top: 0;
        right: 0;
        width: 90px;
        height: 90px;
        overflow: hidden;
        z-index: 5;
        pointer-events: none;
    }
    .{$name}-{$id}-wave-ribbon-inner {
        position: absolute;
        top: 18px;
        right: -24px;
        width: 120px;
        text-align: center;
        padding: 4px 0;
        font-size: 0.62rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1px;
        transform: rotate(45deg);
        transform-origin: center;
    }
    .{$name}-{$id}-wave-ribbon-hot {
        background: {$data['hot_color']};
        color: {$data['hot_text_color']};
    }
    .{$name}-{$id}-wave-ribbon-new {
        background: {$data['new_color']};
        color: {$data['new_text_color']};
    }
    .{$name}-{$id}-wave-ribbon-sale {
        background: {$data['sale_color']};
        color: {$data['sale_text_color']};
    }

    /* ---- body ---- */
    .{$name}-{$id}-wave-body {
        padding: 8px 24px 28px 24px;
        text-align: center;
        flex: 1;
        display: flex;
        flex-direction: column;
    }

    /* ---- circular price highlight ---- */
    .{$name}-{$id}-wave-pricecircle {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        border: 3px solid {$data['color_7']};
        background: {$data['color_6']};
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin: -58px auto 16px auto;
        position: relative;
        z-index: 3;
    }
    .{$name}-{$id}-wave-price {
        font-size: 1.15rem;
        font-weight: 800;
        color: {$data['color_3']};
        line-height: 1.2;
    }
    .{$name}-{$id}-wave-cycle {
        font-size: 0.62rem;
        color: {$data['color_4']};
    }

    .{$name}-{$id}-wave-desc {
        font-size: 0.88rem;
        color: {$data['color_5']};
        line-height: 1.65;
        margin-bottom: 20px;
    }

    /* ---- pill button ---- */
    .{$name}-{$id}-wave-btn {
        display: inline-block;
        padding: 11px 32px;
        margin-top: auto;
        font-size: 0.9rem;
        font-weight: 600;
        text-decoration: none;
        border-radius: 50px;
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        border: none;
        transition: filter 0.25s ease, transform 0.25s ease, box-shadow 0.25s ease;
    }
    .{$name}-{$id}-wave-btn:hover {
        filter: brightness(1.12);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px {$data['order_now_button_color']};
        text-decoration: none;
        color: {$data['order_now_button_text_color']};
    }

    /* ---- responsive ---- */
    @media (max-width: 768px) {
        .{$name}-{$id}-wave-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }
        .{$name}-{$id}-wave-htitle {
            font-size: 1.5rem;
        }
        .{$name}-{$id}-wave-top {
            padding: 22px 18px 34px 18px;
        }
        .{$name}-{$id}-wave-body {
            padding: 8px 18px 22px 18px;
        }
        .{$name}-{$id}-wave-pricecircle {
            width: 88px;
            height: 88px;
            margin-top: -50px;
        }
        .{$name}-{$id}-wave-price {
            font-size: 1rem;
        }
        .{$name}-{$id}-wave-pname {
            font-size: 1.1rem;
        }
    }
</style>

<div class="{$name}-{$id}-wave-wrap">

    {if !$data['disable_header']}
    <div class="{$name}-{$id}-wave-header">
        {if $data['header_text'] neq ''}
            <h2 class="{$name}-{$id}-wave-htitle">{$data['header_text']}</h2>
        {/if}
        {if $data['header_description'] neq ''}
            <p class="{$name}-{$id}-wave-hdesc">{$data['header_description']}</p>
        {/if}
    </div>
    {/if}

    <div class="{$name}-{$id}-wave-grid">
        {foreach $data['products'] as $product}
        <div class="{$name}-{$id}-wave-card">

            {if $product['product_label']}
                {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                <div class="{$name}-{$id}-wave-ribbon">
                    <span class="{$name}-{$id}-wave-ribbon-inner {$name}-{$id}-wave-ribbon-{$product['product_label']}">{$data[$lbl_key]}</span>
                </div>
            {/if}

            <div class="{$name}-{$id}-wave-top{if $product['product_img'] neq ''} {$name}-{$id}-wave-top-hasimg{/if}"
                 {if $product['product_img'] neq ''}style="background-image:url('{$product['product_img']}')"{/if}>
                {if $product['product_group_name'] neq ''}
                    <div class="{$name}-{$id}-wave-grp">{$product['product_group_name']}</div>
                {/if}
                <h3 class="{$name}-{$id}-wave-pname">{$product['product_name']}</h3>
            </div>

            <div class="{$name}-{$id}-wave-svg">
                <svg viewBox="0 0 500 50" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0,0 L0,30 Q62.5,50 125,30 T250,30 T375,30 T500,30 L500,0 Z" fill="{$data['color_7']}" />
                </svg>
            </div>

            <div class="{$name}-{$id}-wave-body">
                <div class="{$name}-{$id}-wave-pricecircle">
                    <span class="{$name}-{$id}-wave-price">{$product['product_price']['amount_string']}</span>
                    {if $product['product_price']['cycle'] neq ''}
                        <span class="{$name}-{$id}-wave-cycle">{$product['product_price']['cycle']}</span>
                    {/if}
                </div>

                {if $product['product_description'] neq ''}
                    <div class="{$name}-{$id}-wave-desc">{$product['product_description']}</div>
                {/if}

                <a href="{$product['product_order_url']}" class="{$name}-{$id}-wave-btn">
                    {if $data['order_now_button_name'] neq ''}{$data['order_now_button_name']}{else}Order Now{/if}
                </a>
            </div>

        </div>
        {/foreach}
    </div>

</div>
