<style>
    .{$name}-{$id}-tile-wrap {
        position: relative;
        z-index: 2;
        max-width: {if $data['width'] neq ''}{$data['width']}{else}1100px{/if};
        margin: 0 auto;
        padding: 0 12px;
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    }

    /* ---- header ---- */
    {if !$data['disable_header']}
    .{$name}-{$id}-tile-header {
        position: relative;
        text-align: center;
        padding: 40px 20px;
        margin-bottom: 24px;
        border-radius: 12px;
        overflow: hidden;
        background-color: {$data['header_background_color']};
    {if $data['header_background_img'] neq ''}
        background-image: url("{$data['header_background_img']}");
        background-size: cover;
        background-position: center;
        {if $data['header_background_fix']}
        background-attachment: fixed;
        {/if}
    {/if}
    }
    {if $data['header_background_darken']}
    .{$name}-{$id}-tile-header::before {
        content: "";
        position: absolute;
        inset: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        z-index: 0;
    }
    {/if}
    .{$name}-{$id}-tile-header > * {
        position: relative;
        z-index: 1;
    }
    .{$name}-{$id}-tile-htitle {
        font-size: 1.8rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 6px 0;
    }
    .{$name}-{$id}-tile-hdesc {
        font-size: 0.95rem;
        color: {$data['header_description_color']};
        margin: 0;
    }
    {/if}

    /* ---- grid ---- */
    .{$name}-{$id}-tile-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 14px;
    }

    /* ---- tile card ---- */
    .{$name}-{$id}-tile-card {
        position: relative;
        display: flex;
        flex-direction: column;
        align-items: center;
        background: {$data['color_6']};
        border: 1px solid {$data['color_7']};
        border-radius: 14px;
        padding: 24px 16px 20px 16px;
        text-align: center;
        transition: transform 0.25s ease, border-color 0.25s ease, box-shadow 0.25s ease;
        overflow: hidden;
    }
    .{$name}-{$id}-tile-card:hover {
        transform: translateY(-6px);
        border-color: {$data['color_7']};
        box-shadow: 0 12px 32px {$data['color_7']};
    }

    /* ---- badge (dot + text) ---- */
    .{$name}-{$id}-tile-badge {
        position: absolute;
        top: 10px;
        right: 10px;
        display: flex;
        align-items: center;
        gap: 4px;
        font-size: 0.58rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.8px;
    }
    .{$name}-{$id}-tile-badge-dot {
        width: 7px;
        height: 7px;
        border-radius: 50%;
        display: inline-block;
        flex-shrink: 0;
    }
    .{$name}-{$id}-tile-badge-hot {
        color: {$data['hot_text_color']};
    }
    .{$name}-{$id}-tile-badge-hot .{$name}-{$id}-tile-badge-dot {
        background: {$data['hot_color']};
    }
    .{$name}-{$id}-tile-badge-hot .{$name}-{$id}-tile-badge-lbl {
        background: {$data['hot_color']};
        color: {$data['hot_text_color']};
        padding: 1px 6px;
        border-radius: 3px;
    }
    .{$name}-{$id}-tile-badge-new {
        color: {$data['new_text_color']};
    }
    .{$name}-{$id}-tile-badge-new .{$name}-{$id}-tile-badge-dot {
        background: {$data['new_color']};
    }
    .{$name}-{$id}-tile-badge-new .{$name}-{$id}-tile-badge-lbl {
        background: {$data['new_color']};
        color: {$data['new_text_color']};
        padding: 1px 6px;
        border-radius: 3px;
    }
    .{$name}-{$id}-tile-badge-sale {
        color: {$data['sale_text_color']};
    }
    .{$name}-{$id}-tile-badge-sale .{$name}-{$id}-tile-badge-dot {
        background: {$data['sale_color']};
    }
    .{$name}-{$id}-tile-badge-sale .{$name}-{$id}-tile-badge-lbl {
        background: {$data['sale_color']};
        color: {$data['sale_text_color']};
        padding: 1px 6px;
        border-radius: 3px;
    }

    /* ---- circle image ---- */
    .{$name}-{$id}-tile-img {
        width: 64px;
        height: 64px;
        border-radius: 50%;
        object-fit: cover;
        margin: 0 auto 14px auto;
        display: block;
        border: 2px solid {$data['color_7']};
    }
    .{$name}-{$id}-tile-noimg {
        width: 64px;
        height: 64px;
        border-radius: 50%;
        margin: 0 auto 14px auto;
        display: flex;
        align-items: center;
        justify-content: center;
        background: {$data['color_7']};
        font-size: 1.4rem;
        font-weight: 700;
        color: {$data['color_6']};
    }

    /* ---- group ---- */
    .{$name}-{$id}-tile-grp {
        font-size: 0.62rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        color: {$data['color_2']};
        margin-bottom: 4px;
    }

    /* ---- product name ---- */
    .{$name}-{$id}-tile-pname {
        font-size: 0.92rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 10px 0;
        line-height: 1.3;
    }

    /* ---- price ---- */
    .{$name}-{$id}-tile-price {
        font-size: 1.2rem;
        font-weight: 800;
        color: {$data['color_3']};
        margin-bottom: 2px;
    }
    .{$name}-{$id}-tile-cycle {
        font-size: 0.65rem;
        color: {$data['color_4']};
        margin-bottom: 14px;
    }

    /* ---- pill button ---- */
    .{$name}-{$id}-tile-btn {
        display: inline-block;
        padding: 7px 20px;
        margin-top: auto;
        font-size: 0.76rem;
        font-weight: 600;
        text-decoration: none;
        border-radius: 50px;
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        border: none;
        transition: filter 0.2s ease, transform 0.2s ease;
    }
    .{$name}-{$id}-tile-btn:hover {
        filter: brightness(1.12);
        transform: translateY(-1px);
        text-decoration: none;
        color: {$data['order_now_button_text_color']};
    }

    /* ---- responsive ---- */
    @media (max-width: 992px) {
        .{$name}-{$id}-tile-grid {
            grid-template-columns: repeat(3, 1fr);
        }
    }
    @media (max-width: 768px) {
        .{$name}-{$id}-tile-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }
        .{$name}-{$id}-tile-card {
            padding: 20px 12px 16px 12px;
        }
        .{$name}-{$id}-tile-img,
        .{$name}-{$id}-tile-noimg {
            width: 52px;
            height: 52px;
        }
        .{$name}-{$id}-tile-pname {
            font-size: 0.82rem;
        }
        .{$name}-{$id}-tile-price {
            font-size: 1rem;
        }
        .{$name}-{$id}-tile-htitle {
            font-size: 1.3rem;
        }
    }
    @media (max-width: 480px) {
        .{$name}-{$id}-tile-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }
</style>

<div class="{$name}-{$id}-tile-wrap">

    {if !$data['disable_header']}
    <div class="{$name}-{$id}-tile-header">
        {if $data['header_text'] neq ''}
            <h2 class="{$name}-{$id}-tile-htitle">{$data['header_text']}</h2>
        {/if}
        {if $data['header_description'] neq ''}
            <p class="{$name}-{$id}-tile-hdesc">{$data['header_description']}</p>
        {/if}
    </div>
    {/if}

    <div class="{$name}-{$id}-tile-grid">
        {foreach $data['products'] as $product}
        <div class="{$name}-{$id}-tile-card">

            {if $product['product_label']}
                {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                <span class="{$name}-{$id}-tile-badge {$name}-{$id}-tile-badge-{$product['product_label']}">
                    <span class="{$name}-{$id}-tile-badge-dot"></span>
                    <span class="{$name}-{$id}-tile-badge-lbl">{$data[$lbl_key]}</span>
                </span>
            {/if}

            {if $product['product_img'] neq ''}
                <img src="{$product['product_img']}" alt="{$product['product_name']}" class="{$name}-{$id}-tile-img" />
            {else}
                <div class="{$name}-{$id}-tile-noimg">{$product['product_name']|truncate:1:""}</div>
            {/if}

            {if $product['product_group_name'] neq ''}
                <div class="{$name}-{$id}-tile-grp">{$product['product_group_name']}</div>
            {/if}

            <h3 class="{$name}-{$id}-tile-pname">{$product['product_name']}</h3>

            <div class="{$name}-{$id}-tile-price">{$product['product_price']['amount_string']}</div>
            {if $product['product_price']['cycle'] neq ''}
                <div class="{$name}-{$id}-tile-cycle">{$product['product_price']['cycle']}</div>
            {/if}

            <a href="{$product['product_order_url']}" class="{$name}-{$id}-tile-btn">
                {if $data['order_now_button_name'] neq ''}{$data['order_now_button_name']}{else}Order{/if}
            </a>

        </div>
        {/foreach}
    </div>

</div>
