<style>
    .{$name}-{$id}-border-wrap {
        position: relative;
        z-index: 2;
        max-width: {if $data['width'] neq ''}{$data['width']}{else}1100px{/if};
        margin: 0 auto;
        padding: 0 16px;
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    }

    /* ---- header ---- */
    {if !$data['disable_header']}
    .{$name}-{$id}-border-header {
        position: relative;
        padding: 40px 28px;
        margin-bottom: 28px;
        overflow: hidden;
        background-color: {$data['header_background_color']};
        border-left: 4px solid {$data['color_7']};
    {if $data['header_background_img'] neq ''}
        background-image: url("{$data['header_background_img']}");
        background-size: cover;
        background-position: center;
        {if $data['header_background_fix']}
        background-attachment: fixed;
        {/if}
    {/if}
    {if !$data['disable_background_radius_top']}
    {else}
    {/if}
    }
    {if $data['header_background_darken']}
    .{$name}-{$id}-border-header::before {
        content: "";
        position: absolute;
        inset: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        z-index: 0;
    }
    {/if}
    .{$name}-{$id}-border-header > * {
        position: relative;
        z-index: 1;
    }
    .{$name}-{$id}-border-htitle {
        font-size: 1.9rem;
        font-weight: 700;
        color: {$data['header_text_color']};
        margin: 0 0 6px 0;
        line-height: 1.2;
    }
    .{$name}-{$id}-border-hdesc {
        font-size: 1rem;
        color: {$data['header_description_color']};
        margin: 0;
    }
    {/if}

    /* ---- grid ---- */
    .{$name}-{$id}-border-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax({if $data['card_width'] neq ''}{$data['card_width']}{else}320px{/if}, 1fr));
        gap: 20px;
    }

    /* ---- card ---- */
    .{$name}-{$id}-border-card {
        position: relative;
        display: flex;
        flex-direction: column;
        background: {$data['color_6']};
        border-left: 4px solid {$data['color_7']};
        padding: 28px 24px 24px 24px;
        transition: border-color 0.25s ease, background 0.25s ease;
    }
    .{$name}-{$id}-border-card:hover {
        border-left-width: 6px;
        filter: brightness(1.02);
    }

    /* ---- badge (square flag top-left) ---- */
    .{$name}-{$id}-border-badge {
        position: absolute;
        top: 0;
        left: -4px;
        padding: 3px 10px;
        font-size: 0.65rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 1px;
        line-height: 1.6;
    }
    .{$name}-{$id}-border-card:hover .{$name}-{$id}-border-badge {
        left: -6px;
    }
    .{$name}-{$id}-border-badge-hot {
        background: {$data['hot_color']};
        color: {$data['hot_text_color']};
    }
    .{$name}-{$id}-border-badge-new {
        background: {$data['new_color']};
        color: {$data['new_text_color']};
    }
    .{$name}-{$id}-border-badge-sale {
        background: {$data['sale_color']};
        color: {$data['sale_text_color']};
    }

    /* ---- image ---- */
    .{$name}-{$id}-border-img {
        width: 100%;
        height: 160px;
        object-fit: cover;
        margin-bottom: 16px;
    }

    /* ---- group tag ---- */
    .{$name}-{$id}-border-grp {
        display: inline-block;
        font-size: 0.68rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1.2px;
        color: {$data['color_2']};
        border: 1px solid {$data['color_2']};
        padding: 2px 10px;
        margin-bottom: 8px;
    }

    /* ---- product name ---- */
    .{$name}-{$id}-border-pname {
        font-size: 1.2rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 12px 0;
        line-height: 1.3;
    }

    /* ---- price row ---- */
    .{$name}-{$id}-border-pricerow {
        display: flex;
        align-items: baseline;
        justify-content: space-between;
        margin-bottom: 12px;
    }
    .{$name}-{$id}-border-desc {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.65;
        margin-bottom: 16px;
        flex: 1;
    }
    .{$name}-{$id}-border-price {
        font-size: 1.4rem;
        font-weight: 800;
        color: {$data['color_3']};
        text-align: right;
        white-space: nowrap;
    }
    .{$name}-{$id}-border-cycle {
        display: block;
        font-size: 0.75rem;
        font-weight: 400;
        color: {$data['color_4']};
    }

    /* ---- outlined button ---- */
    .{$name}-{$id}-border-btn {
        display: inline-block;
        padding: 10px 26px;
        margin-top: auto;
        font-size: 0.88rem;
        font-weight: 600;
        text-decoration: none;
        background: transparent;
        color: {$data['order_now_button_color']};
        border: 2px solid {$data['order_now_button_color']};
        transition: background 0.25s ease, color 0.25s ease, transform 0.2s ease;
    }
    .{$name}-{$id}-border-btn:hover {
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        transform: translateY(-2px);
        text-decoration: none;
    }

    /* ---- responsive ---- */
    @media (max-width: 768px) {
        .{$name}-{$id}-border-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id}-border-htitle {
            font-size: 1.4rem;
        }
        .{$name}-{$id}-border-pricerow {
            flex-direction: column;
            gap: 4px;
        }
        .{$name}-{$id}-border-price {
            text-align: left;
        }
        .{$name}-{$id}-border-card {
            padding: 22px 18px 18px 18px;
        }
    }
</style>

<div class="{$name}-{$id}-border-wrap">

    {if !$data['disable_header']}
    <div class="{$name}-{$id}-border-header">
        {if $data['header_text'] neq ''}
            <h2 class="{$name}-{$id}-border-htitle">{$data['header_text']}</h2>
        {/if}
        {if $data['header_description'] neq ''}
            <p class="{$name}-{$id}-border-hdesc">{$data['header_description']}</p>
        {/if}
    </div>
    {/if}

    <div class="{$name}-{$id}-border-grid">
        {foreach $data['products'] as $product}
        <div class="{$name}-{$id}-border-card">

            {if $product['product_label']}
                {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                <span class="{$name}-{$id}-border-badge {$name}-{$id}-border-badge-{$product['product_label']}">{$data[$lbl_key]}</span>
            {/if}

            {if $product['product_img'] neq ''}
                <img src="{$product['product_img']}" alt="{$product['product_name']}" class="{$name}-{$id}-border-img" />
            {/if}

            {if $product['product_group_name'] neq ''}
                <span class="{$name}-{$id}-border-grp">{$product['product_group_name']}</span>
            {/if}

            <h3 class="{$name}-{$id}-border-pname">{$product['product_name']}</h3>

            <div class="{$name}-{$id}-border-pricerow">
                {if $product['product_description'] neq ''}
                    <div class="{$name}-{$id}-border-desc">{$product['product_description']}</div>
                {/if}
                <div class="{$name}-{$id}-border-price">
                    {$product['product_price']['amount_string']}
                    {if $product['product_price']['cycle'] neq ''}
                        <span class="{$name}-{$id}-border-cycle">{$product['product_price']['cycle']}</span>
                    {/if}
                </div>
            </div>

            <a href="{$product['product_order_url']}" class="{$name}-{$id}-border-btn">
                {if $data['order_now_button_name'] neq ''}{$data['order_now_button_name']}{else}Order Now{/if}
            </a>

        </div>
        {/foreach}
    </div>

</div>
