<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
        padding-bottom: 40px;
    }

    .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        padding: 52px 20px 40px 20px;
    {if !$data['disable_header']}
        background-color: {$data['header_background_color']};
        {if $data['header_background_img'] neq ''}
            background-image: url("{$data['header_background_img']}");
            background-size: cover;
            background-position: center;
            {if $data['header_background_fix']}
                background-attachment: fixed;
            {/if}
        {/if}
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    {/if}
    }

    {if !$data['disable_header'] && $data['header_background_darken']}
    .{$name}-{$id}-header::before {
        content: "";
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: {$data['header_background_color']};
        opacity: 0.55;
        {if !$data['disable_background_radius_top']}
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        {/if}
    }
    {/if}

    .{$name}-{$id}-header-title {
        position: relative;
        z-index: 1;
        font-size: 2.4rem;
        font-weight: 800;
        color: {$data['header_text_color']};
        margin: 0 0 10px 0;
        line-height: 1.15;
        letter-spacing: -1px;
    }

    .{$name}-{$id}-header-desc {
        position: relative;
        z-index: 1;
        font-size: 1.05rem;
        color: {$data['header_description_color']};
        margin: 0;
        line-height: 1.6;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }

    .{$name}-{$id}-grid {
        position: relative;
        z-index: 2;
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        align-items: stretch;
        gap: 24px;
        max-width: {$data['width']};
        margin: 0 auto;
        padding-top: 36px;
    }

    .{$name}-{$id}-card {
        position: relative;
        display: flex;
        flex-direction: column;
        width: {$data['card_width']};
        background: {$data['color_6']};
        border: 1px solid {$data['color_7']};
        border-radius: 10px;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .{$name}-{$id}-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 16px 48px {$data['color_7']}33;
    }

    .{$name}-{$id}-label-strip {
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        width: 6px;
        z-index: 3;
    }

    .{$name}-{$id}-label-strip-hot {
        background: {$data['hot_color']};
    }

    .{$name}-{$id}-label-strip-new {
        background: {$data['new_color']};
    }

    .{$name}-{$id}-label-strip-sale {
        background: {$data['sale_color']};
    }

    .{$name}-{$id}-label-text {
        position: absolute;
        top: 16px;
        left: 16px;
        font-size: 0.65rem;
        font-weight: 800;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        z-index: 4;
        line-height: 1;
    }

    .{$name}-{$id}-label-text-hot {
        color: {$data['hot_color']};
    }

    .{$name}-{$id}-label-text-new {
        color: {$data['new_color']};
    }

    .{$name}-{$id}-label-text-sale {
        color: {$data['sale_color']};
    }

    .{$name}-{$id}-card-body {
        display: flex;
        flex-direction: column;
        flex: 1;
        padding: 36px 32px 28px 32px;
        text-align: center;
    }

    .{$name}-{$id}-price-hero {
        font-size: 3rem;
        font-weight: 900;
        color: {$data['color_3']};
        line-height: 1;
        letter-spacing: -1.5px;
        margin-bottom: 4px;
    }

    .{$name}-{$id}-cycle {
        font-size: 0.82rem;
        color: {$data['color_4']};
        font-weight: 400;
        margin-bottom: 24px;
    }

    .{$name}-{$id}-product-name {
        font-size: 1.2rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 6px;
        line-height: 1.3;
    }

    .{$name}-{$id}-group {
        font-size: 0.72rem;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        color: {$data['color_2']};
        margin-bottom: 16px;
    }

    .{$name}-{$id}-desc {
        font-size: 0.82rem;
        color: {$data['color_5']};
        line-height: 1.7;
        flex: 1;
        margin-bottom: 24px;
    }

    .{$name}-{$id}-btn {
        display: block;
        width: 100%;
        text-align: center;
        padding: 14px 24px;
        background: {$data['order_now_button_color']};
        color: {$data['order_now_button_text_color']};
        border: none;
        border-radius: 0 0 9px 9px;
        font-size: 0.95rem;
        font-weight: 700;
        text-decoration: none;
        text-transform: uppercase;
        letter-spacing: 1px;
        transition: filter 0.25s ease;
        cursor: pointer;
        box-sizing: border-box;
        margin-top: auto;
    }

    .{$name}-{$id}-btn:hover {
        filter: brightness(1.12);
        color: {$data['order_now_button_text_color']};
        text-decoration: none;
    }

    @media (max-width: 768px) {
        .{$name}-{$id}-grid {
            gap: 20px;
            padding-top: 24px;
        }
        .{$name}-{$id}-card {
            width: 100%;
            max-width: 360px;
        }
        .{$name}-{$id}-header-title {
            font-size: 1.7rem;
        }
        .{$name}-{$id}-header {
            padding: 36px 16px 28px 16px;
        }
        .{$name}-{$id}-card-body {
            padding: 28px 24px 20px 24px;
        }
        .{$name}-{$id}-price-hero {
            font-size: 2.4rem;
        }
        .{$name}-{$id}-product-name {
            font-size: 1.05rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if !$data['disable_header'] && ($data['header_text'] neq '' || $data['header_description'] neq '')}
        <div class="{$name}-{$id}-header">
            {if $data['header_text'] neq ''}
                <h2 class="{$name}-{$id}-header-title">{$data['header_text']}</h2>
            {/if}
            {if $data['header_description'] neq ''}
                <p class="{$name}-{$id}-header-desc">{$data['header_description']}</p>
            {/if}
        </div>
    {/if}

    <div class="{$name}-{$id}-grid">
        {foreach $data['products'] as $product}
            <div class="{$name}-{$id}-card">
                {if $product['product_label']}
                    {assign var="lbl_key" value=$product['product_label']|cat:"_label"}
                    <div class="{$name}-{$id}-label-strip {$name}-{$id}-label-strip-{$product['product_label']}"></div>
                    <span class="{$name}-{$id}-label-text {$name}-{$id}-label-text-{$product['product_label']}">{$data[$lbl_key]}</span>
                {/if}

                <div class="{$name}-{$id}-card-body">
                    <div class="{$name}-{$id}-price-hero">{$product['product_price']['amount_string']}</div>
                    {if !$product['product_price_free'] && $product['product_price']['cycle'] neq ''}
                        <div class="{$name}-{$id}-cycle">{$product['product_price']['cycle']}</div>
                    {else}
                        <div class="{$name}-{$id}-cycle">&nbsp;</div>
                    {/if}

                    <div class="{$name}-{$id}-product-name">{$product['product_name']}</div>

                    {if $product['product_group_name'] neq ''}
                        <div class="{$name}-{$id}-group">{$product['product_group_name']}</div>
                    {/if}

                    {if $product['product_description'] neq ''}
                        <div class="{$name}-{$id}-desc">{$product['product_description']}</div>
                    {/if}
                </div>

                <a href="{$product['product_order_url']}" class="{$name}-{$id}-btn">{$data['order_now_button_name']}</a>
            </div>
        {/foreach}
    </div>
</div>
