<style>

    .{$name}-{$id} .puq-domain-search-container{
                       position: relative;
                       z-index: 2;
                   {if $data['width'] neq ''}
                       max-width: {$data['width']};
                   {else}
                       padding-left: 20px;
                       padding-right: 20px;
                   {/if}
                       width: 100%;
                       display: inline-block;
                       text-align: center;
                   }

    .{$name}-{$id} .puq-domain-search-header {
                       text-align: center;
                       font-size: 2rem;
                       font-weight: bold;
                       text-transform: uppercase;
                       letter-spacing: 2px;
                       margin: 1rem 0;
                       color: {$data['header_text_color']};
                   }

    .{$name}-{$id} .puq-domain-search-clearfix {
                       align-items: center;
                       justify-content: space-between;
                   }

    .{$name}-{$id} .puq-domain-search-input-group {
                       display: flex;
                       align-items: center;
                       border: 2px solid {$data['color_1']};
                       border-radius: 15px;
                       padding: 5px;
                       color: {$data['color_1']};
                   }

    .{$name}-{$id} .puq-domain-search-span-btn-group{
                       display: flex;
                   }

    .{$name}-{$id} .puq-domain-search-span-input-group{
                       display: flex;
                       width: 100%;
                   }

    .{$name}-{$id} .puq-domain-search-span-input-group i{
                       font-size: 40px;
                   }

    .{$name}-{$id} .puq-domain-search-span-input-group input{
                       font-size: 20px;
                       width: 100%;
                   }

    .{$name}-{$id} .puq-domain-search-span-input-group input::placeholder{
                       color: {$data['placeholder_text_color']};
                   }

    .{$name}-{$id} .puq-domain-search-input {
                       border: none;
                       background-color: transparent;
                       color: {$data['color_1']};
                       font-size: 16px;
                       padding: 5px;
                       flex-grow: 1;
                       border-radius: 30px;
                   }

    .{$name}-{$id} .puq-domain-search-input:focus {
                       outline: none;
                   }

    .{$name}-{$id} .puq-domain-search-btn-search,
                   .{$name}-{$id} .puq-domain-search-btn-transfer,
                                  .{$name}-{$id} .puq-domain-search-btn-buy,
                                                 .{$name}-{$id} .puq-domain-search-btn-other-extensions,
                                                                .{$name}-{$id} .puq-domain-search-btn-view-all-pricing{
                                                                                   padding: 10px 20px;
                                                                                   font-size: 16px;
                                                                                   margin: 5px;
                                                                                   cursor: pointer;
                                                                                   transition: all 0.2s ease-in-out;
                                                                                   border-radius: 5px;
                                                                                   white-space: nowrap;
                                                                               }

    .{$name}-{$id} .puq-domain-search-btn-search{
                       background-color: {$data['search_button_color']};
                       color: {$data['search_button_text_color']};
                       border: 1px solid {$data['search_button_text_color']};
                   }

    .{$name}-{$id} .puq-domain-search-btn-transfer {
                       background-color: {$data['transfer_button_color']};
                       color: {$data['transfer_button_text_color']};
                       border: 1px solid {$data['transfer_button_text_color']};
                   }
    .{$name}-{$id} .puq-domain-search-btn-buy {
                       background-color: {$data['buy_button_color']};
                       color: {$data['buy_button_text_color']};
                       border: 1px solid {$data['buy_button_text_color']};
                   }

    .{$name}-{$id} .puq-domain-search-btn-view-all-pricing {
                       background-color: {$data['view_all_pricing_button_color']};
                       color: {$data['view_all_pricing_button_text_color']};
                       border: 1px solid {$data['view_all_pricing_button_text_color']};
                       text-decoration: none;
                       display: inline-block;
                       white-space: nowrap;
                   }

    .{$name}-{$id} .puq-domain-search-btn-other-extensions{
                       background-color: {$data['show_other_extensions_button_color']};
                       color: {$data['show_other_extensions_button_text_color']};
                       border: 1px solid {$data['show_other_extensions_button_text_color']};
                   }

    .{$name}-{$id} .puq-domain-search-btn-search:hover{
                       background-color: {$data['search_button_text_color']};
                       color: {$data['search_button_color']};
                       border: 1px solid {$data['search_button_color']};
                   }

    .{$name}-{$id} .puq-domain-search-btn-transfer:hover {
                       background-color: {$data['transfer_button_text_color']};
                       color: {$data['transfer_button_color']};
                       border: 1px solid {$data['transfer_button_color']};
                   }

    .{$name}-{$id} .puq-domain-search-btn-buy:hover {
                       background-color: {$data['buy_button_text_color']};
                       color: {$data['buy_button_color']};
                       border: 1px solid {$data['buy_button_color']};
                   }

    .{$name}-{$id} .puq-domain-search-btn-view-all-pricing:hover {
                       background-color: {$data['view_all_pricing_button_text_color']};
                       color: {$data['view_all_pricing_button_color']};
                       border: 1px solid {$data['view_all_pricing_button_color']};
                   }

    .{$name}-{$id} .puq-domain-search-btn-other-extensions:hover {
                       background-color: {$data['show_other_extensions_button_text_color']};
                       color: {$data['show_other_extensions_button_color']};
                       border: 1px solid {$data['show_other_extensions_button_color']};
                   }

    @media screen and (max-width: 768px) {
        .{$name}-{$id} .puq-domain-search-input-group{
        display: block;
    }
    }


    .{$name}-{$id} .puq-domain-search-result {
                       width: 100%;
                       background-color: #fff;
                       box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
                   }

    .{$name}-{$id} .domain-info {
                       display: flex;
                       flex-direction: row;
                       flex-wrap: wrap;
                       justify-content: space-between;

                       font-size: 10px;
                       border: 1px solid {$data['color_1']};
                       padding-left: 20px;
                       padding-right: 20px;
                       padding-top: 8px;
                       padding-bottom: 8px;
                       margin-bottom: 5px;
                       border-radius: 5px;
                       background-color: {$data['color_3']}10;
                       transform: translateY(-100%);
                       animation: slideFromTop 0.2s ease forwards;
                   }

    @keyframes slideFromTop {
        from {
            transform: translateY(-100%);
        }
        to {
            transform: translateY(0);
        }
    }

    .{$name}-{$id} .domain-block {
                       align-items: center;
                       text-align: left;
                       justify-content: space-between;
                       font-size: 10px;
                   }

    .{$name}-{$id} .domain-name {
                       font-weight: 600;
                       font-size: 20px;
                       color: {$data['search_results_text_color']};
                       white-space: nowrap;
                   }

    .{$name}-{$id} .icon-available {
                       font-size: 13px;
                       color: {$data['available_text_color']};
                       white-space: nowrap;
                   }

    .{$name}-{$id} .icon-unavailable {
                       font-size: 13px;
                       color: {$data['already_reserved_text_color']};
                       white-space: nowrap;
                   }

    .{$name}-{$id} .price-block {
                       display: flex;
                       align-items: center;
                       justify-content: space-between;
                       font-size: 16px;
                   }

    .{$name}-{$id} .price {
                       padding-left: 20px;
                       padding-right: 20px;
                       text-align: right;
                   }

    .{$name}-{$id} .price-registration {
                       font-weight: 800;
                       justify-content: space-between;
                       font-size: 22px;
                       color: {$data['search_results_text_color']};
                       white-space: nowrap;
                   }

    .{$name}-{$id} .price-next {
                       color: {$data['renew_text_color']};
                       white-space: nowrap;
                   }

    .{$name}-{$id} .search_results {
                       padding-top: 25px;
                       display: none;
                   }

    .{$name}-{$id} .other_extensions {
                       padding-top: 25px;
                       display: none;
                   }


    .{$name}-{$id} .puq-domain-search-input-transfer {
                       display: none;
                       width: 0;
                       animation: expandWidth 0.3s ease forwards;
                       background-color: transparent;
                       color: {$data['color_1']};
                       font-size: 16px;
                       padding: 5px;
                       flex-grow: 1;
                       border-radius: 5px;
                   }

    @keyframes expandWidth {
        from {
            width: 0;
        }
        to {
            width: 100%;
        }
    }

</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="puq-domain-search-container">
        <div class="puq-domain-search-clearfix">
            {if !$data['disable_header']}
                <h2 class="puq-domain-search-header">{$data['header']}</h2>
            {/if}
            <div class="puq-domain-search-input-group-wrapper">
                <div class="puq-domain-search-input-group">
                    <span class="puq-domain-search-span-input-group">
                        <i class="fad fa-search"></i>
                        <input id="domain{$id}" type="text" name="domain" placeholder="{if !$data['disable_placeholder']}{$data['placeholder']}{/if}" autocapitalize="none" class="puq-domain-search-input">
                    </span>
                    <span class="puq-domain-search-span-btn-group">
                        <button id="search_button_name{$id}" class="puq-domain-search-btn-search">{$data['search_button_name']}</button>
                    </span>
                </div>
            </div>
        </div>
        {if !$data['disable_view_all_pricing_button']}
            <a href="{$before_path}/domain/pricing" class="puq-domain-search-btn-view-all-pricing">{$data['view_all_pricing_button_name']}</a>
        {/if}



        <div id="puqdomainsearchresultblock{$id}" class="search_results">
            {if !$data['disable_search_results']}
                <h3 style="text-align: left; color: {$data['search_results_text_color']};">{$data['search_results']}</h3>
            {/if}
            <div id="puqdomainsearchresult{$id}"></div>
        </div>


        <div id="puqdomainotherextensionsblock{$id}" class="other_extensions">
            {if !$data['disable_other_extensions']}
                <h3 style="text-align: left; color: {$data['other_extensions_text_color']};">{$data['other_extensions']}</h3>
            {/if}
            <div id="puqdomainotherextensions{$id}"></div>

            <div id="puqdomainotherextensionsbtn{$id}"></div>
        </div>

    </div>
</div>


<script>
    var tld = JSON.parse('{$tld}');

    function handleDomainInfo(data, id, add, loaderClass) {

        const domainInfo = document.getElementById(loaderClass);
        domainInfo.innerHTML = '';

        domainInfo.className = 'domain-info';
        domainInfo.style = "";
        const domainBlock = document.createElement('div');
        domainBlock.className = 'domain-block';

        const domainName = document.createElement('span');
        domainName.className = 'domain-name';
        domainName.textContent = data.result[0].domainName;

        const statusInfo = document.createElement('span');

        if (data.result[0].isAvailable) {
            statusInfo.className = 'icon-available';
            statusInfo.innerHTML = `<i class="fa fa-check" aria-hidden="true"></i> &ensp;{$data['available']}`;
        } else {
            statusInfo.className = 'icon-unavailable';
            statusInfo.innerHTML = `<i class="fa fa-exclamation-triangle" aria-hidden="true"></i> &ensp;{$data['already_reserved']}`;
        }

        const messageBlock = document.createElement('div');
        messageBlock.className = 'message-block';

        const priceBlock = document.createElement('div');
        priceBlock.className = 'price-block';

        const price = document.createElement('div');
        price.className = 'price';

        const priceRegistration = document.createElement('div');
        priceRegistration.className = 'price-registration';
        priceRegistration.textContent = data.result[0].pricing[1].register;

        const priceNext = document.createElement('div');
        priceNext.className = 'price-next';
        priceNext.textContent = '{$data['renew']}' + data.result[0].pricing[1].renew;

        const priceButton = document.createElement('div');
        priceButton.className = 'price-button';
        const buyButton = document.createElement('button');
        const transferButton = document.createElement('button');
        const transferInput = document.createElement('input');

        if (data.result[0].isAvailable) {
            buyButton.className = 'puq-domain-search-btn-buy';
            buyButton.textContent = '{$data['buy_button_name']}';
            buyButton.setAttribute('data-domain', data.result[0].domainName);
            buyButton.id = 'add-to-cart';

            buyButton.addEventListener('click', function() {
                var originalText = buyButton.textContent;
                buyButton.innerHTML = '<i class="fas fa-redo-alt fa-spin"></i>';
                var domainValue = buyButton.getAttribute('data-domain');
                var url = '{$before_path}/cart.php';
                var params = 'a=addToCart&domain=' + encodeURIComponent(domainValue) + '&token=' + csrfToken + '&whois=1&sideorder=1&idnlanguage=';

                var xhr = new XMLHttpRequest();
                xhr.open('POST', url, true);
                xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function() {
                    if(xhr.readyState == 4) {
                        if(xhr.status == 200) {
                            var response = JSON.parse(xhr.responseText);
                            if(response.result === 'added') {
                                window.location.href = '{$before_path}/cart.php?a=confdomains';
                            }
                        } else {
                            buyButton.textContent = originalText;
                        }
                    }
                };
                xhr.send(params);
            });

        } else {

            transferInput.className = 'puq-domain-search-input-transfer';
            transferInput.setAttribute('type', 'text');
            transferInput.setAttribute('name', 'inputAuthCode');
            transferInput.setAttribute('id', 'inputAuthCode');
            transferInput.setAttribute('placeholder', 'Epp Code / Auth Code');
            transferInput.setAttribute('input-data-domain', data.result[0].domainName);

            transferButton.className = 'puq-domain-search-btn-transfer';
            transferButton.textContent = '{$data['transfer_button_name']}';
            transferButton.setAttribute('data-domain', data.result[0].domainName);

            transferButton.addEventListener('click', function() {
                var originalText = transferButton.textContent;
                var domainValue = transferButton.getAttribute('data-domain');
                var elements = document.querySelectorAll('[input-data-domain="' + domainValue + '"]');
                var transferInput = elements[0];
                if (window.getComputedStyle(transferInput).display === 'none') {
                    transferInput.style.display = 'inline-block';
                    return;
                }

                transferButton.innerHTML = '<i class="fas fa-redo-alt fa-spin"></i>';
                var url = '{$before_path}/cart.php';
                var inputAuthCodeValue = transferInput.value;

                var params = 'a=addDomainTransfer&domain=' + encodeURIComponent(domainValue) + '&token=' + csrfToken + '&epp='+ encodeURIComponent(inputAuthCodeValue);
                var xhr = new XMLHttpRequest();
                xhr.open('POST', url, true);
                xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
                xhr.onreadystatechange = function() {
                    if(xhr.readyState === 4) {
                        if(xhr.status === 200) {
                            var response = JSON.parse(xhr.responseText);
                            if(response.result === 'added') {
                                window.location.href = '{$before_path}/cart.php?a=confdomains';
                            } else if (response.result && response.result.unavailable) {
                                alert('Error: ' + response.result.unavailable);
                            }
                        }
                        transferButton.textContent = originalText;
                    }
                };
                xhr.send(params);
            });

        }

        domainBlock.appendChild(domainName);
        domainBlock.appendChild(document.createElement('br'));
        domainBlock.appendChild(statusInfo);

        price.appendChild(priceRegistration);
        price.appendChild(priceNext);

        priceBlock.appendChild(price);
        priceBlock.appendChild(priceButton);


        domainInfo.appendChild(domainBlock);

        if (data.result[0].isAvailable) {
            priceButton.appendChild(buyButton);
        }else{
            priceButton.appendChild(transferButton);
            priceButton.appendChild(transferInput);
        }

        domainInfo.appendChild(priceBlock);
    }

    function disableButton(button) {
        button.disabled = true;
        button.style.opacity = '0.5';
        button.style.cursor = 'not-allowed';
    }

    function enableButton(button) {
        button.disabled = false;
        button.style.opacity = '';
        button.style.cursor = '';
    }

    function updateButtonState(input, button) {
        disableButton(button);
        button.disabled = !input.value.trim();
        if (!input.value.trim()) {
            disableButton(button);
        } else {
            enableButton(button);
        }
    }

    function showLoader(id) {

        const loader = document.getElementById(id);

        loader.innerHTML = '<i class="fas fa-redo-alt fa-spin"></i>';
        loader.style.height = '70px';
        loader.style.paddingTop = '8px';
        loader.style.marginBottom = '9px';
        loader.style.borderRadius = '5px';
        loader.style.backgroundColor = '{$data['color_3']}10';
        const icon = loader.querySelector('i');
        icon.style.fontSize = '55px';
    }

    function hideLoader(id) {
        const resultDiv = document.getElementById(id);
        const loader = resultDiv.querySelector('.loader');
        if (loader) {
            loader.remove();
        }
    }

    function sendRequest(domain) {

        return new Promise((resolve, reject) => {
            var params = "token=" + csrfToken + "&a=checkDomain&domain=" + domain + "&type=domain";

            const xhr = new XMLHttpRequest();
            xhr.open("POST", "{$before_path}/index.php?rp=/domain/check", true);
            xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        const responseData = JSON.parse(xhr.responseText);
                        resolve(responseData);
                    } else {
                        reject(xhr.status);
                    }
                }
            }

            xhr.send(params);
        });
    }

    function searchHandler(id) {
        const domainInput = document.getElementById("domain" + id);
        const sendRequestBtn = document.getElementById("search_button_name" + id);
        updateButtonState(domainInput, sendRequestBtn);

        domainInput.addEventListener('input', function() {
            updateButtonState(domainInput, sendRequestBtn);
        });

        domainInput.addEventListener('keyup', function() {
            if (event.key === 'Enter') {
                sendRequestBtn.click();
            } else {
                updateButtonState(domainInput, sendRequestBtn);
            }
        });

        sendRequestBtn.addEventListener('click', function() {
            const domain = domainInput.value.trim();
            domainInput.value = '';
            const resultDiv = document.getElementById('puqdomainsearchresultblock{$id}');
            resultDiv.style.display = 'block';
            disableButton(sendRequestBtn);

            const resultDivInsideLoop = document.getElementById('puqdomainsearchresult{$id}');
            const loaderDiv = document.createElement('div');
            loaderDiv.className = 'domain-info-00';
            loaderDiv.id = 'domain-info-00';
            resultDivInsideLoop.innerHTML = '';
            resultDivInsideLoop.appendChild(loaderDiv);
            showLoader('domain-info-00');

            const otherExtensionsDiv = document.getElementById('puqdomainotherextensions{$id}');
            otherExtensionsDiv.innerHTML = '';
            sendRequest(domain)
                .then(responseData => {
                    handleDomainInfo(responseData, 'puqdomainsearchresult{$id}', false, 'domain-info-00');
                    if({$data['number_other_results']} > 0){
                        otherExtensions(responseData.result[0].domainName,0,{$data['number_other_results']});
                    }
                })
                .catch(error => {
                    console.error('Error executing request:', error);
                });
        });
    }

    function otherExtensions(domain, start, count) {
        const resultDiv = document.getElementById('puqdomainotherextensionsblock{$id}');
        resultDiv.style.display = 'block';
        var lastIndex = domain.lastIndexOf('.');
        var domainON = domain;
        if (lastIndex !== -1) {
            domainON = domain.substring(0, lastIndex);
        }

        end = Math.min(start + count, tld.length);

        for (var i = start; i < end; i++) {
            if (domain.endsWith(tld[i])) {
                continue;
            }

            (function(index) {
                const resultDivInsideLoop = document.getElementById('puqdomainotherextensions{$id}');
                const loaderDiv = document.createElement('div');
                loaderDiv.className = 'domain-info-' + index;
                loaderDiv.id = 'domain-info-' + index;
                resultDivInsideLoop.appendChild(loaderDiv);
                showLoader('domain-info-' + index);

                sendRequest(domainON + tld[index])
                    .then(responseData => {
                        handleDomainInfo(responseData, 'puqdomainotherextensions{$id}', true, 'domain-info-' + index);
                    })
                    .catch(error => {
                        console.error('Error executing request:', error);
                    });
            })(i);
        }
        addButton(domain, start + count, count)
    }

    function addButton(domain,start,count) {
        const btnDiv = document.getElementById('puqdomainotherextensionsbtn{$id}');
        const button = document.createElement('button');
        button.innerHTML = '<i class="fa fa-chevron-down" aria-hidden="true"> </i>&nbsp; {$data['show_other_extensions_button_name']}&nbsp; <i class="fa fa-chevron-down" aria-hidden="true"> </i>';
        button.className = 'puq-domain-search-btn-other-extensions';
        button.addEventListener('click', function() {
            otherExtensions(domain, start, count);
            if (parseInt(button.dataset.end) >= tld.length) {
                button.style.display = 'none';
            }
        });

        btnDiv.innerHTML = '';

        if(start < tld.length) {
            btnDiv.appendChild(button);
        }
    }

    searchHandler('{$id}');
</script>