class PUQIntelligentDomainSearch {
    static get toolbox() {
        return {
            title: 'Intelligent Domain Search',
            icon: '<i class="fa fa-cubes" aria-hidden="true"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQIntelligentDomainSearch');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td  class="fieldlabel"><h1 style="color: blue;">Intelligent Domain Search</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Color</b></td>
        <td colspan="3" class="fieldarea">

            <label for="color_1">Color 1:</label>
            <input type="color" name="color_1" class="form-control input-inline input-50">

            <label for="color_2">Color 2:</label>
            <input type="color" name="color_2" class="form-control input-inline input-50">

            <label for="color_3">Color 3:</label>
            <input type="color" name="color_3" class="form-control input-inline input-50">

            <label for="color_4">Color 4:</label>
            <input type="color" name="color_4" class="form-control input-inline input-50">

            <label for="color_5">Color 5:</label>
            <input type="color" name="color_5" class="form-control input-inline input-50">

            <label for="color_6">Color 6:</label>
            <input type="color" name="color_6" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">

        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Header</b><br>e.g. (Secure your domain name)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="header" value="" class="form-control input-inline input-200">
            <label for="header_text_color">Text color:</label>
            <input type="color" name="header_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_header"><b>Disable header</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Search button name</b><br>e.g. (Search)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="search_button_name" value="" class="form-control input-inline input-200">
            <label for="search_button_color">Button color:</label>
            <input type="color" name="search_button_color" class="form-control input-inline input-50">
            <label for="search_button_text_color">Text color:</label>
            <input type="color" name="search_button_text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Placeholder</b><br>e.g. (eg. example.com)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="placeholder" value="" class="form-control input-inline input-200">
            <label for="placeholder_color">Text color:</label>
            <input type="color" name="placeholder_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_placeholder"><b>Disable placeholder</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>View all pricing button name</b><br>e.g. (View all pricing)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="view_all_pricing_button_name" value="" class="form-control input-inline input-200">
            <label for="view_all_pricing_button_color">Button color:</label>
            <input type="color" name="view_all_pricing_button_color" class="form-control input-inline input-50">
            <label for="view_all_pricing_button_text_color">Text color:</label>
            <input type="color" name="view_all_pricing_button_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_view_all_pricing_button"><b>Disable view all pricing button</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Transfer button name</b><br>e.g. (Transfer)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="transfer_button_name" value="" class="form-control input-inline input-200">
            <label for="transfer_button_color">Button color:</label>
            <input type="color" name="transfer_button_color" class="form-control input-inline input-50">
            <label for="transfer_button_text_color">Text color:</label>
            <input type="color" name="transfer_button_text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Buy button name</b><br>e.g. (Buy)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="buy_button_name" value="" class="form-control input-inline input-200">
            <label for="buy_button_color">Button color:</label>
            <input type="color" name="buy_button_color" class="form-control input-inline input-50">
            <label for="buy_button_text_color">Text color:</label>
            <input type="color" name="buy_button_text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Search results label</b><br>e.g. (Search results)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="search_results" value="" class="form-control input-inline input-200">
            <label for="search_results_text_color">Text color:</label>
            <input type="color" name="search_results_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_search_results"><b>Disable</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Other extensions label</b><br>e.g. (Other extensions)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="other_extensions" value="" class="form-control input-inline input-200">
            <label for="other_extensions_text_color">Text color:</label>
            <input type="color" name="other_extensions_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_other_extensions"><b>Disable</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Available label</b><br>e.g. (Available)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="available" value="" class="form-control input-inline input-200">
            <label for="available_text_color">Text color:</label>
            <input type="color" name="available_text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Already reserved label</b><br>e.g. (Already reserved)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="already_reserved" value="" class="form-control input-inline input-200">
            <label for="already_reserved_text_color">Text color:</label>
            <input type="color" name="already_reserved_text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Renew label</b><br>e.g. (Renew)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="renew" value="" class="form-control input-inline input-200">
            <label for="renew_text_color">Text color:</label>
            <input type="color" name="renew_text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Show other extensions button name</b><br>e.g. (Show other extensions)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="show_other_extensions_button_name" value="" class="form-control input-inline input-200">
            <label for="show_other_extensions_button_color">Button color:</label>
            <input type="color" name="show_other_extensions_button_color" class="form-control input-inline input-50">
            <label for="show_other_extensions_button_text_color">Text color:</label>
            <input type="color" name="show_other_extensions_button_text_color" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Number other results</b><br>e.g. (10)</td>
        <td colspan="3" class="fieldarea">
            <input type="number" name="number_other_results" value="" class="form-control input-inline input-200">
        </td>
    </tr>


    </tbody>
</table>
`);

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const color_1 = this.data && this.data.color_1 ? this.data.color_1 : "";
        $(render).find("[name='color_1']").val(color_1);
        if (color_1 === '') {
            $(render).find("[name='color_1']").val('#4f1998');
        }

        const color_2 = this.data && this.data.color_2 ? this.data.color_2 : "";
        $(render).find("[name='color_2']").val(color_2);
        if (color_2 === '') {
            $(render).find("[name='color_2']").val('#0de1b9');
        }

        const color_3 = this.data && this.data.color_3 ? this.data.color_3 : "";
        $(render).find("[name='color_3']").val(color_3);
        if (color_3 === '') {
            $(render).find("[name='color_3']").val('#000000');
        }

        const color_4 = this.data && this.data.color_4 ? this.data.color_4 : "";
        $(render).find("[name='color_4']").val(color_4);
        if (color_4 === '') {
            $(render).find("[name='color_4']").val('#000000');
        }

        const color_5 = this.data && this.data.color_5 ? this.data.color_5 : "";
        $(render).find("[name='color_5']").val(color_5);
        if (color_5 === '') {
            $(render).find("[name='color_5']").val('#000000');
        }

        const color_6 = this.data && this.data.color_6 ? this.data.color_6 : "";
        $(render).find("[name='color_6']").val(color_6);
        if (color_6 === '') {
            $(render).find("[name='color_6']").val('#000000');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#ffffff');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }

        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }

        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const header = this.data && this.data.header ? this.data.header : "";
        $(render).find("[name='header']").val(header);
        if (header === '') {
            $(render).find("[name='header']").val('Secure your domain name');
        }

        const header_text_color = this.data && this.data.header_text_color ? this.data.header_text_color : "";
        $(render).find("[name='header_text_color']").val(header_text_color);
        if (header_text_color === '') {
            $(render).find("[name='header_text_color']").val('#000000');
        }

        if (this.data.disable_header === true) {
            $(render).find("[name='disable_header']").attr('checked', 'checked');
        }

        const search_button_name = this.data && this.data.search_button_name ? this.data.search_button_name : "";
        $(render).find("[name='search_button_name']").val(search_button_name);
        if (search_button_name === '') {
            $(render).find("[name='search_button_name']").val('Search');
        }

        const search_button_color = this.data && this.data.search_button_color ? this.data.search_button_color : "";
        $(render).find("[name='search_button_color']").val(search_button_color);
        if (search_button_color === '') {
            $(render).find("[name='search_button_color']").val('#6420c0');
        }

        const search_button_text_color = this.data && this.data.search_button_text_color ? this.data.search_button_text_color : "";
        $(render).find("[name='search_button_text_color']").val(search_button_text_color);
        if (search_button_text_color === '') {
            $(render).find("[name='search_button_text_color']").val('#0de1b9');
        }

        const placeholder = this.data && this.data.placeholder ? this.data.placeholder : "";
        $(render).find("[name='placeholder']").val(placeholder);
        if (placeholder === '') {
            $(render).find("[name='placeholder']").val('eg. example.com');
        }

        const placeholder_text_color = this.data && this.data.placeholder_text_color ? this.data.placeholder_text_color : "";
        $(render).find("[name='placeholder_text_color']").val(placeholder_text_color);
        if (placeholder_text_color === '') {
            $(render).find("[name='placeholder_text_color']").val('#a484d5');
        }

        if (this.data.disable_placeholder === true) {
            $(render).find("[name='disable_placeholder']").attr('checked', 'checked');
        }

        const transfer_button_name = this.data && this.data.transfer_button_name ? this.data.transfer_button_name : "";
        $(render).find("[name='transfer_button_name']").val(transfer_button_name);
        if (transfer_button_name === '') {
            $(render).find("[name='transfer_button_name']").val('Transfer');
        }

        const transfer_button_color = this.data && this.data.transfer_button_color ? this.data.transfer_button_color : "";
        $(render).find("[name='transfer_button_color']").val(transfer_button_color);
        if (transfer_button_color === '') {
            $(render).find("[name='transfer_button_color']").val('#6420c0');
        }

        const transfer_button_text_color = this.data && this.data.transfer_button_text_color ? this.data.transfer_button_text_color : "";
        $(render).find("[name='transfer_button_text_color']").val(transfer_button_text_color);
        if (transfer_button_text_color === '') {
            $(render).find("[name='transfer_button_text_color']").val('#0de1b9');
        }

        const buy_button_name = this.data && this.data.buy_button_name ? this.data.buy_button_name : "";
        $(render).find("[name='buy_button_name']").val(buy_button_name);
        if (buy_button_name === '') {
            $(render).find("[name='buy_button_name']").val('Buy now');
        }

        const buy_button_color = this.data && this.data.buy_button_color ? this.data.buy_button_color : "";
        $(render).find("[name='buy_button_color']").val(buy_button_color);
        if (buy_button_color === '') {
            $(render).find("[name='buy_button_color']").val('#6420c0');
        }

        const buy_button_text_color = this.data && this.data.buy_button_text_color ? this.data.buy_button_text_color : "";
        $(render).find("[name='buy_button_text_color']").val(buy_button_text_color);
        if (buy_button_text_color === '') {
            $(render).find("[name='buy_button_text_color']").val('#0de1b9');
        }

        const view_all_pricing_button_name = this.data && this.data.view_all_pricing_button_name ? this.data.view_all_pricing_button_name : "";
        $(render).find("[name='view_all_pricing_button_name']").val(view_all_pricing_button_name);
        if (view_all_pricing_button_name === '') {
            $(render).find("[name='view_all_pricing_button_name']").val('View all pricing');
        }

        const view_all_pricing_button_color = this.data && this.data.view_all_pricing_button_color ? this.data.view_all_pricing_button_color : "";
        $(render).find("[name='view_all_pricing_button_color']").val(view_all_pricing_button_color);
        if (view_all_pricing_button_color === '') {
            $(render).find("[name='view_all_pricing_button_color']").val('#0de1b9');
        }

        const view_all_pricing_button_text_color = this.data && this.data.view_all_pricing_button_text_color ? this.data.view_all_pricing_button_text_color : "";
        $(render).find("[name='view_all_pricing_button_text_color']").val(view_all_pricing_button_text_color);
        if (view_all_pricing_button_text_color === '') {
            $(render).find("[name='view_all_pricing_button_text_color']").val('#6420c0');
        }

        if (this.data.disable_view_all_pricing_button === true) {
            $(render).find("[name='disable_view_all_pricing_button']").attr('checked', 'checked');
        }

        const search_results = this.data && this.data.search_results ? this.data.search_results : "";
        $(render).find("[name='search_results']").val(search_results);
        if (search_results === '') {
            $(render).find("[name='search_results']").val('Search results');
        }

        const search_results_text_color = this.data && this.data.search_results_text_color ? this.data.search_results_text_color : "";
        $(render).find("[name='search_results_text_color']").val(search_results_text_color);
        if (search_results_text_color === '') {
            $(render).find("[name='search_results_text_color']").val('#000000');
        }

        if (this.data.disable_search_results === true) {
            $(render).find("[name='disable_search_results']").attr('checked', 'checked');
        }

        const other_extensions = this.data && this.data.other_extensions ? this.data.other_extensions : "";
        $(render).find("[name='other_extensions']").val(other_extensions);
        if (other_extensions === '') {
            $(render).find("[name='other_extensions']").val('Other extensions');
        }

        const other_extensions_text_color = this.data && this.data.other_extensions_text_color ? this.data.other_extensions_text_color : "";
        $(render).find("[name='other_extensions_text_color']").val(other_extensions_text_color);
        if (other_extensions_text_color === '') {
            $(render).find("[name='other_extensions_text_color']").val('#000000');
        }

        if (this.data.disable_other_extensions === true) {
            $(render).find("[name='disable_other_extensions']").attr('checked', 'checked');
        }

        const available = this.data && this.data.available ? this.data.available : "";
        $(render).find("[name='available']").val(available);
        if (available === '') {
            $(render).find("[name='available']").val('Available');
        }

        const available_text_color = this.data && this.data.available_text_color ? this.data.available_text_color : "";
        $(render).find("[name='available_text_color']").val(available_text_color);
        if (available_text_color === '') {
            $(render).find("[name='available_text_color']").val('#268303');
        }

        const already_reserved = this.data && this.data.already_reserved ? this.data.already_reserved : "";
        $(render).find("[name='already_reserved']").val(already_reserved);
        if (already_reserved === '') {
            $(render).find("[name='already_reserved']").val('Already reserved');
        }

        const already_reserved_text_color = this.data && this.data.already_reserved_text_color ? this.data.already_reserved_text_color : "";
        $(render).find("[name='already_reserved_text_color']").val(already_reserved_text_color);
        if (already_reserved_text_color === '') {
            $(render).find("[name='already_reserved_text_color']").val('#f89a3e');
        }

        const renew = this.data && this.data.renew ? this.data.renew : "";
        $(render).find("[name='renew']").val(renew);
        if (renew === '') {
            $(render).find("[name='renew']").val('Renew');
        }

        const renew_text_color = this.data && this.data.renew_text_color ? this.data.renew_text_color : "";
        $(render).find("[name='renew_text_color']").val(renew_text_color);
        if (renew_text_color === '') {
            $(render).find("[name='renew_text_color']").val('#999');
        }

        const show_other_extensions_button_name = this.data && this.data.show_other_extensions_button_name ? this.data.show_other_extensions_button_name : "";
        $(render).find("[name='show_other_extensions_button_name']").val(show_other_extensions_button_name);
        if (show_other_extensions_button_name === '') {
            $(render).find("[name='show_other_extensions_button_name']").val('Show other extensions');
        }

        const show_other_extensions_button_color = this.data && this.data.show_other_extensions_button_color ? this.data.show_other_extensions_button_color : "";
        $(render).find("[name='show_other_extensions_button_color']").val(show_other_extensions_button_color);
        if (show_other_extensions_button_color === '') {
            $(render).find("[name='show_other_extensions_button_color']").val('#0de1b9');
        }

        const show_other_extensions_button_text_color = this.data && this.data.show_other_extensions_button_text_color ? this.data.show_other_extensions_button_text_color : "";
        $(render).find("[name='show_other_extensions_button_text_color']").val(show_other_extensions_button_text_color);
        if (show_other_extensions_button_text_color === '') {
            $(render).find("[name='show_other_extensions_button_text_color']").val('#6420c0');
        }

        const number_other_results = this.data && this.data.number_other_results ? this.data.number_other_results : "";
        $(render).find("[name='number_other_results']").val(number_other_results);
        if (number_other_results === '') {
            $(render).find("[name='number_other_results']").val('10');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {

        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }

        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }

        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }

        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }

        var disable_header = false;
        if ($(content).find("[name='disable_header']").is(':checked')) {
            disable_header = true;
        }

        var disable_placeholder = false;
        if ($(content).find("[name='disable_placeholder']").is(':checked')) {
            disable_placeholder = true;
        }

        var disable_view_all_pricing_button = false;
        if ($(content).find("[name='disable_view_all_pricing_button']").is(':checked')) {
            disable_view_all_pricing_button = true;
        }

        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }

        var disable_search_results = false;
        if ($(content).find("[name='disable_search_results']").is(':checked')) {
            disable_search_results = true;
        }

        var disable_other_extensions = false;
        if ($(content).find("[name='disable_other_extensions']").is(':checked')) {
            disable_other_extensions = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        return {
            "width": $(content).find("[name='width']").val().replace(/	/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/	/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/	/g, ""),
            "style": style.replace(/	/g, ""),

            "color_1": $(content).find("[name='color_1']").val().replace(/	/g, ""),
            "color_2": $(content).find("[name='color_2']").val().replace(/	/g, ""),
            "color_3": $(content).find("[name='color_3']").val().replace(/	/g, ""),
            "color_4": $(content).find("[name='color_4']").val().replace(/	/g, ""),
            "color_5": $(content).find("[name='color_5']").val().replace(/	/g, ""),
            "color_6": $(content).find("[name='color_6']").val().replace(/	/g, ""),

            "background_image": $(content).find("[name='background_image']").val().replace(/	/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/	/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width":full_width,

            "header": $(content).find("[name='header']").val().replace(/	/g, ""),
            "header_text_color": $(content).find("[name='header_text_color']").val().replace(/	/g, ""),
            "disable_header": disable_header,

            "search_button_name": $(content).find("[name='search_button_name']").val().replace(/	/g, ""),
            "search_button_color": $(content).find("[name='search_button_color']").val().replace(/	/g, ""),
            "search_button_text_color": $(content).find("[name='search_button_text_color']").val().replace(/	/g, ""),

            "placeholder": $(content).find("[name='placeholder']").val().replace(/	/g, ""),
            "placeholder_text_color": $(content).find("[name='placeholder_text_color']").val().replace(/	/g, ""),
            "disable_placeholder": disable_placeholder,

            "transfer_button_name": $(content).find("[name='transfer_button_name']").val().replace(/	/g, ""),
            "transfer_button_color": $(content).find("[name='transfer_button_color']").val().replace(/	/g, ""),
            "transfer_button_text_color": $(content).find("[name='transfer_button_text_color']").val().replace(/	/g, ""),

            "buy_button_name": $(content).find("[name='buy_button_name']").val().replace(/	/g, ""),
            "buy_button_color": $(content).find("[name='buy_button_color']").val().replace(/	/g, ""),
            "buy_button_text_color": $(content).find("[name='buy_button_text_color']").val().replace(/	/g, ""),

            "view_all_pricing_button_name": $(content).find("[name='view_all_pricing_button_name']").val().replace(/	/g, ""),
            "view_all_pricing_button_color": $(content).find("[name='view_all_pricing_button_color']").val().replace(/	/g, ""),
            "view_all_pricing_button_text_color": $(content).find("[name='view_all_pricing_button_text_color']").val().replace(/	/g, ""),
            "disable_view_all_pricing_button" : disable_view_all_pricing_button,

            "search_results": $(content).find("[name='search_results']").val().replace(/	/g, ""),
            "search_results_text_color": $(content).find("[name='search_results_text_color']").val().replace(/	/g, ""),
            "disable_search_results": disable_search_results,

            "other_extensions": $(content).find("[name='other_extensions']").val().replace(/	/g, ""),
            "other_extensions_text_color": $(content).find("[name='other_extensions_text_color']").val().replace(/	/g, ""),
            "disable_other_extensions": disable_other_extensions,

            "available": $(content).find("[name='available']").val().replace(/	/g, ""),
            "available_text_color": $(content).find("[name='available_text_color']").val().replace(/	/g, ""),

            "already_reserved": $(content).find("[name='already_reserved']").val().replace(/	/g, ""),
            "already_reserved_text_color": $(content).find("[name='already_reserved_text_color']").val().replace(/	/g, ""),

            "renew": $(content).find("[name='renew']").val().replace(/	/g, ""),
            "renew_text_color": $(content).find("[name='renew_text_color']").val().replace(/	/g, ""),

            "show_other_extensions_button_name": $(content).find("[name='show_other_extensions_button_name']").val().replace(/	/g, ""),
            "show_other_extensions_button_color": $(content).find("[name='show_other_extensions_button_color']").val().replace(/	/g, ""),
            "show_other_extensions_button_text_color": $(content).find("[name='show_other_extensions_button_text_color']").val().replace(/	/g, ""),

            "number_other_results": $(content).find("[name='number_other_results']").val().replace(/	/g, ""),

        };
    }
}
