<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        max-width: 1200px;
        margin: 0 auto 32px auto;
        text-align: {if $data['heading_align'] neq ''}{$data['heading_align']}{else}center{/if};
    }

    .{$name}-{$id} .{$name}-{$id}-heading {
        font-size: 2rem;
        font-weight: 700;
        color: {if $data['title_color'] neq ''}{$data['title_color']}{else}#2c3e50{/if};
        margin: 0 0 10px 0;
        line-height: 1.3;
    }

    .{$name}-{$id} .{$name}-{$id}-subtitle {
        font-size: 1.05rem;
        color: #777;
        margin: 0;
        line-height: 1.6;
        max-width: 620px;
        {if $data['heading_align'] eq 'center' || $data['heading_align'] eq ''}
            margin-left: auto;
            margin-right: auto;
        {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: {if $data['gap'] neq ''}{$data['gap']}px{else}24px{/if};
        max-width: 1200px;
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-item {
        text-align: {if $data['card_align'] neq ''}{$data['card_align']}{else}center{/if};
        padding: 36px 28px;
        background: #fff;
        border-radius: 14px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        position: relative;
        overflow: hidden;
    {if $data['show_shadow'] || !isset($data['show_shadow'])}
        box-shadow: 0 2px 16px rgba(0, 0, 0, 0.06);
    {/if}
    {if $data['show_border']}
        border: 1px solid #e8ecf1;
    {/if}
    }

    {if $data['show_accent']}
    .{$name}-{$id} .{$name}-{$id}-item::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, {if $data['icon_color'] neq ''}{$data['icon_color']}{else}#337ab7{/if}, {if $data['icon_color'] neq ''}{$data['icon_color']}99{else}#337ab799{/if});
        border-radius: 14px 14px 0 0;
    }
    {/if}

    .{$name}-{$id} .{$name}-{$id}-item:hover {
        transform: translateY(-6px);
    {if $data['show_shadow'] || !isset($data['show_shadow'])}
        box-shadow: 0 12px 36px rgba(0, 0, 0, 0.12);
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-icon {
    {if $data['icon_size'] eq 'sm'}
        width: 48px;
        height: 48px;
        font-size: 1.2rem;
    {elseif $data['icon_size'] eq 'lg'}
        width: 80px;
        height: 80px;
        font-size: 2.2rem;
    {else}
        width: 64px;
        height: 64px;
        font-size: 1.6rem;
    {/if}
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 20px;
        color: {if $data['icon_color'] neq ''}{$data['icon_color']}{else}#337ab7{/if};
        transition: transform 0.3s ease;
    {if $data['card_align'] eq 'center' || $data['card_align'] eq ''}
        margin-left: auto;
        margin-right: auto;
    {/if}
    {if $data['icon_shape'] eq 'circle'}
        border-radius: 50%;
        background: {if $data['icon_color'] neq ''}{$data['icon_color']}{else}#337ab7{/if}12;
    {elseif $data['icon_shape'] eq 'none'}
        background: none;
    {else}
        border-radius: 16px;
        background: {if $data['icon_color'] neq ''}{$data['icon_color']}{else}#337ab7{/if}12;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-item:hover .{$name}-{$id}-icon {
        transform: scale(1.1);
    }

    .{$name}-{$id} .{$name}-{$id}-title {
        font-size: 1.15rem;
        font-weight: 600;
        color: {if $data['title_color'] neq ''}{$data['title_color']}{else}#2c3e50{/if};
        margin-bottom: 10px;
        line-height: 1.4;
    }

    .{$name}-{$id} .{$name}-{$id}-desc {
        font-size: 0.9rem;
        color: #666;
        line-height: 1.7;
        margin-bottom: 14px;
    }

    .{$name}-{$id} .{$name}-{$id}-link {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        color: {if $data['icon_color'] neq ''}{$data['icon_color']}{else}#337ab7{/if};
        text-decoration: none;
        font-weight: 600;
        font-size: 0.85rem;
        transition: gap 0.25s ease, color 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-link:hover {
        gap: 10px;
    }

    @media (max-width: 992px) {
        .{$name}-{$id} .{$name}-{$id}-container {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 600px) {
        .{$name}-{$id} .{$name}-{$id}-container {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-item {
            padding: 28px 22px;
        }
        .{$name}-{$id} .{$name}-{$id}-heading {
            font-size: 1.5rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    {if $data['heading'] neq '' || $data['subtitle'] neq ''}
        <div class="{$name}-{$id}-header">
            {if $data['heading'] neq ''}
                <h2 class="{$name}-{$id}-heading">{$data['heading']}</h2>
            {/if}
            {if $data['subtitle'] neq ''}
                <p class="{$name}-{$id}-subtitle">{$data['subtitle']}</p>
            {/if}
        </div>
    {/if}

    <div class="{$name}-{$id}-container">
        {if isset($data['items']) && $data['items']}
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-item">
                    {if $item['icon'] neq ''}
                        <div class="{$name}-{$id}-icon">
                            <i class="{$item['icon']}"></i>
                        </div>
                    {/if}
                    {if $item['title'] neq ''}
                        <div class="{$name}-{$id}-title">{$item['title']}</div>
                    {/if}
                    {if $item['description'] neq ''}
                        <div class="{$name}-{$id}-desc">{$item['description']}</div>
                    {/if}
                    {if $item['link'] neq ''}
                        <a href="{$item['link']}" class="{$name}-{$id}-link">
                            {if $data['link_text'] neq ''}{$data['link_text']}{else}Learn more{/if}
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    {/if}
                </div>
            {/foreach}
        {else}
            <p style="text-align:center;color:#999;grid-column:1/-1;">No items added.</p>
        {/if}
    </div>
</div>
