<style>
    .{$name}-{$id} .puq-domain-tld-container {
                       position: relative;
                       z-index: 2;
                   {if $data['width'] neq ''}
                       max-width: {$data['width']};
                   {else}
                       padding-left: 20px;
                       padding-right: 20px;
                   {/if}
                       width: 100%;
                       display: inline-block;
                       text-align: center;
                   }

    .{$name}-{$id} .puq-domain-tld-container a:hover{
                       text-decoration: none;
                   }

    .{$name}-{$id} .puq-domain-tld-header {
                       text-align: center;
                       font-size: 2rem;
                       font-weight: bold;
                       text-transform: uppercase;
                       letter-spacing: 2px;
                       color: {$data['header_text_color']};
                   }

    .{$name}-{$id} .puq-domain-tld {
                       position: relative;
                       display: inline-block;
                   }

    .{$name}-{$id} .puq-domain-tld-group {
                       display: flex;
                       justify-content: center;
                       align-items: center;
                       width: fit-content;
                       white-space: nowrap;
                       height: 45px;
                       margin-bottom: 10px;
                       margin-top: 10px;
                       margin-left: 5px;
                       margin-right: 5px;
                       border: 2px solid {$data['color_1']};
                       border-radius: 8px;
                       box-sizing: border-box;
                       min-width: 250px;
                   }

    .{$name}-{$id} .puq-domain-tld img {
                       height: 19px;
                       margin-right: 5px;
                       margin-left: 5px;
                       width: auto;
                       display: block;
                   }

    .{$name}-{$id} .puq-domain-tld-name {
                       font-size: 18px;
                       font-weight: bold;
                       text-align: center;
                       margin: 0;
                       display: flex;
                       align-items: center;
                   }

    .{$name}-{$id} .puq-domain-tld-name-dot {
                       font-size: 40px;
                       font-weight: bold;
                       color: {$data['color_2']};
                       padding-bottom: 12px;
                   }

    .{$name}-{$id} .puq-domain-tld-name-name {
                       font-size: 25px;
                       font-weight: bold;
                       color: {$data['color_3']};
                       margin-right: 5px;
                   }

    .{$name}-{$id} .puq-domain-tld-pricing {
                       font-size: 30px;
                       font-weight: bold;
                       text-shadow: 0 2px 2px rgba(0,0,0,0.4);
                       transition: all 0.3s ease-in-out;
                       color: {$data['color_4']};
                   }

    .{$name}-{$id} .puq-domain-tld-label {
                       pointer-events: none;
                       position: absolute;
                       font-size: 15px;
                       font-weight: bold;
                       left: 5%;
                       top: -8px;
                       text-align: right;
                       padding: 1px 4px;
                       transform: perspective(200px) rotateX(6deg) rotateY(30deg);
                   }

    .{$name}-{$id} .puq-domain-tld-label-hot {
                       background-color: {$data['hot_color']};
                       color: {$data['hot_text_color']};
                   }

    .{$name}-{$id} .puq-domain-tld-label-new {
                       background-color: {$data['new_color']};
                       color: {$data['new_text_color']};

                   }

    .{$name}-{$id} .puq-domain-tld-label-sale {
                       background-color: {$data['sale_color']};
                       color: {$data['sale_text_color']};

                   }

    .{$name}-{$id} .puq-domain-tld-group:hover + .puq-domain-tld-label{
                       left: 50%;
                       transition: left 0.2s ease;
                   }

    .{$name}-{$id} .puq-domain-tld-group-hot:hover{
                       border: 2px solid {$data['hot_color']};
                       transition: border-color 0.5s ease;
                   }

    .{$name}-{$id} .puq-domain-tld-group-new{
                       text-align: center;
                   }

    .{$name}-{$id} .puq-domain-tld-group-new:hover{
                       border: 2px solid {$data['new_color']};
                       transition: border-color 0.5s ease;
                   }

    .{$name}-{$id} .puq-domain-tld-group-sale:hover{
                       border: 2px solid {$data['sale_color']};
                       transition: border-color 0.5s ease;
                   }

    .{$name}-{$id} .puq-domain-tld-btn-view-all-pricing {
                       position: relative;
                       text-align: center;
                       background-color: {$data['view_all_pricing_button_color']};
                       color: {$data['view_all_pricing_button_text_color']};
                       text-decoration: none !important;
                       display: inline-block;
                       white-space: nowrap;
                       border: 1px solid {$data['view_all_pricing_button_text_color']};
                       padding: 10px 20px;
                       font-size: 16px;
                       margin: 5px;
                       cursor: pointer;
                       transition: all 0.2s ease-in-out;
                       border-radius: 5px;
                   }
    .{$name}-{$id} .puq-domain-tld-btn-view-all-pricing:hover {
                       background-color: {$data['view_all_pricing_button_text_color']};
                       color: {$data['view_all_pricing_button_color']};
                       border: 1px solid {$data['view_all_pricing_button_color']};
                   }

    .{$name}-{$id} .puq-domain-tld-idn-year{
                       display: flex;
                       flex-direction: column;
                       align-items: flex-start;
                       height: 38px;
                       /*margin: 1px 15px 0 0 ;*/
                       margin-left: 10px;
                   }

    .{$name}-{$id} .puq-domain-tld-year {
                       font-size: 13px;
                       color: {$data['color_5']};
                       display: block;
                       margin: -4px 0 0 0  ;
                   }

    .{$name}-{$id} .puq-domain-tld-label-idn {
                       display: block;
                       padding: 0;
                       font-size: 15px;
                       font-weight: bold;
                       text-align: center;
                       transition: left 0.2s ease;
                       min-width: 40px;
                       color: {$data['idn_text_color']};
                       white-space: nowrap;
                       vertical-align: middle;
                       background-color: {$data['idn_color']};
                       border-radius: 5px;
                   }
    .{$name}-{$id} .puq-domain-tld-label-idn-buffer{
                       display: block;
                       font-size: 15px;
                       font-weight: bold;
                       text-align: center;
                       min-width: 40px;
                       white-space: nowrap;
                       vertical-align: middle;
                       border-radius: 5px;
                   }

</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    {if !$data['disable_header']}
        <h2 class="puq-domain-tld-header">{$data['header']}</h2>
    {/if}
    <div class="puq-domain-tld-container">
        {foreach $data['tld'] as $tld}
            <a href="{$before_path}/domain/pricing"">
            <div class="puq-domain-tld">
                <div class="puq-domain-tld-group puq-domain-tld-group-{$tld['label']}">
                    {if $tld['img'] neq ''}
                        <img src="{$tld['img']}" class="puq-domain-tld-img">
                    {else}
                        <span class="puq-domain-tld-name">
                        <span class="puq-domain-tld-name-dot">.</span>
                        <span class="puq-domain-tld-name-name">{$tld['tld']}</span>
                    </span>
                    {/if}
                    <span class="puq-domain-tld-pricing">{$tld['currency_prefix']} {$tld['pricing']} {$tld['currency_suffix']}</span>
                    <span class="puq-domain-tld-idn-year">
                    {if $tld['idn'] eq "true"}
                        <span class="puq-domain-tld-label-idn">{$data['idn_label']}</span>
                        {else}
                        <span class="puq-domain-tld-label-idn-buffer"> &nbsp; </span>
                    {/if}
                        <span class="puq-domain-tld-year">/ {$data['year']}</span>
                    </span>
                </div>
                {if $tld['label']}
                    <span class="puq-domain-tld-label puq-domain-tld-label-{$tld['label']}">{$data.{$temp|cat:$tld['label']|cat:"_label"}}</span>
                {/if}
            </div>
            </a>
        {/foreach}
    </div>
    {if !$data['disable_view_all_pricing_button']}
        <a href="{$before_path}/domain/pricing" class="puq-domain-tld-btn-view-all-pricing">{$data['view_all_pricing_button_name']}</a>
    {/if}
</div>