class PUQDomainTLD {
    static get toolbox() {
        return {
            title: 'Domain TLD',
            icon: '<i class="fas fa-globe"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQDomainTLD');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td  class="fieldlabel"><h1 style="color: blue;">Domain TLD</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

     <tr>
        <td class="fieldlabel"><b>Color</b></td>
        <td colspan="3" class="fieldarea">

            <label for="color_1">Color 1:</label>
            <input type="color" name="color_1" class="form-control input-inline input-50">

            <label for="color_2">Color 2:</label>
            <input type="color" name="color_2" class="form-control input-inline input-50">

            <label for="color_3">Color 3:</label>
            <input type="color" name="color_3" class="form-control input-inline input-50">

            <label for="color_4">Color 4:</label>
            <input type="color" name="color_4" class="form-control input-inline input-50">

            <label for="color_5">Color 5:</label>
            <input type="color" name="color_5" class="form-control input-inline input-50">

            <label for="color_6">Color 6:</label>
            <input type="color" name="color_6" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">

        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>

        </td>
    </tr>

       <tr>
        <td class="fieldlabel"><b>Header</b><br>e.g. (Secure your domain name)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="header" value="" class="form-control input-inline input-200">
            <label for="header_text_color">Text color:</label>
            <input type="color" name="header_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_header"><b>Disable header</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Year</td>
        <td class="fieldarea">
            <input type="text" name="year" value="" class="form-control input-inline input-300"></br>
        </td>
    </tr>


    <tr>
        <td class="fieldlabel">Hot label/color</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="hot_label" value="" class="form-control input-inline input-300">
            <input type="color" name="hot_color" class="form-control input-inline input-60">
            <label for="hot_text_color">Text color:</label>
            <input type="color" name="hot_text_color" value="" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel">New label/color</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="new_label" value="" class="form-control input-inline input-300">
            <input type="color" name="new_color" class="form-control input-inline input-60">
            <label for="new_text_color">Text color:</label>
            <input type="color" name="new_text_color" value="" class="form-control input-inline input-50">
        </td>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel">Sale label/color</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="sale_label" value="" class="form-control input-inline input-300">
            <input type="color" name="sale_color" class="form-control input-inline input-60">
            <label for="sale_text_color">Text color:</label>
            <input type="color" name="sale_text_color" value="" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel">IND label/color</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="idn_label" value="" class="form-control input-inline input-300">
            <input type="color" name="idn_color" class="form-control input-inline input-60">
            <label for="idn_text_color">Text color:</label>
            <input type="color" name="idn_text_color" value="" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>View all pricing button name</b><br>e.g. (View all pricing)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="view_all_pricing_button_name" value="" class="form-control input-inline input-200">
            <label for="view_all_pricing_button_color">Button color:</label>
            <input type="color" name="view_all_pricing_button_color" class="form-control input-inline input-50">
            <label for="view_all_pricing_button_text_color">Text color:</label>
            <input type="color" name="view_all_pricing_button_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_view_all_pricing_button"><b>Disable view all pricing button</b></label>
        </td>
    </tr>


    <tr>
        <td class="fieldlabel"><a type="button" name="add-row"><div style="font-size: 24px;" class="fa fa-plus"></div></a></td>
        <td class="fieldarea">
            <label for="max_show">Max show:</label>
            <input type="number" min="0" name="max_show" class="form-control input-inline input-50">
        </td>
        <td>
            <label class="checkbox-inline">
            <input type="checkbox" name="show_randomly_whmcs"><b>&nbsp;Show randomly from WHMCS&nbsp;</b></label>
        </td>
        <td>

        </td>
    </tr>

    <tr>
        <td class="fieldlabel"></td>
        <td colspan="3" class="fieldarea">
            <table name="TLDsTable" class="datatable">
                <thead>
                <tr>
                    <th class="text-center"><b>ILD</b></th>
                    <th class="text-center" ><b>IMG</b></th>
                    <th class="text-center">Promotion</th>
                    <th style="max-width: 100px;" class="text-center">IDN</th>
                    <th class="text-center"></th>
                    <th class="text-center"></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </td>
    </tr>

    </tbody>
</table>
`);
        const table = render.querySelector("[name='TLDsTable']");
        const addRowButton = render.querySelector("[name='add-row']");

        const tld = this.data && this.data.tld ? this.data.tld : "";
        const tbody = table.querySelector("tbody");
        Object.entries(tld).forEach(([key, value]) => {
            const row = document.createElement("tr");
            var label_none = '';
            var label_hot = '';
            var label_new = '';
            var label_sale = '';
            var idn_checked = '';
            var idn_value = '';
            if (value.label === '') {
                 label_none = 'selected';
            }if (value.label === 'hot') {
                label_hot = 'selected';
            }
            if (value.label === 'new') {
                label_new = 'selected';
            }
            if (value.label === 'sale') {
                label_sale = 'selected';
            }
            if (value.idn === 'true') {
                idn_checked = 'checked';
            }

                row.innerHTML = `
                <td class="text-center"><input type="text" name="tld" value="${value.tld}" class="form-control input-inline input-200"></td>
                <td class="text-center"><input type="text" name="img" value="${value.img}" class="form-control input-inline input-400"></td>
                <td class="text-center">
                    <select name="label" class="form-control" style="width: 100px;">
                        <option value="" ${label_none}>none</option>
                        <option value="hot" ${label_hot}>Hot</option>
                        <option value="new" ${label_new}>New</option>
                        <option value="sale" ${label_sale}>Sale</option>
                    </select>
                </td>
                <td class="text-center"><input type="checkbox" name="idn" ${idn_checked}></td>
                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
            `;
                tbody.appendChild(row);
                addRowListeners(row);
        });

        function addRow() {
            const tbody = table.querySelector("tbody");
            const row = document.createElement("tr");
            row.innerHTML = `
                <td class="text-center"><input type="text" name="tld" value="" class="form-control input-inline input-200"></td>
                <td class="text-center"><input type="text" name="img" value="" class="form-control input-inline input-400"></td>
                <td class="text-center">
                    <select name="label" class="form-control" style="width: 100px;">
                        <option value="">none</option>
                        <option value="hot">Hot</option>
                        <option value="new">New</option>
                        <option value="sale">Sale</option>
                    </select>
                </td>
                <td class="text-center"><input type="checkbox" name="idn"></td>
                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
  `;
            tbody.appendChild(row);
            addRowListeners(row);
        }

        function removeRow(row) {
            row.remove();
        }

        function moveRow(row, direction) {
            const tbody = row.parentNode;
            const rows = Array.from(tbody.children);
            const index = rows.indexOf(row);
            const newIndex = index + direction;

            if (newIndex >= 0 && newIndex < rows.length) {
                const siblingRow = rows[newIndex];
                if (direction === 1) {
                    tbody.insertBefore(row, siblingRow.nextSibling);
                } else {
                    tbody.insertBefore(row, siblingRow);
                }
            } else if (newIndex === -1) {
                tbody.insertBefore(row, rows[0]);
            } else if (newIndex === rows.length) {
                tbody.insertBefore(row, null);
            }
        }

        function addRowListeners(row) {
            const removeButton = row.querySelector("[name='remove-row']");
            const moveUpButton = row.querySelector("[name='move-up']");
            const moveDownButton = row.querySelector("[name='move-down']");

            removeButton.addEventListener("click", () => {
                removeRow(row);
            });

            moveUpButton.addEventListener("click", () => {
                moveRow(row, -1);
            });

            moveDownButton.addEventListener("click", () => {
                moveRow(row, 1);
            });
        }

        addRowButton.addEventListener("click", () => {
            addRow();
        });


        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const color_1 = this.data && this.data.color_1 ? this.data.color_1 : "";
        $(render).find("[name='color_1']").val(color_1);
        if (color_1 === '') {
            $(render).find("[name='color_1']").val('#6420c0');
        }

        const color_2 = this.data && this.data.color_2 ? this.data.color_2 : "";
        $(render).find("[name='color_2']").val(color_2);
        if (color_2 === '') {
            $(render).find("[name='color_2']").val('#0de1b9');
        }

        const color_3 = this.data && this.data.color_3 ? this.data.color_3 : "";
        $(render).find("[name='color_3']").val(color_3);
        if (color_3 === '') {
            $(render).find("[name='color_3']").val('#6420c0');
        }

        const color_4 = this.data && this.data.color_4 ? this.data.color_4 : "";
        $(render).find("[name='color_4']").val(color_4);
        if (color_4 === '') {
            $(render).find("[name='color_4']").val('#d41111');
        }

        const color_5 = this.data && this.data.color_5 ? this.data.color_5 : "";
        $(render).find("[name='color_5']").val(color_5);
        if (color_5 === '') {
            $(render).find("[name='color_5']").val('#a484d5');
        }

        const color_6 = this.data && this.data.color_6 ? this.data.color_6 : "";
        $(render).find("[name='color_6']").val(color_6);
        if (color_6 === '') {
            $(render).find("[name='color_6']").val('#000000');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#ffffff');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }

        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }

        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const header = this.data && this.data.header ? this.data.header : "";
        $(render).find("[name='header']").val(header);
        if (header === '') {
            $(render).find("[name='header']").val('Secure your domain name');
        }

        const header_text_color = this.data && this.data.header_text_color ? this.data.header_text_color : "";
        $(render).find("[name='header_text_color']").val(header_text_color);
        if (header_text_color === '') {
            $(render).find("[name='header_text_color']").val('#000000');
        }

        if (this.data.disable_header === true) {
            $(render).find("[name='disable_header']").attr('checked', 'checked');
        }

        const year = this.data && this.data.year ? this.data.year : "";
        $(render).find("[name='year']").val(year);
        if (year === '') {
            $(render).find("[name='year']").val('year');
        }

        const hot_label = this.data && this.data.hot_label ? this.data.hot_label : "";
        $(render).find("[name='hot_label']").val(hot_label);
        if (hot_label === '') {
            $(render).find("[name='hot_label']").val('Hot');
        }

        const hot_color = this.data && this.data.hot_color ? this.data.hot_color : "";
        $(render).find("[name='hot_color']").val(hot_color);
        if (hot_color === '') {
            $(render).find("[name='hot_color']").val('#d51111');
        }

        const hot_text_color = this.data && this.data.hot_text_color ? this.data.hot_text_color : "";
        $(render).find("[name='hot_text_color']").val(hot_text_color);
        if (hot_text_color === '') {
            $(render).find("[name='hot_text_color']").val('#ffffff');
        }

        const new_label = this.data && this.data.new_label ? this.data.new_label : "";
        $(render).find("[name='new_label']").val(new_label);
        if (new_label === '') {
            $(render).find("[name='new_label']").val('New');
        }

        const new_color = this.data && this.data.new_color ? this.data.new_color : "";
        $(render).find("[name='new_color']").val(new_color);
        if (new_color === '') {
            $(render).find("[name='new_color']").val('#5cb75c');
        }

        const new_text_color = this.data && this.data.new_text_color ? this.data.new_text_color : "";
        $(render).find("[name='new_text_color']").val(new_text_color);
        if (new_text_color === '') {
            $(render).find("[name='new_text_color']").val('#4f1998');
        }

        const sale_label = this.data && this.data.sale_label ? this.data.sale_label : "";
        $(render).find("[name='sale_label']").val(sale_label);
        if (sale_label === '') {
            $(render).find("[name='sale_label']").val('Sale');
        }

        const sale_color = this.data && this.data.sale_color ? this.data.sale_color : "";
        $(render).find("[name='sale_color']").val(sale_color);
        if (sale_color === '') {
            $(render).find("[name='sale_color']").val('#eeac4e');
        }

        const sale_text_color = this.data && this.data.sale_text_color ? this.data.sale_text_color : "";
        $(render).find("[name='sale_text_color']").val(sale_text_color);
        if (sale_text_color === '') {
            $(render).find("[name='sale_text_color']").val('#000000');
        }

        const idn_label = this.data && this.data.idn_label ? this.data.idn_label : "";
        $(render).find("[name='idn_label']").val(idn_label);
        if (idn_label === '') {
            $(render).find("[name='idn_label']").val('IND');
        }

        const idn_color = this.data && this.data.idn_color ? this.data.idn_color : "";
        $(render).find("[name='idn_color']").val(idn_color);
        if (idn_color === '') {
            $(render).find("[name='idn_color']").val('#767676');
        }

        const idn_text_color = this.data && this.data.idn_text_color ? this.data.idn_text_color : "";
        $(render).find("[name='idn_text_color']").val(idn_text_color);
        if (idn_text_color === '') {
            $(render).find("[name='idn_text_color']").val('#fdfdfd');
        }

        const view_all_pricing_button_name = this.data && this.data.view_all_pricing_button_name ? this.data.view_all_pricing_button_name : "";
        $(render).find("[name='view_all_pricing_button_name']").val(view_all_pricing_button_name);
        if (view_all_pricing_button_name === '') {
            $(render).find("[name='view_all_pricing_button_name']").val('View all pricing');
        }

        const view_all_pricing_button_color = this.data && this.data.view_all_pricing_button_color ? this.data.view_all_pricing_button_color : "";
        $(render).find("[name='view_all_pricing_button_color']").val(view_all_pricing_button_color);
        if (view_all_pricing_button_color === '') {
            $(render).find("[name='view_all_pricing_button_color']").val('#0de1b9');
        }

        const view_all_pricing_button_text_color = this.data && this.data.view_all_pricing_button_text_color ? this.data.view_all_pricing_button_text_color : "";
        $(render).find("[name='view_all_pricing_button_text_color']").val(view_all_pricing_button_text_color);
        if (view_all_pricing_button_text_color === '') {
            $(render).find("[name='view_all_pricing_button_text_color']").val('#6420c0');
        }

        if (this.data.disable_view_all_pricing_button === true) {
            $(render).find("[name='disable_view_all_pricing_button']").attr('checked', 'checked');
        }

        const max_show = this.data && this.data.max_show ? this.data.max_show : "";
        $(render).find("[name='max_show']").val(max_show);
        if (max_show === '') {
            $(render).find("[name='max_show']").val('0');
        }

        if (this.data.show_randomly_whmcs === true) {
            $(render).find("[name='show_randomly_whmcs']").attr('checked', 'checked');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {

        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }

        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }

        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }

        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }

        var disable_header = false;
        if ($(content).find("[name='disable_header']").is(':checked')) {
            disable_header = true;
        }

        var disable_view_all_pricing_button = false;
        if ($(content).find("[name='disable_view_all_pricing_button']").is(':checked')) {
            disable_view_all_pricing_button = true;
        }

        var show_randomly_whmcs = false;
        if ($(content).find("[name='show_randomly_whmcs']").is(':checked')) {
            show_randomly_whmcs = true;
        }

        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        const table = content.querySelector("[name='TLDsTable']")
        const rows = table.querySelectorAll('tbody tr');
        const data = {};
        rows.forEach((row, index) => {
            const inputs = row.querySelectorAll('input');
            const selects = row.querySelectorAll('select');


            const values = {};
            inputs.forEach(input => {
                const name = input.getAttribute('name');
                if (name === 'tld' || name === 'img' || name === 'label' || name === 'idn') {
                    if(name === 'idn') {
                        if($(input).is(':checked')) {
                            input.value = true;
                        } else {
                            input.value = false;
                        }
                    }
                    values[name] = input.value;
                }
            });

            selects.forEach(select => {
                const name = select.getAttribute('name');
                if (name === 'label') {
                    values[name] = select.value;
                }
                if (name === 'idn') {
                    values[name] = select.value;
                }
            });
            if (Object.keys(values).length > 0) {
                data[index] = values;
            }
        });

        return {
            "width": $(content).find("[name='width']").val().replace(/	/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/	/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/	/g, ""),
            "style": style.replace(/	/g, ""),

            "color_1": $(content).find("[name='color_1']").val().replace(/	/g, ""),
            "color_2": $(content).find("[name='color_2']").val().replace(/	/g, ""),
            "color_3": $(content).find("[name='color_3']").val().replace(/	/g, ""),
            "color_4": $(content).find("[name='color_4']").val().replace(/	/g, ""),
            "color_5": $(content).find("[name='color_5']").val().replace(/	/g, ""),
            "color_6": $(content).find("[name='color_6']").val().replace(/	/g, ""),

            "background_image": $(content).find("[name='background_image']").val().replace(/	/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/	/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,

            "header": $(content).find("[name='header']").val().replace(/	/g, ""),
            "header_text_color": $(content).find("[name='header_text_color']").val().replace(/	/g, ""),
            "disable_header": disable_header,

            "year": $(content).find("[name='year']").val().replace(/	/g, ""),

            "hot_label": $(content).find("[name='hot_label']").val().replace(/	/g, ""),
            "hot_color": $(content).find("[name='hot_color']").val().replace(/	/g, ""),
            "hot_text_color": $(content).find("[name='hot_text_color']").val().replace(/	/g, ""),

            "new_label": $(content).find("[name='new_label']").val().replace(/	/g, ""),
            "new_color": $(content).find("[name='new_color']").val().replace(/	/g, ""),
            "new_text_color": $(content).find("[name='new_text_color']").val().replace(/	/g, ""),

            "sale_label": $(content).find("[name='sale_label']").val().replace(/	/g, ""),
            "sale_color": $(content).find("[name='sale_color']").val().replace(/	/g, ""),
            "sale_text_color": $(content).find("[name='sale_text_color']").val().replace(/	/g, ""),

            "idn_label": $(content).find("[name='idn_label']").val().replace(/	/g, ""),
            "idn_color": $(content).find("[name='idn_color']").val().replace(/	/g, ""),
            "idn_text_color": $(content).find("[name='idn_text_color']").val().replace(/	/g, ""),

            "max_show": $(content).find("[name='max_show']").val().replace(/	/g, ""),
            "show_randomly_whmcs": show_randomly_whmcs,

            "view_all_pricing_button_name": $(content).find("[name='view_all_pricing_button_name']").val().replace(/	/g, ""),
            "view_all_pricing_button_color": $(content).find("[name='view_all_pricing_button_color']").val().replace(/	/g, ""),
            "view_all_pricing_button_text_color": $(content).find("[name='view_all_pricing_button_text_color']").val().replace(/	/g, ""),
            "disable_view_all_pricing_button" : disable_view_all_pricing_button,

            "tld": data
        };
    }
}
