<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        display: flex;
        {if $data['layout'] eq 'horizontal'}
            flex-direction: row;
            align-items: center;
            justify-content: space-between;
            text-align: left;
        {elseif $data['layout'] eq 'left'}
            flex-direction: column;
            align-items: flex-start;
            text-align: left;
        {else}
            flex-direction: column;
            align-items: center;
            text-align: center;
        {/if}
        max-width: 960px;
        margin: 0 auto;
        padding: 50px 30px;
    }

    .{$name}-{$id} .{$name}-{$id}-text {
        {if $data['layout'] eq 'horizontal'}
            flex: 1;
            padding-right: 40px;
        {else}
            margin-bottom: 30px;
        {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-subtitle {
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 2px;
        color: {if $data['button_color'] neq ''}{$data['button_color']}{else}#337ab7{/if};
        margin-bottom: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-heading {
        font-size: 2.2rem;
        font-weight: 700;
        color: {if $data['text_color'] neq ''}{$data['text_color']}{else}#2c3e50{/if};
        margin: 0 0 16px 0;
        line-height: 1.25;
    }

    .{$name}-{$id} .{$name}-{$id}-desc {
        font-size: 1.1rem;
        color: {if $data['text_color'] neq ''}{$data['text_color']}{else}#555{/if};
        opacity: 0.85;
        line-height: 1.7;
        margin: 0;
        max-width: 640px;
    }

    .{$name}-{$id} .{$name}-{$id}-buttons {
        display: flex;
        gap: 14px;
        flex-wrap: wrap;
        {if $data['layout'] eq 'center'}
            justify-content: center;
        {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-btn {
        display: inline-block;
        padding: {if $data['button_size'] eq 'lg'}16px 44px{elseif $data['button_size'] eq 'sm'}10px 22px{else}13px 32px{/if};
        font-size: {if $data['button_size'] eq 'lg'}1.15rem{elseif $data['button_size'] eq 'sm'}0.85rem{else}1rem{/if};
        font-weight: 600;
        text-decoration: none;
        border-radius: {if $data['button_rounded']}50px{else}8px{/if};
        transition: all 0.25s ease;
        cursor: pointer;
        border: 2px solid transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-btn-primary {
        background: {if $data['button_color'] neq ''}{$data['button_color']}{else}#337ab7{/if};
        color: #fff;
        border-color: {if $data['button_color'] neq ''}{$data['button_color']}{else}#337ab7{/if};
    }

    .{$name}-{$id} .{$name}-{$id}-btn-primary:hover {
        filter: brightness(1.1);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
        color: #fff;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-btn-secondary {
        background: transparent;
        color: {if $data['button2_color'] neq ''}{$data['button2_color']}{else}#6c757d{/if};
        border-color: {if $data['button2_color'] neq ''}{$data['button2_color']}{else}#6c757d{/if};
    }

    .{$name}-{$id} .{$name}-{$id}-btn-secondary:hover {
        background: {if $data['button2_color'] neq ''}{$data['button2_color']}{else}#6c757d{/if};
        color: #fff;
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
        text-decoration: none;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-container {
            flex-direction: column;
            text-align: center;
            padding: 35px 20px;
        }
        .{$name}-{$id} .{$name}-{$id}-text {
            padding-right: 0;
            margin-bottom: 25px;
        }
        .{$name}-{$id} .{$name}-{$id}-heading {
            font-size: 1.6rem;
        }
        .{$name}-{$id} .{$name}-{$id}-buttons {
            justify-content: center;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-container">
        <div class="{$name}-{$id}-text">
            {if $data['subtitle'] neq ''}
                <div class="{$name}-{$id}-subtitle">{$data['subtitle']}</div>
            {/if}
            {if $data['heading'] neq ''}
                <h2 class="{$name}-{$id}-heading">{$data['heading']}</h2>
            {/if}
            {if $data['description'] neq ''}
                <p class="{$name}-{$id}-desc">{$data['description']}</p>
            {/if}
        </div>
        {if $data['button_text'] neq '' || $data['button2_text'] neq ''}
            <div class="{$name}-{$id}-buttons">
                {if $data['button_text'] neq ''}
                    <a href="{$data['button_url']}" target="{if $data['button_target'] neq ''}{$data['button_target']}{else}_self{/if}" class="{$name}-{$id}-btn {$name}-{$id}-btn-primary">{$data['button_text']}</a>
                {/if}
                {if $data['button2_text'] neq ''}
                    <a href="{$data['button2_url']}" target="{if $data['button2_target'] neq ''}{$data['button2_target']}{else}_self{/if}" class="{$name}-{$id}-btn {$name}-{$id}-btn-secondary">{$data['button2_text']}</a>
                {/if}
            </div>
        {/if}
    </div>
</div>
