<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        max-width: 900px;
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-item {
        background: #fff;
        border-radius: 12px;
        padding: 24px 28px;
        margin-bottom: 16px;
        box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
        border-left: 4px solid #337ab7;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        display: flex;
        align-items: flex-start;
        gap: 18px;
    }

    .{$name}-{$id} .{$name}-{$id}-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
    }

    .{$name}-{$id} .{$name}-{$id}-icon {
        flex-shrink: 0;
        width: 44px;
        height: 44px;
        border-radius: 10px;
        background: linear-gradient(135deg, #337ab7, #286090);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 18px;
    }

    .{$name}-{$id} .{$name}-{$id}-body {
        flex: 1;
        min-width: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-date {
        font-size: 0.78rem;
        color: #999;
        margin-bottom: 4px;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 8px;
        line-height: 1.4;
    }

    .{$name}-{$id} .{$name}-{$id}-title a {
        color: #2c3e50;
        text-decoration: none;
        transition: color 0.15s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-title a:hover {
        color: #337ab7;
    }

    .{$name}-{$id} .{$name}-{$id}-excerpt {
        font-size: 0.9rem;
        color: #666;
        line-height: 1.65;
        margin-bottom: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-link {
        display: inline-flex;
        align-items: center;
        gap: 5px;
        color: #337ab7;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.85rem;
        transition: gap 0.2s ease, color 0.15s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-link:hover {
        color: #286090;
        gap: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-empty {
        text-align: center;
        padding: 40px 20px;
        color: #aaa;
        font-size: 0.95rem;
    }

    .{$name}-{$id} .{$name}-{$id}-empty i {
        display: block;
        font-size: 2rem;
        margin-bottom: 10px;
        color: #ccc;
    }

    @media (max-width: 600px) {
        .{$name}-{$id} .{$name}-{$id}-item {
            flex-direction: column;
            gap: 12px;
            padding: 18px 20px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    <div class="{$name}-{$id}-container">
        {if isset($data['announcements']) && $data['announcements']}
            {foreach $data['announcements'] as $ann}
                <div class="{$name}-{$id}-item">
                    <div class="{$name}-{$id}-icon">
                        <i class="fas fa-bullhorn"></i>
                    </div>
                    <div class="{$name}-{$id}-body">
                        {if $data['show_date']}
                            <div class="{$name}-{$id}-date">
                                <i class="far fa-calendar-alt"></i> {$ann['date']|date_format:"%B %e, %Y"}
                            </div>
                        {/if}
                        <div class="{$name}-{$id}-title">
                            <a href="{$ann['url']}">{$ann['title']}</a>
                        </div>
                        {if $data['show_excerpt'] && $ann['excerpt'] neq ''}
                            <div class="{$name}-{$id}-excerpt">{$ann['excerpt']}</div>
                        {/if}
                        <a href="{$ann['url']}" class="{$name}-{$id}-link">
                            {if $data['link_text'] neq ''}{$data['link_text']}{else}Read more{/if}
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            {/foreach}
        {else}
            <div class="{$name}-{$id}-empty">
                <i class="fas fa-bullhorn"></i>
                No announcements available.
            </div>
        {/if}
    </div>
</div>
