<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-sliders-h"></i> {$meta.lang['General Settings']}</h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="settings-content" style="display:none;">
        <div id="page-rewrites"></div>
        <div id="custom-rewrites"></div>
        <div id="import-export"></div>
        <div class="row" style="margin-top:15px;">
            <div class="col-md-12">
                <button type="button" class="btn btn-primary btn-lg" onclick="saveAllSettings(this)">
                    <i class="fas fa-check-square"></i> {$meta.lang['Save Settings']}
                </button>
            </div>
        </div>
    </div>
</div>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var settingsData = {};
    var pagesData = [];
    var customRewritesData = [];

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    function buildPageOptions(selectedId) {
        var html = '<option value="">{/literal}{$meta.lang['None']}{literal}</option>';
        for (var i = 0; i < pagesData.length; i++) {
            var p = pagesData[i];
            var sel = (selectedId && String(selectedId) === String(p.id)) ? ' selected' : '';
            html += '<option value="' + p.id + '"' + sel + '>' + escapeHtml(p.name || '(#' + p.id + ')') + '</option>';
        }
        return html;
    }

    var loadedCount = 0;
    function checkLoaded() {
        loadedCount++;
        if (loadedCount >= 3) {
            document.getElementById('main-loading').style.display = 'none';
            document.getElementById('settings-content').style.display = '';
            renderPageRewrites();
            renderCustomRewrites();
            renderImportExport();
        }
    }

    jQuery.ajax({
        url: ajaxUrl + '&ajax=getSettings',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                settingsData = response.data;
            } else {
                if (response.error) showNotification(response.error, 'error');
            }
            checkLoaded();
        },
        error: function() {
            showNotification('{/literal}{$meta.lang['Failed to load settings']}{literal}', 'error');
            checkLoaded();
        }
    });

    jQuery.ajax({
        url: ajaxUrl + '&ajax=getPages',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                pagesData = response.data;
            }
            checkLoaded();
        },
        error: function() {
            checkLoaded();
        }
    });

    jQuery.ajax({
        url: ajaxUrl + '&ajax=getRewrites',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.data) {
                customRewritesData = response.data;
            }
            checkLoaded();
        },
        error: function() {
            checkLoaded();
        }
    });

    function renderPageRewrites() {
        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-8">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-exchange-alt"></i> {/literal}{$meta.lang['Page Rewrites']}{literal}</h3></div>';
        html += '<div class="panel-body"><form class="form-horizontal">';

        html += '<div class="form-group" style="margin-bottom:15px;">';
        html += '<label class="col-sm-3 control-label">{/literal}{$meta.lang['Rewrite Home Page']}{literal}</label>';
        html += '<div class="col-sm-9">';
        html += '<select id="rewrite-home-enabled" class="form-control" style="width:80px; display:inline-block;">';
        html += '<option value="yes"' + (settingsData.rewrite_home_page === 'yes' ? ' selected' : '') + '>{/literal}{$meta.lang['YES']}{literal}</option>';
        html += '<option value="no"' + (settingsData.rewrite_home_page !== 'yes' ? ' selected' : '') + '>{/literal}{$meta.lang['NO']}{literal}</option>';
        html += '</select> ';
        html += '<select id="rewrite-home-page" class="form-control" style="width:auto; max-width:400px; display:inline-block;">' + buildPageOptions(settingsData.rewrite_home_page_id) + '</select>';
        html += '</div></div>';

        html += '<div class="form-group" style="margin-bottom:15px;">';
        html += '<label class="col-sm-3 control-label">{/literal}{$meta.lang['Rewrite Footer']}{literal}</label>';
        html += '<div class="col-sm-9">';
        html += '<select id="rewrite-footer-enabled" class="form-control" style="width:80px; display:inline-block;">';
        html += '<option value="yes"' + (settingsData.rewrite_footer === 'yes' ? ' selected' : '') + '>{/literal}{$meta.lang['YES']}{literal}</option>';
        html += '<option value="no"' + (settingsData.rewrite_footer !== 'yes' ? ' selected' : '') + '>{/literal}{$meta.lang['NO']}{literal}</option>';
        html += '</select> ';
        html += '<select id="rewrite-footer-page" class="form-control" style="width:auto; max-width:400px; display:inline-block;">' + buildPageOptions(settingsData.rewrite_footer_page_id) + '</select>';
        html += '</div></div>';

        html += '<div class="form-group" style="margin-bottom:15px;">';
        html += '<label class="col-sm-3 control-label">{/literal}{$meta.lang['Rewrite Domain Register']}{literal}</label>';
        html += '<div class="col-sm-9">';
        html += '<select id="rewrite-domainregister-enabled" class="form-control" style="width:80px; display:inline-block;">';
        html += '<option value="yes"' + (settingsData.rewrite_domain_register === 'yes' ? ' selected' : '') + '>{/literal}{$meta.lang['YES']}{literal}</option>';
        html += '<option value="no"' + (settingsData.rewrite_domain_register !== 'yes' ? ' selected' : '') + '>{/literal}{$meta.lang['NO']}{literal}</option>';
        html += '</select> ';
        html += '<select id="rewrite-domainregister-page" class="form-control" style="width:auto; max-width:400px; display:inline-block;">' + buildPageOptions(settingsData.rewrite_domain_register_page_id) + '</select>';
        html += '</div></div>';

        html += '</form></div></div></div></div>';
        document.getElementById('page-rewrites').innerHTML = html;
    }

    function renderCustomRewrites() {
        var custom = customRewritesData || [];
        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-random"></i> {/literal}{$meta.lang['Custom Rewrites']}{literal}</h3></div>';
        html += '<div class="panel-body">';
        html += '<p class="text-muted" style="margin-bottom:10px;"><small>{/literal}{$meta.lang['Use * as wildcard. Example: *knowledgebase* matches any URL containing "knowledgebase"']}{literal}</small></p>';
        html += '<div class="table-responsive">';
        html += '<table class="table table-striped table-condensed" id="custom-rewrites-table">';
        html += '<thead><tr><th style="width:35%">{/literal}{$meta.lang['WHMCS Page']}{literal}</th><th style="width:35%">{/literal}{$meta.lang['Custom Page']}{literal}</th><th style="width:10%; text-align:center;">{/literal}{$meta.lang['Active']}{literal}</th><th style="width:20%">{/literal}{$meta.lang['Actions']}{literal}</th></tr></thead>';
        html += '<tbody id="custom-rewrites-body">';

        for (var i = 0; i < custom.length; i++) {
            html += buildRewriteRow(custom[i], i);
        }

        html += '</tbody></table>';
        html += '</div>';
        html += '<button type="button" class="btn btn-success btn-sm" onclick="addRewriteRow()"><i class="fa fa-plus"></i> {/literal}{$meta.lang['Add Rewrite']}{literal}</button>';
        html += '</div></div></div></div>';
        document.getElementById('custom-rewrites').innerHTML = html;
    }

    function buildRewriteRow(rewrite, index) {
        var html = '<tr id="rewrite-row-' + index + '">';
        html += '<td><input type="text" class="form-control input-sm rewrite-whmcs-page" value="' + escapeHtml(rewrite.whmcs_page || '') + '" placeholder="{/literal}{$meta.lang['e.g. cart.php or *knowledgebase*']}{literal}"></td>';
        html += '<td><select class="form-control input-sm rewrite-custom-page">' + buildPageOptions(rewrite.page_id) + '</select></td>';
        html += '<td style="text-align:center; vertical-align:middle;"><input type="checkbox" class="rewrite-active"' + (rewrite.is_active == 1 ? ' checked' : '') + '></td>';
        html += '<td>';
        if (rewrite.id) {
            html += '<input type="hidden" class="rewrite-id" value="' + rewrite.id + '">';
            html += '<button type="button" class="btn btn-xs btn-danger" onclick="deleteRewrite(' + rewrite.id + ', ' + index + ', this)"><i class="fa fa-trash"></i></button>';
        } else {
            html += '<input type="hidden" class="rewrite-id" value="">';
            html += '<button type="button" class="btn btn-xs btn-danger" onclick="removeRewriteRow(' + index + ')"><i class="fa fa-times"></i></button>';
        }
        html += '</td></tr>';
        return html;
    }

    var rewriteIndex = customRewritesData.length;

    window.addRewriteRow = function() {
        var tbody = document.getElementById('custom-rewrites-body');
        var row = buildRewriteRow({ whmcs_page: '', page_id: '', is_active: 1 }, rewriteIndex);
        tbody.insertAdjacentHTML('beforeend', row);
        rewriteIndex++;
    };

    window.removeRewriteRow = function(index) {
        var row = document.getElementById('rewrite-row-' + index);
        if (row) row.remove();
    };

    window.deleteRewrite = function(id, index, btn) {
        if (!confirm('{/literal}{$meta.lang['Confirm Delete']}{literal}')) return;
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=deleteRewrite',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ id: id }),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    var row = document.getElementById('rewrite-row-' + index);
                    if (row) row.remove();
                    showNotification('{/literal}{$meta.lang['Deleted successfully']}{literal}', 'success');
                } else {
                    btnReset(btn);
                    showNotification(response.error || '{/literal}{$meta.lang['Delete failed']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('{/literal}{$meta.lang['Delete failed']}{literal}', 'error');
            }
        });
    };

    function renderImportExport() {
        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-8">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-file-import"></i> {/literal}{$meta.lang['Import / Export']}{literal}</h3></div>';
        html += '<div class="panel-body"><form class="form-horizontal">';

        html += '<div class="form-group" style="margin-bottom:15px;">';
        html += '<label class="col-sm-3 control-label">{/literal}{$meta.lang['Export']}{literal}</label>';
        html += '<div class="col-sm-9">';
        html += '<select id="export-page-id" class="form-control" style="width:auto; max-width:300px; display:inline-block;">' + buildPageOptions('') + '</select> ';
        html += '<button type="button" class="btn btn-info btn-sm" onclick="exportPage(this)"><i class="fa fa-download"></i> {/literal}{$meta.lang['Export']}{literal}</button> ';
        html += '<button type="button" class="btn btn-success btn-sm" onclick="exportAllPages(this)"><i class="fa fa-download"></i> {/literal}{$meta.lang['Export All Pages']}{literal}</button>';
        html += '</div></div>';

        html += '<div class="form-group" style="margin-bottom:15px;">';
        html += '<label class="col-sm-3 control-label">{/literal}{$meta.lang['Import']}{literal}</label>';
        html += '<div class="col-sm-9">';
        html += '<input type="file" id="import-file" accept=".json" class="form-control" style="width:auto; max-width:300px; display:inline-block;"> ';
        html += '<button type="button" class="btn btn-warning btn-sm" onclick="importPage()"><i class="fa fa-upload"></i> {/literal}{$meta.lang['Import']}{literal}</button>';
        html += '</div></div>';

        html += '</form></div></div></div></div>';
        document.getElementById('import-export').innerHTML = html;
    }

    window.exportAllPages = function(btn) {
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=exportAllPages',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    var blob = new Blob([JSON.stringify(response.data, null, 2)], { type: 'application/json' });
                    var a = document.createElement('a');
                    a.href = URL.createObjectURL(blob);
                    a.download = 'all_pages_export.json';
                    a.click();
                    showNotification('{/literal}{$meta.lang['Page exported']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Export failed']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('{/literal}{$meta.lang['Export failed']}{literal}', 'error');
            }
        });
    };

    window.exportPage = function(btn) {
        var pageId = document.getElementById('export-page-id').value;
        if (!pageId) {
            showNotification('{/literal}{$meta.lang['Please select a page']}{literal}', 'error');
            return;
        }
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=exportPage&id=' + pageId,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    var blob = new Blob([JSON.stringify(response.data, null, 2)], { type: 'application/json' });
                    var a = document.createElement('a');
                    a.href = URL.createObjectURL(blob);
                    a.download = 'page_' + pageId + '_export.json';
                    a.click();
                    showNotification('{/literal}{$meta.lang['Page exported']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Export failed']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('{/literal}{$meta.lang['Export failed']}{literal}', 'error');
            }
        });
    };

    window.importPage = function() {
        var fileInput = document.getElementById('import-file');
        if (!fileInput.files || !fileInput.files[0]) {
            showNotification('{/literal}{$meta.lang['Please select a file']}{literal}', 'error');
            return;
        }
        var reader = new FileReader();
        reader.onload = function(e) {
            try {
                var importData = JSON.parse(e.target.result);
            } catch (err) {
                showNotification('Invalid JSON file', 'error');
                return;
            }
            jQuery.ajax({
                url: ajaxUrl + '&ajax=importPage',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(importData),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        showNotification('{/literal}{$meta.lang['Page imported successfully']}{literal}', 'success');
                        fileInput.value = '';
                    } else {
                        showNotification(response.error || '{/literal}{$meta.lang['Import failed']}{literal}', 'error');
                    }
                },
                error: function() {
                    showNotification('{/literal}{$meta.lang['Import failed']}{literal}', 'error');
                }
            });
        };
        reader.readAsText(fileInput.files[0]);
    };

    window.saveAllSettings = function(btn) {
        btnLoading(btn);
        var settings = {
            rewrite_home_page: document.getElementById('rewrite-home-enabled').value,
            rewrite_home_page_id: document.getElementById('rewrite-home-page').value,
            rewrite_footer: document.getElementById('rewrite-footer-enabled').value,
            rewrite_footer_page_id: document.getElementById('rewrite-footer-page').value,
            rewrite_domain_register: document.getElementById('rewrite-domainregister-enabled').value,
            rewrite_domain_register_page_id: document.getElementById('rewrite-domainregister-page').value
        };

        jQuery.ajax({
            url: ajaxUrl + '&ajax=saveSettings',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(settings),
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Saved successfully']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Save failed']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('{/literal}{$meta.lang['Save failed']}{literal}', 'error');
            }
        });

        var rows = document.querySelectorAll('#custom-rewrites-body tr');
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i];
            var whmcsPage = row.querySelector('.rewrite-whmcs-page');
            var customPage = row.querySelector('.rewrite-custom-page');
            var active = row.querySelector('.rewrite-active');
            var idField = row.querySelector('.rewrite-id');

            if (!whmcsPage || !whmcsPage.value) continue;

            var rewriteData = {
                id: idField ? (parseInt(idField.value) || null) : null,
                whmcs_page: whmcsPage.value,
                page_id: customPage ? customPage.value : '',
                is_active: active ? (active.checked ? 1 : 0) : 1
            };

            jQuery.ajax({
                url: ajaxUrl + '&ajax=saveRewrite',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(rewriteData),
                dataType: 'json'
            });
        }
    };
});
</script>
{/literal}
