<div class="row">
    <div class="col-md-12">
        <h1><i class="far fa-file-alt"></i> {$meta.lang['All Pages']}</h1>
        <div style="margin-bottom:15px;">
            <button type="button" id="btn-create-page" class="btn btn-primary" onclick="createNewPage(this)"><i class="fa fa-plus"></i> {$meta.lang['Create New Page']}</button>
            <button type="button" id="btn-import-page" class="btn btn-default" onclick="document.getElementById('import-file-pages').click()"><i class="fa fa-upload"></i> {$meta.lang['Import']}</button>
            <button type="button" id="btn-export-all" class="btn btn-default" onclick="exportAllPages(this)"><i class="fa fa-download"></i> {$meta.lang['Export All Pages']}</button>
            <input type="file" id="import-file-pages" accept=".json" style="display:none;" onchange="importPageFromFile(this)">
        </div>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="pages-table"></div>
</div>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';
    var editUrl = ajaxUrl + '&page=page_edit&id=';

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    function statusBadge(status) {
        var map = { published: 'success', draft: 'warning', archived: 'default' };
        return '<span class="label label-' + (map[status] || 'default') + '">' + escapeHtml(status) + '</span>';
    }

    function loadPages() {
        jQuery.ajax({
            url: ajaxUrl + '&ajax=getPages',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                document.getElementById('main-loading').style.display = 'none';
                if (!response.success || !response.data) {
                    if (response.error) showNotification(response.error, 'error');
                    return;
                }
                renderTable(response.data || []);
            },
            error: function() {
                document.getElementById('main-loading').style.display = 'none';
                showNotification('Failed to load pages', 'error');
            }
        });
    }

    function renderTable(pages) {
        var html = '<div class="panel panel-default" style="margin-top:10px;">';
        html += '<div class="panel-body">';
        if (pages.length === 0) {
            html += '<p class="text-muted text-center" style="padding:30px;">{/literal}{$meta.lang['No pages found']}{literal}</p>';
        } else {
            html += '<table class="datatable" style="width:100%;">';
            html += '<tr class="header"><th>{/literal}{$meta.lang['ID']}{literal}</th><th>{/literal}{$meta.lang['Name']}{literal}</th><th>{/literal}{$meta.lang['URL']}{literal}</th><th>{/literal}{$meta.lang['Status']}{literal}</th><th>{/literal}{$meta.lang['Views']}{literal}</th><th>{/literal}{$meta.lang['Created']}{literal}</th><th>{/literal}{$meta.lang['Actions']}{literal}</th></tr>';
            for (var i = 0; i < pages.length; i++) {
                var p = pages[i];
                html += '<tr>';
                html += '<td><a href="' + editUrl + p.id + '">#' + p.id + '</a></td>';
                html += '<td><a href="' + editUrl + p.id + '">' + escapeHtml(p.name || '(untitled)') + '</a></td>';
                html += '<td><small>' + escapeHtml(p.url || '') + '</small></td>';
                html += '<td>' + statusBadge(p.status) + '</td>';
                html += '<td>' + (p.views || 0) + '</td>';
                html += '<td><small>' + escapeHtml(p.created_at || '') + '</small></td>';
                html += '<td>';
                html += '<a href="' + editUrl + p.id + '" class="btn btn-xs btn-primary" title="{/literal}{$meta.lang['Edit']}{literal}"><i class="fa fa-edit"></i></a> ';
                html += '<button class="btn btn-xs btn-info" onclick="clonePage(' + p.id + ', this)" title="{/literal}{$meta.lang['Clone']}{literal}"><i class="fa fa-clone"></i></button> ';
                html += '<button class="btn btn-xs btn-success" onclick="exportPage(' + p.id + ', this)" title="{/literal}{$meta.lang['Export']}{literal}"><i class="fa fa-download"></i></button> ';
                html += '<button class="btn btn-xs btn-danger" onclick="deletePage(' + p.id + ', \'' + escapeHtml(p.name || '') + '\', this)" title="{/literal}{$meta.lang['Delete']}{literal}"><i class="fa fa-trash"></i></button>';
                html += '</td></tr>';
            }
            html += '</table>';
        }
        html += '</div></div>';
        document.getElementById('pages-table').innerHTML = html;
    }

    window.clonePage = function(id, btn) {
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=clonePage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ id: id }),
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data && response.data.id) {
                    window.location.href = editUrl + response.data.id;
                } else {
                    showNotification(response.error || 'Clone failed', 'error');
                    btnReset(btn);
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.exportPage = function(id, btn) {
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=exportPage&id=' + id,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    var blob = new Blob([JSON.stringify(response.data, null, 2)], { type: 'application/json' });
                    var a = document.createElement('a');
                    a.href = URL.createObjectURL(blob);
                    a.download = 'page_' + id + '_export.json';
                    a.click();
                    showNotification('Page exported', 'success');
                } else {
                    showNotification(response.error || 'Export failed', 'error');
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.deletePage = function(id, name, btn) {
        if (!confirm('{/literal}{$meta.lang['Confirm Delete']}{literal}')) return;
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=deletePage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ id: id }),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showNotification('{/literal}{$meta.lang['Deleted successfully']}{literal}', 'success');
                    loadPages();
                } else {
                    showNotification(response.error || 'Delete failed', 'error');
                    btnReset(btn);
                }
            },
            error: function() { btnReset(btn); }
        });
    };

    window.createNewPage = function(btn) {
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=savePage',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ type: 'type_editor_js', name: '', status: 'draft', publish: 'no' }),
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data && response.data.id) {
                    window.location.href = editUrl + response.data.id;
                } else {
                    showNotification(response.error || 'Failed to create page', 'error');
                    btnReset(btn);
                }
            },
            error: function() {
                showNotification('Failed to create page', 'error');
                btnReset(btn);
            }
        });
    };

    window.importPageFromFile = function(input) {
        if (!input.files || !input.files[0]) return;
        var reader = new FileReader();
        reader.onload = function(e) {
            try {
                var importData = JSON.parse(e.target.result);
            } catch (err) {
                showNotification('Invalid JSON file', 'error');
                return;
            }
            jQuery.ajax({
                url: ajaxUrl + '&ajax=importPage',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(importData),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        showNotification('{/literal}{$meta.lang['Page imported successfully']}{literal}', 'success');
                        loadPages();
                    } else {
                        showNotification(response.error || '{/literal}{$meta.lang['Import failed']}{literal}', 'error');
                    }
                },
                error: function() {
                    showNotification('{/literal}{$meta.lang['Import failed']}{literal}', 'error');
                }
            });
            input.value = '';
        };
        reader.readAsText(input.files[0]);
    };

    window.exportAllPages = function(btn) {
        btnLoading(btn);
        jQuery.ajax({
            url: ajaxUrl + '&ajax=exportAllPages',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                btnReset(btn);
                if (response.success && response.data) {
                    var blob = new Blob([JSON.stringify(response.data, null, 2)], { type: 'application/json' });
                    var a = document.createElement('a');
                    a.href = URL.createObjectURL(blob);
                    a.download = 'all_pages_export.json';
                    a.click();
                    showNotification('{/literal}{$meta.lang['Page exported']}{literal}', 'success');
                } else {
                    showNotification(response.error || '{/literal}{$meta.lang['Export failed']}{literal}', 'error');
                }
            },
            error: function() {
                btnReset(btn);
                showNotification('{/literal}{$meta.lang['Export failed']}{literal}', 'error');
            }
        });
    };

    loadPages();
});
</script>
{/literal}
