<style>
    .puq-pwd-wrap {
        min-height: 60vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
    }
    .puq-pwd-card {
        width: 100%;
        max-width: 420px;
        background: {$pwd_card_bg|default:'#ffffff'};
        border-radius: {$pwd_card_radius|default:'16'}px;
        {if $pwd_box_shadow neq 'no'}box-shadow: 0 10px 40px rgba(0,0,0,0.08);{/if}
        overflow: hidden;
    }
    .puq-pwd-header {
        background: linear-gradient(135deg, {$pwd_gradient_start|default:'#667eea'} 0%, {$pwd_gradient_end|default:'#764ba2'} 100%);
        padding: 35px 30px;
        text-align: center;
    }
    .puq-pwd-header i.header-icon {
        font-size: 2.5rem;
        color: rgba(255,255,255,0.9);
        margin-bottom: 12px;
        display: block;
    }
    .puq-pwd-header h2 {
        color: #fff;
        font-size: 1.3rem;
        font-weight: 600;
        margin: 0;
    }
    .puq-pwd-header p {
        color: rgba(255,255,255,0.7);
        font-size: 0.9rem;
        margin: 8px 0 0;
    }
    .puq-pwd-body {
        padding: 30px;
        color: {$pwd_text_color|default:'#333333'};
    }
    .puq-pwd-error {
        background: {$pwd_error_color|default:'#dc2626'}15;
        color: {$pwd_error_color|default:'#dc2626'};
        border: 1px solid {$pwd_error_color|default:'#dc2626'}40;
        border-radius: 8px;
        padding: 12px 15px;
        margin-bottom: 20px;
        font-size: 0.9rem;
        display: none;
        align-items: center;
        gap: 8px;
    }
    .puq-pwd-input-wrap {
        position: relative;
        margin-bottom: 20px;
    }
    .puq-pwd-input-wrap i {
        position: absolute;
        left: 14px;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
        font-size: 0.9rem;
    }
    .puq-pwd-input {
        width: 100%;
        padding: 14px 14px 14px 42px;
        border: 2px solid #e5e7eb;
        border-radius: 10px;
        font-size: 1rem;
        transition: border-color 0.3s, box-shadow 0.3s;
        outline: none;
        box-sizing: border-box;
        background: {$pwd_card_bg|default:'#ffffff'};
        color: {$pwd_text_color|default:'#333333'};
    }
    .puq-pwd-input:focus {
        border-color: {$pwd_gradient_start|default:'#667eea'};
        box-shadow: 0 0 0 3px {$pwd_gradient_start|default:'#667eea'}26;
    }
    .puq-pwd-input.shake {
        animation: puqShake 0.4s ease;
        border-color: {$pwd_error_color|default:'#dc2626'};
    }
    @keyframes puqShake {
        0%, 100% { transform: translateX(0); }
        20%, 60% { transform: translateX(-6px); }
        40%, 80% { transform: translateX(6px); }
    }
    .puq-pwd-btn {
        width: 100%;
        padding: 14px;
        background: linear-gradient(135deg, {$pwd_gradient_start|default:'#667eea'} 0%, {$pwd_gradient_end|default:'#764ba2'} 100%);
        color: #fff;
        border: none;
        border-radius: 10px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: opacity 0.3s, transform 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }
    .puq-pwd-btn:hover {
        opacity: 0.9;
        transform: translateY(-1px);
    }
    .puq-pwd-btn:active {
        transform: translateY(0);
    }
    .puq-pwd-btn:disabled {
        opacity: 0.7;
        cursor: not-allowed;
        transform: none;
    }
</style>

<div class="puq-pwd-wrap">
    <div class="puq-pwd-card">
        <div class="puq-pwd-header">
            <i class="{$pwd_icon_class|default:'fas fa-shield-alt'} header-icon"></i>
            <h2>{if $page_name neq ''}{$page_name}{else}{$lang['Password Protection']}{/if}</h2>
            <p>{$lang['This page is password protected']|default:'This page is password protected'}</p>
        </div>
        <div class="puq-pwd-body">
            <div class="puq-pwd-error" id="puq-pwd-error">
                <i class="fas fa-exclamation-circle"></i>
                <span id="puq-pwd-error-text">{$lang['Incorrect password. Please try again.']|default:'Incorrect password. Please try again.'}</span>
            </div>
            <form id="puq-pwd-form" onsubmit="return puqSubmitPassword(event)">
                <div class="puq-pwd-input-wrap">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="puq-pwd-input" class="puq-pwd-input"
                           placeholder="{$lang['Enter password']|default:'Enter password'}"
                           required autofocus>
                </div>
                <button type="submit" class="puq-pwd-btn" id="puq-pwd-btn">
                    <i class="fas fa-unlock"></i>
                    <span>{$lang['Unlock Page']|default:'Unlock Page'}</span>
                </button>
            </form>
        </div>
    </div>
</div>

{literal}
<script>
function puqSubmitPassword(e) {
    e.preventDefault();
    var input = document.getElementById('puq-pwd-input');
    var btn = document.getElementById('puq-pwd-btn');
    var errorEl = document.getElementById('puq-pwd-error');
    var password = input.value;
    if (!password) return false;

    errorEl.style.display = 'none';
    input.classList.remove('shake');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

    jQuery.ajax({
        url: window.location.href,
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({ puq_page_password: password }),
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                window.location.reload();
            } else {
                input.classList.add('shake');
                errorEl.style.display = 'flex';
                input.value = '';
                input.focus();
                btn.disabled = false;
                btn.innerHTML = '<i class="fas fa-unlock"></i> <span>{/literal}{$lang['Unlock Page']|default:'Unlock Page'}{literal}</span>';
                setTimeout(function() { input.classList.remove('shake'); }, 400);
            }
        },
        error: function() {
            errorEl.style.display = 'flex';
            btn.disabled = false;
            btn.innerHTML = '<i class="fas fa-unlock"></i> <span>{/literal}{$lang['Unlock Page']|default:'Unlock Page'}{literal}</span>';
        }
    });
    return false;
}
</script>
{/literal}
