<div class="row">
    <div class="col-md-12">
        <h1><i class="fa fa-chart-bar"></i> {$meta.lang['Analytics']}</h1>
    </div>
</div>

<div id="page-content">
    <div class="row" style="margin-top:15px;">
        <div class="col-md-12 text-center" id="main-loading" style="padding:40px 0;">
            <i class="fa fa-spinner fa-spin" style="font-size:32px; color:#999;"></i>
            <p class="text-muted" style="margin-top:10px;">{$meta.lang['Loading data...']}</p>
        </div>
    </div>
    <div id="analytics-counts"></div>
    <div id="analytics-chart"></div>
    <div id="analytics-top-pages"></div>
</div>

<style>
    .dash-stat { text-align: center; padding: 18px 10px; }
    .dash-stat-value { font-size: 32px; font-weight: bold; line-height: 1.1; }
    .dash-stat-label { margin-top: 6px; color: #888; font-size: 13px; }
    .hbar-row { display: flex; align-items: center; margin-bottom: 8px; }
    .hbar-label { width: 100px; min-width: 100px; text-align: right; padding-right: 10px; font-size: 12px; }
    .hbar-track { flex: 1; background: #f5f5f5; border-radius: 3px; height: 22px; overflow: hidden; }
    .hbar-fill { height: 100%; border-radius: 3px; transition: width 0.4s; min-width: 2px; }
    .hbar-value { width: 50px; min-width: 50px; text-align: right; padding-left: 8px; font-size: 12px; font-weight: bold; }
</style>

{literal}
<script>
document.addEventListener('DOMContentLoaded', function() {
    var ajaxUrl = '{/literal}{$meta.admin_module_url}{literal}';

    function escapeHtml(str) {
        if (!str) return '';
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(str));
        return div.innerHTML;
    }

    jQuery.ajax({
        url: ajaxUrl + '&ajax=getAnalytics',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            document.getElementById('main-loading').style.display = 'none';
            if (!response.success || !response.data) {
                if (response.error) showNotification(response.error, 'error');
                return;
            }
            var d = response.data;
            renderCounts(d);
            renderChart(d.views_per_day || []);
            renderTopPages(d.top_pages || []);
        },
        error: function() {
            document.getElementById('main-loading').style.display = 'none';
            showNotification('{/literal}{$meta.lang['Failed to load analytics']}{literal}', 'error');
        }
    });

    function renderCounts(d) {
        var cards = [
            { value: d.total_views || 0, label: '{/literal}{$meta.lang['Total Views']}{literal}', icon: 'fa-eye', color: '#337ab7' },
            { value: d.today || 0, label: '{/literal}{$meta.lang['Today']}{literal}', icon: 'fa-calendar-day', color: '#5cb85c' },
            { value: d.this_week || 0, label: '{/literal}{$meta.lang['This Week']}{literal}', icon: 'fa-calendar-week', color: '#f0ad4e' },
            { value: d.this_month || 0, label: '{/literal}{$meta.lang['This Month']}{literal}', icon: 'fa-calendar-alt', color: '#5bc0de' }
        ];
        var html = '<div class="row" style="margin-top:10px;">';
        for (var i = 0; i < cards.length; i++) {
            var c = cards[i];
            html += '<div class="col-lg-3 col-md-6 col-sm-6">';
            html += '<div class="panel panel-default" style="border-top:3px solid ' + c.color + ';">';
            html += '<div class="dash-stat">';
            html += '<div class="dash-stat-value" style="color:' + c.color + ';">' + c.value + '</div>';
            html += '<div class="dash-stat-label"><i class="fa ' + c.icon + '"></i> ' + c.label + '</div>';
            html += '</div></div></div>';
        }
        html += '</div>';
        document.getElementById('analytics-counts').innerHTML = html;
    }

    function renderChart(viewsPerDay) {
        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-chart-line"></i> {/literal}{$meta.lang['Views per Day']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (viewsPerDay.length === 0) {
            html += '<p class="text-muted text-center" style="padding:20px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        } else {
            var maxViews = 1;
            for (var i = 0; i < viewsPerDay.length; i++) {
                var v = viewsPerDay[i].count || 0;
                if (v > maxViews) maxViews = v;
            }

            for (var i = 0; i < viewsPerDay.length; i++) {
                var day = viewsPerDay[i];
                var count = day.count || 0;
                var pct = (count / maxViews) * 100;
                html += '<div class="hbar-row">';
                html += '<div class="hbar-label">' + escapeHtml(day.date || '') + '</div>';
                html += '<div class="hbar-track"><div class="hbar-fill" style="width:' + pct + '%;background:#337ab7;"></div></div>';
                html += '<div class="hbar-value">' + count + '</div>';
                html += '</div>';
            }
        }

        html += '</div></div></div></div>';
        document.getElementById('analytics-chart').innerHTML = html;
    }

    function renderTopPages(topPages) {
        var html = '<div class="row" style="margin-top:5px;"><div class="col-md-12">';
        html += '<div class="panel panel-default">';
        html += '<div class="panel-heading"><h3 class="panel-title"><i class="fa fa-trophy"></i> {/literal}{$meta.lang['Top Pages']}{literal}</h3></div>';
        html += '<div class="panel-body">';

        if (topPages.length === 0) {
            html += '<p class="text-muted text-center" style="padding:20px 0;">{/literal}{$meta.lang['No data']}{literal}</p>';
        } else {
            html += '<table class="table table-striped table-condensed">';
            html += '<thead><tr><th>{/literal}{$meta.lang['Name']}{literal}</th><th>{/literal}{$meta.lang['URL']}{literal}</th><th>{/literal}{$meta.lang['Total Views']}{literal}</th><th>{/literal}{$meta.lang['Unique Views']}{literal}</th></tr></thead>';
            html += '<tbody>';
            for (var i = 0; i < topPages.length; i++) {
                var p = topPages[i];
                html += '<tr>';
                html += '<td>' + escapeHtml(p.name || '') + '</td>';
                html += '<td><small>' + escapeHtml(p.url || '') + '</small></td>';
                html += '<td><strong>' + (p.total_views || 0) + '</strong></td>';
                html += '<td>' + (p.unique_views || 0) + '</td>';
                html += '</tr>';
            }
            html += '</tbody></table>';
        }

        html += '</div></div></div></div>';
        document.getElementById('analytics-top-pages').innerHTML = html;
    }
});
</script>
{/literal}
