class PUQVideoEmbed {
    static get toolbox() {
        return {
            title: 'Video Embed',
            icon: '<i class="fas fa-video"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            content: {
                b: true,
                bold: true,
                strong: true,
                iframe: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
                em: true,
                del: true,
                blockquote: true,
            }
        };
    }
    render()
    {
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQVideoEmbed');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td class="fieldlabel"><h1 style="color: blue;">Video Embed</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">
        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>
        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Video URL</b></td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="video_url" class="form-control input-inline input-400" value="">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Provider</b></td>
        <td class="fieldarea">
            <select name="provider" class="form-control select-inline">
                <option value="youtube">YouTube</option>
                <option value="vimeo">Vimeo</option>
                <option value="custom">Custom</option>
            </select>
        </td>
        <td class="fieldlabel"><b>Aspect Ratio</b></td>
        <td class="fieldarea">
            <select name="aspect_ratio" class="form-control select-inline">
                <option value="16:9">16:9</option>
                <option value="4:3">4:3</option>
                <option value="1:1">1:1</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Options</b></td>
        <td colspan="3" class="fieldarea">
            <label class="checkbox-inline"><input type="checkbox" name="autoplay"><b>Autoplay</b></label>
            <label class="checkbox-inline"><input type="checkbox" name="muted"><b>Muted</b></label>
            <label class="checkbox-inline"><input type="checkbox" name="loop"><b>Loop</b></label>
            <label class="checkbox-inline"><input type="checkbox" name="controls" checked><b>Controls</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Video Width</b></td>
        <td class="fieldarea">
            <input type="text" name="video_width" class="form-control input-inline input-100" value="">
        </td>
        <td class="fieldlabel"><b>Video Height</b></td>
        <td class="fieldarea">
            <input type="text" name="video_height" class="form-control input-inline input-100" value="">
        </td>
    </tr>

    </tbody>
</table>
`);

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#FFFFFF');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }
        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }
        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }
        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const video_url = this.data && this.data.video_url ? this.data.video_url : "";
        $(render).find("[name='video_url']").val(video_url);

        const provider = this.data && this.data.provider ? this.data.provider : "youtube";
        $(render).find("[name='provider']").val(provider);

        const aspect_ratio = this.data && this.data.aspect_ratio ? this.data.aspect_ratio : "16:9";
        $(render).find("[name='aspect_ratio']").val(aspect_ratio);

        if (this.data.autoplay === true) {
            $(render).find("[name='autoplay']").attr('checked', 'checked');
        }
        if (this.data.muted === true) {
            $(render).find("[name='muted']").attr('checked', 'checked');
        }
        if (this.data.loop === true) {
            $(render).find("[name='loop']").attr('checked', 'checked');
        }
        if (this.data.controls === false) {
            $(render).find("[name='controls']").removeAttr('checked');
        }

        const video_width = this.data && this.data.video_width ? this.data.video_width : "";
        $(render).find("[name='video_width']").val(video_width);

        const video_height = this.data && this.data.video_height ? this.data.video_height : "";
        $(render).find("[name='video_height']").val(video_height);

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";
                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {
        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }
        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }
        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }
        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }
        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }
        var autoplay = false;
        if ($(content).find("[name='autoplay']").is(':checked')) {
            autoplay = true;
        }
        var muted = false;
        if ($(content).find("[name='muted']").is(':checked')) {
            muted = true;
        }
        var loop = false;
        if ($(content).find("[name='loop']").is(':checked')) {
            loop = true;
        }
        var controls = false;
        if ($(content).find("[name='controls']").is(':checked')) {
            controls = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        return {
            "width": $(content).find("[name='width']").val().replace(/\t/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/\t/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/\t/g, ""),
            "style": style.replace(/\t/g, ""),
            "background_image": $(content).find("[name='background_image']").val().replace(/\t/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/\t/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,
            "video_url": $(content).find("[name='video_url']").val().replace(/\t/g, ""),
            "provider": $(content).find("[name='provider']").val(),
            "autoplay": autoplay,
            "muted": muted,
            "loop": loop,
            "controls": controls,
            "video_width": $(content).find("[name='video_width']").val().replace(/\t/g, ""),
            "video_height": $(content).find("[name='video_height']").val().replace(/\t/g, ""),
            "aspect_ratio": $(content).find("[name='aspect_ratio']").val(),
        };
    }
}
