<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-timeline {
        position: relative;
        padding: 20px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-line {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        width: 3px;
        height: 100%;
        top: 0;
        background: {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-item {
        position: relative;
        width: 50%;
        padding: 10px 40px 20px 40px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-item-left {
        left: 0;
        text-align: right;
    }

    .{$name}-{$id} .{$name}-{$id}-item-right {
        left: 50%;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-dot {
        position: absolute;
        width: 16px;
        height: 16px;
        background: {$data['color_4']};
        border-radius: 50%;
        top: 20px;
        border: 3px solid {$data['color_5']};
        box-shadow: 0 0 0 3px {$data['color_4']};
        z-index: 2;
    }

    .{$name}-{$id} .{$name}-{$id}-item-left .{$name}-{$id}-dot {
        right: -8px;
    }

    .{$name}-{$id} .{$name}-{$id}-item-right .{$name}-{$id}-dot {
        left: -8px;
    }

    .{$name}-{$id} .{$name}-{$id}-card {
        background: {$data['color_5']};
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    }

    .{$name}-{$id} .{$name}-{$id}-date {
        font-size: 0.85rem;
        color: {$data['color_3']};
        font-weight: 600;
        margin-bottom: 5px;
    }

    .{$name}-{$id} .{$name}-{$id}-date i {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-title {
        font-size: 1.2rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-desc {
        font-size: 0.95rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-line { left: 20px; }
        .{$name}-{$id} .{$name}-{$id}-item { width: 100%; left: 0; padding-left: 50px; text-align: left; }
        .{$name}-{$id} .{$name}-{$id}-item .{$name}-{$id}-dot { left: 12px; right: auto; }
        .{$name}-{$id} .{$name}-{$id}-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-timeline">
            <div class="{$name}-{$id}-line"></div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-item {if $data['alternate'] && $idx % 2 == 0}{$name}-{$id}-item-left{else}{$name}-{$id}-item-right{/if}">
                    <div class="{$name}-{$id}-dot" {if $item['color'] neq ''}style="background:{$item['color']};box-shadow:0 0 0 3px {$item['color']}"{/if}></div>
                    <div class="{$name}-{$id}-card">
                        {if $item['date'] neq ''}
                            <div class="{$name}-{$id}-date">{if $item['icon'] neq ''}<i class="{$item['icon']}"></i> {/if}{$item['date']}</div>
                        {/if}
                        <div class="{$name}-{$id}-title">{$item['title']}</div>
                        <div class="{$name}-{$id}-desc">{$item['description']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
