<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-grd-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-card {
        background: {$data['color_5']};
        border-radius: 8px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.06);
        position: relative;
        border-top: 3px solid {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-grd-num {
        position: absolute;
        top: -14px;
        right: 16px;
        background: {$data['color_4']};
        color: {$data['color_5']};
        width: 28px;
        height: 28px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.75rem;
        font-weight: 700;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-icon {
        color: {$data['color_6']};
        font-size: 1.4rem;
        margin-bottom: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-date {
        font-size: 0.8rem;
        color: {$data['color_3']};
        font-weight: 600;
        margin-bottom: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-title {
        font-size: 1.1rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-desc {
        font-size: 0.9rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-grd-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-grd-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-grd-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-grd-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-grd-grid">
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-grd-card" {if $item['color'] neq ''}style="border-top-color:{$item['color']}"{/if}>
                    <div class="{$name}-{$id}-grd-num" {if $item['color'] neq ''}style="background:{$item['color']}"{/if}>{$idx+1}</div>
                    {if $item['icon'] neq ''}
                        <div class="{$name}-{$id}-grd-icon"><i class="{$item['icon']}"></i></div>
                    {/if}
                    {if $item['date'] neq ''}
                        <div class="{$name}-{$id}-grd-date">{$item['date']}</div>
                    {/if}
                    <div class="{$name}-{$id}-grd-title">{$item['title']}</div>
                    <div class="{$name}-{$id}-grd-desc">{$item['description']}</div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
