<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-fade-list {
        position: relative;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-item {
        display: flex;
        align-items: stretch;
        margin-bottom: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-item:nth-child(odd) {
        flex-direction: row;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-item:nth-child(even) {
        flex-direction: row-reverse;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-date-side {
        flex: 1;
        display: flex;
        align-items: center;
        padding: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-item:nth-child(odd) .{$name}-{$id}-fade-date-side {
        justify-content: flex-end;
        text-align: right;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-item:nth-child(even) .{$name}-{$id}-fade-date-side {
        justify-content: flex-start;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-date-text {
        font-size: 1rem;
        font-weight: 700;
        color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-fade-center {
        flex: 0 0 60px;
        display: flex;
        flex-direction: column;
        align-items: center;
        position: relative;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-center-line {
        width: 2px;
        flex: 1;
        background: {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-fade-center-icon {
        width: 44px;
        height: 44px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
        color: {$data['color_5']};
        z-index: 2;
        flex-shrink: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-content-side {
        flex: 1;
        padding: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card {
        background: linear-gradient(135deg, {$data['color_5']} 0%, {$data['color_4']}10 100%);
        border-radius: 12px;
        padding: 20px;
        transition: background 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card:hover {
        background: linear-gradient(135deg, {$data['color_4']}10 0%, {$data['color_5']} 100%);
    }

    .{$name}-{$id} .{$name}-{$id}-fade-title {
        font-size: 1.15rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-desc {
        font-size: 0.9rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-fade-item,
        .{$name}-{$id} .{$name}-{$id}-fade-item:nth-child(odd),
        .{$name}-{$id} .{$name}-{$id}-fade-item:nth-child(even) {
            flex-direction: row;
        }
        .{$name}-{$id} .{$name}-{$id}-fade-date-side { display: none; }
        .{$name}-{$id} .{$name}-{$id}-fade-center { flex: 0 0 44px; }
        .{$name}-{$id} .{$name}-{$id}-fade-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-fade-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-fade-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-fade-list">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-fade-item">
                    <div class="{$name}-{$id}-fade-date-side">
                        <div class="{$name}-{$id}-fade-date-text">{$item['date']}</div>
                    </div>
                    <div class="{$name}-{$id}-fade-center">
                        <div class="{$name}-{$id}-fade-center-line"></div>
                        <div class="{$name}-{$id}-fade-center-icon" style="background:{if $item['color'] neq ''}{$item['color']}{else}{$data['color_6']}{/if};">
                            {if $item['icon'] neq ''}<i class="{$item['icon']}"></i>{else}<i class="fas fa-circle" style="font-size:8px"></i>{/if}
                        </div>
                        <div class="{$name}-{$id}-fade-center-line"></div>
                    </div>
                    <div class="{$name}-{$id}-fade-content-side">
                        <div class="{$name}-{$id}-fade-card">
                            <div class="{$name}-{$id}-fade-title">{$item['title']}</div>
                            <div class="{$name}-{$id}-fade-desc">{$item['description']}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
