<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-circ-timeline {
        position: relative;
        padding: 20px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-line {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        width: 2px;
        height: 100%;
        top: 0;
        background: {$data['color_4']}44;
        border-style: dashed;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-item {
        position: relative;
        width: 50%;
        padding: 10px 50px 20px 50px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-item-left {
        left: 0;
        text-align: right;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-item-right {
        left: 50%;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-dot {
        position: absolute;
        width: 48px;
        height: 48px;
        border-radius: 50%;
        top: 10px;
        z-index: 2;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        color: {$data['color_5']};
        border: 3px solid {$data['color_5']};
        box-shadow: 0 2px 10px rgba(0,0,0,0.15);
    }

    .{$name}-{$id} .{$name}-{$id}-circ-item-left .{$name}-{$id}-circ-dot {
        right: -24px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-item-right .{$name}-{$id}-circ-dot {
        left: -24px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-date {
        font-size: 0.8rem;
        color: {$data['color_3']};
        font-weight: 700;
        margin-bottom: 4px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-title {
        font-size: 1.1rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-desc {
        font-size: 0.9rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-circ-line { left: 24px; }
        .{$name}-{$id} .{$name}-{$id}-circ-item { width: 100%; left: 0; padding-left: 64px; text-align: left; }
        .{$name}-{$id} .{$name}-{$id}-circ-item .{$name}-{$id}-circ-dot { left: 0; right: auto; }
        .{$name}-{$id} .{$name}-{$id}-circ-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-circ-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-circ-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-circ-timeline">
            <div class="{$name}-{$id}-circ-line"></div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-circ-item {if $data['alternate'] && $idx % 2 == 0}{$name}-{$id}-circ-item-left{else}{$name}-{$id}-circ-item-right{/if}">
                    <div class="{$name}-{$id}-circ-dot" style="background:{if $item['color'] neq ''}{$item['color']}{else}{$data['color_6']}{/if};">
                        {if $item['icon'] neq ''}<i class="{$item['icon']}"></i>{else}{$idx+1}{/if}
                    </div>
                    {if $item['date'] neq ''}
                        <div class="{$name}-{$id}-circ-date">{$item['date']}</div>
                    {/if}
                    <div class="{$name}-{$id}-circ-title">{$item['title']}</div>
                    <div class="{$name}-{$id}-circ-desc">{$item['description']}</div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
