<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-cards-timeline {
        position: relative;
        padding: 20px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-line {
        position: absolute;
        left: 50%;
        transform: translateX(-50%);
        width: 4px;
        height: 100%;
        top: 0;
        background: linear-gradient(to bottom, {$data['color_4']}, {$data['color_6']});
        border-radius: 2px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-item {
        position: relative;
        width: 50%;
        padding: 10px 40px 20px 40px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-item-left {
        left: 0;
        text-align: right;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-item-right {
        left: 50%;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-dot {
        position: absolute;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        top: 14px;
        z-index: 2;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        color: {$data['color_5']};
        box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-item-left .{$name}-{$id}-cards-dot {
        right: -20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-item-right .{$name}-{$id}-cards-dot {
        left: -20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card {
        background: {$data['color_5']};
        border-radius: 16px;
        padding: 24px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-date {
        font-size: 0.8rem;
        color: {$data['color_3']};
        font-weight: 700;
        margin-bottom: 6px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-title {
        font-size: 1.15rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin-bottom: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-desc {
        font-size: 0.9rem;
        color: {$data['color_2']};
        line-height: 1.6;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-cards-line { left: 20px; }
        .{$name}-{$id} .{$name}-{$id}-cards-item { width: 100%; left: 0; padding-left: 60px; text-align: left; }
        .{$name}-{$id} .{$name}-{$id}-cards-item .{$name}-{$id}-cards-dot { left: 0; right: auto; }
        .{$name}-{$id} .{$name}-{$id}-cards-header { font-size: 1.4rem; }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-cards-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-cards-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-cards-timeline">
            <div class="{$name}-{$id}-cards-line"></div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-cards-item {if $data['alternate'] && $idx % 2 == 0}{$name}-{$id}-cards-item-left{else}{$name}-{$id}-cards-item-right{/if}">
                    <div class="{$name}-{$id}-cards-dot" style="background:{if $item['color'] neq ''}{$item['color']}{else}{$data['color_4']}{/if};">
                        {if $item['icon'] neq ''}<i class="{$item['icon']}"></i>{/if}
                    </div>
                    <div class="{$name}-{$id}-cards-card">
                        {if $item['date'] neq ''}
                            <div class="{$name}-{$id}-cards-date">{$item['date']}</div>
                        {/if}
                        <div class="{$name}-{$id}-cards-title">{$item['title']}</div>
                        <div class="{$name}-{$id}-cards-desc">{$item['description']}</div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
