class PUQTimeline {
    static get toolbox() {
        return {
            title: 'Timeline',
            icon: '<i class="fas fa-stream"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQTimeline');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td  class="fieldlabel"><h1 style="color: blue;">Timeline</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Settings</b></td>
        <td colspan="3" class="fieldarea">
            <label for="layout">Layout: </label>
            <select name="layout" class="form-control select-inline">
                <option value="vertical">Vertical</option>
                <option value="horizontal">Horizontal</option>
            </select>
            <label class="checkbox-inline"><input type="checkbox" name="alternate"><b>Alternate sides</b></label>
        </td>
    </tr>

     <tr>
        <td class="fieldlabel"><b>Color</b></td>
        <td colspan="3" class="fieldarea">

            <label for="color_1">Title:</label>
            <input type="color" name="color_1" class="form-control input-inline input-50">

            <label for="color_2">Description:</label>
            <input type="color" name="color_2" class="form-control input-inline input-50">

            <label for="color_3">Date:</label>
            <input type="color" name="color_3" class="form-control input-inline input-50">
            <br>
            <label for="color_4">Line/Dot:</label>
            <input type="color" name="color_4" class="form-control input-inline input-50">

            <label for="color_5">Card background:</label>
            <input type="color" name="color_5" class="form-control input-inline input-50">

            <label for="color_6">Icon/Accent:</label>
            <input type="color" name="color_6" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">

        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

       <tr>
        <td class="fieldlabel"><b>Header</b><br>e.g. (Our History)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="header" value="" class="form-control input-inline input-200">
            <label for="header_text_color">Text color:</label>
            <input type="color" name="header_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_header"><b>Disable header</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><a type="button" name="add-row"><div style="font-size: 24px;" class="fa fa-plus"></div></a></td>
        <td colspan="3" class="fieldarea">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"></td>
        <td colspan="3" class="fieldarea">
            <table name="TimelineTable" class="datatable" style="width: 100%;">
                <thead>
                <tr>
                    <th class="text-center" style="width: 250px;"><b>Date/Icon/Color</b></th>
                    <th class="text-center"><b>Title/Description</b></th>
                    <th class="text-center"></th>
                    <th class="text-center"></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </td>
    </tr>

    </tbody>
</table>
`);
        const table = render.querySelector("[name='TimelineTable']");
        const addRowButton = render.querySelector("[name='add-row']");

        var items = this.data && this.data.items ? this.data.items : "";
        if (typeof items === 'string' && items !== '') {
            try { items = JSON.parse(items); } catch(e) { items = {}; }
        }
        if (Array.isArray(items)) {
            var obj = {};
            items.forEach(function(item, i) { obj[i] = item; });
            items = obj;
        }
        if (!items || typeof items !== 'object') { items = {}; }

        const tbody = table.querySelector("tbody");
        Object.entries(items).forEach(([key, value]) => {
            const row = document.createElement("tr");
            var decodedDesc = '';
            try { decodedDesc = decodeURIComponent(atob(value.description || '')); } catch(e) { decodedDesc = value.description || ''; }

            row.innerHTML = `
                <td class="text-left" style="width: 250px;">
                    <label for="date">Date: </label>
                    <input type="text" name="date" value="${(value.date || '').replace(/"/g, '&quot;')}" class="form-control input-inline input-200"><br>

                    <label for="icon">Icon: </label>
                    <input type="text" name="icon" value="${(value.icon || '').replace(/"/g, '&quot;')}" class="form-control input-inline input-200" placeholder="fas fa-star"><br>

                    <label for="color">Color: </label>
                    <input type="color" name="color" value="${value.color || '#6420c0'}" class="form-control input-inline input-50">
                </td>

                <td class="text-left">
                    <label for="title">Title: </label>
                    <input type="text" name="title" value="${(value.title || '').replace(/"/g, '&quot;')}" class="form-control input-inline" style="width: 100%;"><br>

                    <label for="description">Description: </label>
                    <textarea name="description" rows="3" class="form-control" style="width: 100%; resize: none;">${decodedDesc}</textarea>
                </td>

                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
            `;
            tbody.appendChild(row);
            addRowListeners(row);
        });

        function addRow() {
            const tbody = table.querySelector("tbody");
            const row = document.createElement("tr");
            row.innerHTML = `
                <td class="text-left" style="width: 250px;">
                    <label for="date">Date: </label>
                    <input type="text" name="date" value="" class="form-control input-inline input-200"><br>

                    <label for="icon">Icon: </label>
                    <input type="text" name="icon" value="" class="form-control input-inline input-200" placeholder="fas fa-star"><br>

                    <label for="color">Color: </label>
                    <input type="color" name="color" value="#6420c0" class="form-control input-inline input-50">
                </td>

                <td class="text-left">
                    <label for="title">Title: </label>
                    <input type="text" name="title" value="" class="form-control input-inline" style="width: 100%;"><br>

                    <label for="description">Description: </label>
                    <textarea name="description" rows="3" class="form-control" style="width: 100%; resize: none;"></textarea>
                </td>

                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
  `;
            tbody.appendChild(row);
            addRowListeners(row);
        }

        function removeRow(row) {
            row.remove();
        }

        function moveRow(row, direction) {
            const tbody = row.parentNode;
            const rows = Array.from(tbody.children);
            const index = rows.indexOf(row);
            const newIndex = index + direction;

            if (newIndex >= 0 && newIndex < rows.length) {
                const siblingRow = rows[newIndex];
                if (direction === 1) {
                    tbody.insertBefore(row, siblingRow.nextSibling);
                } else {
                    tbody.insertBefore(row, siblingRow);
                }
            } else if (newIndex === -1) {
                tbody.insertBefore(row, rows[0]);
            } else if (newIndex === rows.length) {
                tbody.insertBefore(row, null);
            }
        }

        function addRowListeners(row) {
            const removeButton = row.querySelector("[name='remove-row']");
            const moveUpButton = row.querySelector("[name='move-up']");
            const moveDownButton = row.querySelector("[name='move-down']");

            removeButton.addEventListener("click", () => {
                removeRow(row);
            });

            moveUpButton.addEventListener("click", () => {
                moveRow(row, -1);
            });

            moveDownButton.addEventListener("click", () => {
                moveRow(row, 1);
            });
        }

        addRowButton.addEventListener("click", () => {
            addRow();
        });

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const layout = this.data && this.data.layout ? this.data.layout : "";
        $(render).find("[name='layout']").val(layout);
        if (layout === '') {
            $(render).find("[name='layout']").val('vertical');
        }

        if (this.data.alternate === true) {
            $(render).find("[name='alternate']").attr('checked', 'checked');
        }

        const color_1 = this.data && this.data.color_1 ? this.data.color_1 : "";
        $(render).find("[name='color_1']").val(color_1);
        if (color_1 === '') {
            $(render).find("[name='color_1']").val('#333333');
        }

        const color_2 = this.data && this.data.color_2 ? this.data.color_2 : "";
        $(render).find("[name='color_2']").val(color_2);
        if (color_2 === '') {
            $(render).find("[name='color_2']").val('#666666');
        }

        const color_3 = this.data && this.data.color_3 ? this.data.color_3 : "";
        $(render).find("[name='color_3']").val(color_3);
        if (color_3 === '') {
            $(render).find("[name='color_3']").val('#6420c0');
        }

        const color_4 = this.data && this.data.color_4 ? this.data.color_4 : "";
        $(render).find("[name='color_4']").val(color_4);
        if (color_4 === '') {
            $(render).find("[name='color_4']").val('#6420c0');
        }

        const color_5 = this.data && this.data.color_5 ? this.data.color_5 : "";
        $(render).find("[name='color_5']").val(color_5);
        if (color_5 === '') {
            $(render).find("[name='color_5']").val('#ffffff');
        }

        const color_6 = this.data && this.data.color_6 ? this.data.color_6 : "";
        $(render).find("[name='color_6']").val(color_6);
        if (color_6 === '') {
            $(render).find("[name='color_6']").val('#6420c0');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#ffffff');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }

        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }

        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const header = this.data && this.data.header ? this.data.header : "";
        $(render).find("[name='header']").val(header);
        if (header === '') {
            $(render).find("[name='header']").val('Our History');
        }

        const header_text_color = this.data && this.data.header_text_color ? this.data.header_text_color : "";
        $(render).find("[name='header_text_color']").val(header_text_color);
        if (header_text_color === '') {
            $(render).find("[name='header_text_color']").val('#333333');
        }

        if (this.data.disable_header === true) {
            $(render).find("[name='disable_header']").attr('checked', 'checked');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {

        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }

        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }

        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }

        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }

        var disable_header = false;
        if ($(content).find("[name='disable_header']").is(':checked')) {
            disable_header = true;
        }

        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }

        var alternate = false;
        if ($(content).find("[name='alternate']").is(':checked')) {
            alternate = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        const table = content.querySelector("[name='TimelineTable']")
        const rows = table.querySelectorAll('tbody tr');
        const data = {};
        rows.forEach((row, index) => {
            const inputs = row.querySelectorAll('input');
            const textareas = row.querySelectorAll('textarea');

            const values = {};
            inputs.forEach(input => {
                const name = input.getAttribute('name');
                if (name === 'date' || name === 'title' || name === 'icon' || name === 'color') {
                    values[name] = input.value;
                }
            });

            textareas.forEach(textarea => {
                const name = textarea.getAttribute('name');
                if (name === 'description') {
                    values[name] = btoa(encodeURIComponent(textarea.value));
                }
            });

            if (Object.keys(values).length > 0) {
                data[index] = values;
            }
        });

        return {
            "width": $(content).find("[name='width']").val().replace(/\t/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/\t/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/\t/g, ""),
            "style": style.replace(/\t/g, ""),

            "layout": $(content).find("[name='layout']").val().replace(/\t/g, ""),
            "alternate": alternate,

            "color_1": $(content).find("[name='color_1']").val().replace(/\t/g, ""),
            "color_2": $(content).find("[name='color_2']").val().replace(/\t/g, ""),
            "color_3": $(content).find("[name='color_3']").val().replace(/\t/g, ""),
            "color_4": $(content).find("[name='color_4']").val().replace(/\t/g, ""),
            "color_5": $(content).find("[name='color_5']").val().replace(/\t/g, ""),
            "color_6": $(content).find("[name='color_6']").val().replace(/\t/g, ""),

            "background_image": $(content).find("[name='background_image']").val().replace(/\t/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/\t/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,

            "header": $(content).find("[name='header']").val().replace(/\t/g, ""),
            "header_text_color": $(content).find("[name='header_text_color']").val().replace(/\t/g, ""),
            "disable_header": disable_header,

            "items": data
        };
    }
}
