<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-card {
        background: {$data['color_5']};
        border-radius: 12px;
        padding: 24px;
        position: relative;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        cursor: pointer;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-summary {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-photo {
        width: 56px;
        height: 56px;
        border-radius: 50%;
        object-fit: cover;
        flex-shrink: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-info {
        flex: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 0.95rem;
        margin: 0 0 2px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-stars i {
        color: {$data['color_4']};
        font-size: 0.75rem;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-popup {
        position: absolute;
        bottom: calc(100% + 12px);
        left: 50%;
        transform: translateX(-50%) translateY(8px);
        background: {$data['color_5']};
        color: {$data['color_3']};
        border: 1px solid {$data['color_6']};
        border-radius: 10px;
        padding: 16px 18px;
        width: 280px;
        font-size: 0.85rem;
        line-height: 1.6;
        box-shadow: 0 8px 24px rgba(0,0,0,0.15);
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease, transform 0.3s ease;
        z-index: 10;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-popup::after {
        content: '';
        position: absolute;
        top: 100%;
        left: 50%;
        transform: translateX(-50%);
        border: 8px solid transparent;
        border-top-color: {$data['color_5']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-card:hover .{$name}-{$id}-tip-popup {
        opacity: 1;
        pointer-events: auto;
        transform: translateX(-50%) translateY(0);
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-tip-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-tip-popup {
            width: 220px;
        }
        .{$name}-{$id} .{$name}-{$id}-tip-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-tip-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-tip-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-tip-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-tip-card">
                    <div class="{$name}-{$id}-tip-popup">{$item['text']}</div>
                    <div class="{$name}-{$id}-tip-summary">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-tip-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div class="{$name}-{$id}-tip-info">
                            <h4 class="{$name}-{$id}-tip-name">{$item['name']}</h4>
                            <p class="{$name}-{$id}-tip-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</p>
                            {if $data['show_rating'] && $item['rating']}
                                <div class="{$name}-{$id}-tip-stars">
                                    {for $s=1 to 5}
                                        <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                                    {/for}
                                </div>
                            {/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
