<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-rib-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-card {
        background: {$data['color_5']};
        border-radius: 12px;
        padding: 28px;
        position: relative;
        overflow: visible;
        box-shadow: 0 2px 12px rgba(0,0,0,0.06);
    }

    .{$name}-{$id} .{$name}-{$id}-rib-ribbon {
        position: absolute;
        top: 16px;
        left: -8px;
        background: {$data['color_6']};
        color: {$data['color_5']};
        padding: 4px 16px 4px 12px;
        font-size: 0.75rem;
        font-weight: 700;
        clip-path: polygon(0 0, 100% 0, 92% 100%, 0 100%);
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-stars {
        margin-bottom: 12px;
        margin-top: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-stars i {
        color: {$data['color_4']};
        font-size: 0.9rem;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-stars i.empty {
        color: {$data['color_6']}44;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        margin-bottom: 18px;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-author {
        display: flex;
        align-items: center;
        gap: 12px;
        border-top: 1px solid {$data['color_6']}33;
        padding-top: 14px;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-photo {
        width: 46px;
        height: 46px;
        border-radius: 8px;
        object-fit: cover;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 0.95rem;
    }

    .{$name}-{$id} .{$name}-{$id}-rib-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-rib-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-rib-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-rib-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-rib-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-rib-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-rib-card">
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-rib-ribbon">{$item['rating']}/5</div>
                    {/if}
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-rib-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-rib-quote">{$item['text']}</div>
                    <div class="{$name}-{$id}-rib-author">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-rib-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div>
                            <div class="{$name}-{$id}-rib-name">{$item['name']}</div>
                            <div class="{$name}-{$id}-rib-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
