<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-grd-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 4px;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-card {
        background: {$data['color_5']};
        padding: 32px 24px;
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-card::before {
        content: "\201C";
        position: absolute;
        top: -10px;
        right: 10px;
        font-size: 8rem;
        color: {$data['color_6']}22;
        line-height: 1;
        pointer-events: none;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-stars {
        margin-bottom: 12px;
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-stars i {
        color: {$data['color_4']};
        font-size: 0.85rem;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-grd-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        margin-bottom: 20px;
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-author {
        display: flex;
        align-items: center;
        gap: 10px;
        position: relative;
        z-index: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-photo {
        width: 42px;
        height: 42px;
        border-radius: 4px;
        object-fit: cover;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 0.9rem;
    }

    .{$name}-{$id} .{$name}-{$id}-grd-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-grd-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-grd-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-grd-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-grd-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-grd-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-grd-card">
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-grd-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-grd-quote">{$item['text']}</div>
                    <div class="{$name}-{$id}-grd-author">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-grd-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div>
                            <div class="{$name}-{$id}-grd-name">{$item['name']}</div>
                            <div class="{$name}-{$id}-grd-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
