<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-circ-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 32px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-card {
        background: {$data['color_5']};
        border-radius: 16px;
        padding: 40px 28px 28px 28px;
        text-align: center;
        position: relative;
        margin-top: 50px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.06);
    }

    .{$name}-{$id} .{$name}-{$id}-circ-photo {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        object-fit: cover;
        border: 4px solid {$data['color_6']};
        position: absolute;
        top: -50px;
        left: 50%;
        transform: translateX(-50%);
        background: {$data['color_5']};
    }

    .{$name}-{$id} .{$name}-{$id}-circ-no-photo {
        height: 50px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-stars {
        margin-bottom: 12px;
        margin-top: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-stars i {
        color: {$data['color_4']};
        font-size: 0.9rem;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-circ-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        margin-bottom: 16px;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 1.05rem;
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-circ-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-circ-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-circ-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-circ-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-circ-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-circ-card">
                    {if $item['photo_url'] neq ''}
                        <img class="{$name}-{$id}-circ-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                    {else}
                        <div class="{$name}-{$id}-circ-no-photo"></div>
                    {/if}
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-circ-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-circ-quote">{$item['text']}</div>
                    <h4 class="{$name}-{$id}-circ-name">{$item['name']}</h4>
                    <p class="{$name}-{$id}-circ-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</p>
                </div>
            {/foreach}
        </div>
    </div>
</div>
