<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-brd-grid {
        display: grid;
        grid-template-columns: repeat({if $data['columns'] neq ''}{$data['columns']}{else}3{/if}, 1fr);
        gap: 24px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-card {
        background: {$data['color_5']};
        border-left: 4px solid {$data['color_6']};
        padding: 24px 24px 24px 28px;
        box-shadow: 0 1px 8px rgba(0,0,0,0.05);
        transition: border-color 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-card:hover {
        border-left-color: {$data['color_4']};
    }

    .{$name}-{$id} .{$name}-{$id}-brd-stars {
        margin-bottom: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-stars i {
        color: {$data['color_4']};
        font-size: 0.85rem;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-stars i.empty {
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-brd-quote {
        font-size: 0.95rem;
        color: {$data['color_3']};
        line-height: 1.7;
        margin-bottom: 18px;
        font-style: italic;
        border-left: none;
        padding-left: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-author {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-photo {
        width: 44px;
        height: 44px;
        border-radius: 6px;
        object-fit: cover;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-name {
        font-weight: 700;
        color: {$data['color_1']};
        font-size: 0.95rem;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-role {
        font-size: 0.8rem;
        color: {$data['color_2']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-brd-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-brd-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-brd-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-brd-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-brd-grid">
            {foreach $data['items'] as $item}
                <div class="{$name}-{$id}-brd-card">
                    {if $data['show_rating'] && $item['rating']}
                        <div class="{$name}-{$id}-brd-stars">
                            {for $s=1 to 5}
                                <i class="fa fa-star {if $s > $item['rating']}empty{/if}"></i>
                            {/for}
                        </div>
                    {/if}
                    <div class="{$name}-{$id}-brd-quote">{$item['text']}</div>
                    <div class="{$name}-{$id}-brd-author">
                        {if $item['photo_url'] neq ''}
                            <img class="{$name}-{$id}-brd-photo" src="{$item['photo_url']}" alt="{$item['name']}">
                        {/if}
                        <div>
                            <div class="{$name}-{$id}-brd-name">{$item['name']}</div>
                            <div class="{$name}-{$id}-brd-role">{$item['role']}{if $item['company'] neq ''}, {$item['company']}{/if}</div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
