<style>
    .{$name}-{$id} .{$name}-{$id}-container {
                       position: relative;
                       z-index: 2;
                       display: inline-block;
                       width: 100%;
                       text-align: center;
                   {if $data['width'] neq ''}
                       max-width: {$data['width']};
                   {/if}
                   }

    .{$name}-{$id} .{$name}-{$id}-container-members {
                       position: relative;
                       z-index: 2;
                       display: flex;
                       flex-wrap: wrap;
                       justify-content: center;
                       align-items: flex-start;
                       padding-left: 5px;
                       padding-right: 5px;
                   {if $data['width'] neq ''}
                       width: {$data['width']};
                   {else}
                       width: 100%;
                   {/if}
                   }

    .{$name}-{$id} .{$name}-{$id}-header {
                       text-align: center;
                       font-size: 2rem;
                       font-weight: bold;
                       text-transform: uppercase;
                       letter-spacing: 2px;
                       color: {$data['header_text_color']};
                   }

    .{$name}-{$id} .{$name}-{$id}-member {
                       position: relative;
                       width: 275px;
                       margin: 5px;
                       background-color: {$data['color_6']};
                       border-radius: 5px;
                       box-shadow: 0 0 10px 0 rgba(0, 0, 0, 0.2);
                   }

    .{$name}-{$id} .{$name}-{$id}-member-img {
                       width: 100%;
                       height: auto;
                       border-radius: 5px 5px 0 0;
                   }

    .{$name}-{$id} .{$name}-{$id}-member-details {
                       padding: 5px;
                       text-align: center;
                   }

    .{$name}-{$id} .{$name}-{$id}-member-details-header {
                       margin-bottom: 10px;
                   }

    .{$name}-{$id} .{$name}-{$id}-member-details-header h4 {
                       font-size: 24px;
                       margin: 0;
                       color: {$data['color_1']};
                   }

    .{$name}-{$id} .{$name}-{$id}-member-details-header span {
                       font-size: 18px;
                       color: {$data['color_2']};
                   }


    .{$name}-{$id} .{$name}-{$id}-member:hover .{$name}-{$id}-member-card-detail{
                       animation: {$name}-{$id}-slide-up 0.6s forwards;
                       position: absolute;
                       width: 100%;
                       display: block;
                       transform: translateY(calc(-100% - 10px));
                       left: 0;
                       height: calc(100% - 50px);
                   }

    .{$name}-{$id} .{$name}-{$id}-member-card-detail {
                       border-radius: 5px 5px 0 0;
                       margin-top: 5px;
                       font-size: 16px;
                       color: {$data['color_5']};
                       display: none;
                       position: absolute;
                       padding: 15px;
                       box-sizing: border-box;
                       transition: bottom 0.8s ease;
                       background-image: linear-gradient(to bottom, {$data['color_6']}, rgba(255,255,255,0) 80%);
                       backdrop-filter: blur(5px);
                   }

    .{$name}-{$id} .{$name}-{$id}-member-social {
                       margin-top: 5px;
                       height: 40px;
                   }

    .{$name}-{$id} .{$name}-{$id}-member-social ul {
                       display: flex;
                       justify-content: center;
                       align-items: center;
                       list-style-type: none;
                       margin: 0;
                       padding: 0;
                   }

    .{$name}-{$id} .{$name}-{$id}-member-social ul li {
                       margin: 0 5px;
                   }

    .{$name}-{$id} .{$name}-{$id}-member-social ul li a {
                       display: block;
                       width: 40px;
                       height: 40px;
                       border-radius: 50%;
                       color: {$data['color_4']};
                       background-color: {$data['color_3']};
                       text-align: center;
                       line-height: 40px;
                       font-size: 18px;
                   }

    .{$name}-{$id} .{$name}-{$id}-member-social ul li a:hover {
                       background-color: {$data['color_4']};
                       color: {$data['color_3']};
                   }

    @keyframes {$name}-{$id}-slide-up {
        0% {
            transform: translateY(calc(-160% - 100px));
        }
        10% {
            transform: translateY(calc(-90% - 10px));
        }
        1000% {
            transform: translateY(calc(-100% - 10px));
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    {if !$data['disable_header']}
        <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
    {/if}
    <div class="{$name}-{$id}-container">

        <div class="{$name}-{$id}-container-members">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-member">
                    <img class="{$name}-{$id}-member-img" alt="{$member['member_name']}" src="{$member['member_img']}">
                    <div class="{$name}-{$id}-member-details">

                        <div class="{$name}-{$id}-member-details-header">
                            <h4>{$member['member_name']}</h4>
                            <span>{$member['member_position']}</span>
                        </div>

                        <div class="{$name}-{$id}-member-card-detail">
                            {$member['member_bio']}
                        </div>

                        <div class="{$name}-{$id}-member-social">
                            <ul>
                                {if {$member['member_www']} }
                                    <li><a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe icon-only"></i></a></li>
                                {/if}
                                {if {$member['member_linkedin']} }
                                    <li><a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin icon-only"></i></a></li>
                                {/if}
                                {if {$member['member_facebook']} }
                                    <li><a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook icon-only"></i></a></li>
                                {/if}
                                {if {$member['member_twitter']} }
                                    <li><a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter icon-only"></i></a></li>
                                {/if}
                                {if {$member['member_instagram']} }
                                    <li><a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram icon-only"></i></a></li>
                                {/if}
                                {if {$member['member_github']} }
                                    <li><a href="{$member['member_github']}" target="_blank"><i class="fab fa-github icon-only"></i></a></li>
                                {/if}
                            </ul>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>