<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-grid {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 32px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-member {
        position: relative;
        text-align: center;
        width: 180px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-avatar {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        object-fit: cover;
        margin: 0 auto 12px auto;
        display: block;
        border: 3px solid {$data['color_6']};
        transition: border-color 0.3s ease;
        cursor: pointer;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-member:hover .{$name}-{$id}-tip-avatar {
        border-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-name {
        font-size: 1rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 2px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-position {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0 0 8px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-social {
        display: flex;
        justify-content: center;
        gap: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 28px;
        height: 28px;
        border-radius: 50%;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 12px;
        transition: background 0.2s, color 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-social a:hover {
        background: {$data['color_4']};
        color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-popup {
        position: absolute;
        bottom: calc(100% + 12px);
        left: 50%;
        transform: translateX(-50%) translateY(8px);
        background: {$data['color_6']};
        color: {$data['color_5']};
        border: 1px solid {$data['color_3']};
        border-radius: 10px;
        padding: 14px 16px;
        width: 240px;
        font-size: 0.8rem;
        line-height: 1.5;
        box-shadow: 0 8px 24px rgba(0,0,0,0.15);
        opacity: 0;
        pointer-events: none;
        transition: opacity 0.3s ease, transform 0.3s ease;
        z-index: 10;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-tip-popup::after {
        content: '';
        position: absolute;
        top: 100%;
        left: 50%;
        transform: translateX(-50%);
        border: 8px solid transparent;
        border-top-color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-tip-member:hover .{$name}-{$id}-tip-popup {
        opacity: 1;
        pointer-events: auto;
        transform: translateX(-50%) translateY(0);
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-tip-grid {
            gap: 20px;
        }
        .{$name}-{$id} .{$name}-{$id}-tip-member {
            width: 140px;
        }
        .{$name}-{$id} .{$name}-{$id}-tip-avatar {
            width: 90px;
            height: 90px;
        }
        .{$name}-{$id} .{$name}-{$id}-tip-popup {
            width: 200px;
        }
        .{$name}-{$id} .{$name}-{$id}-tip-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-tip-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-tip-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-tip-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-tip-member">
                    {if $member['member_bio']}
                        <div class="{$name}-{$id}-tip-popup">{$member['member_bio']}</div>
                    {/if}
                    <img class="{$name}-{$id}-tip-avatar" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <h4 class="{$name}-{$id}-tip-name">{$member['member_name']}</h4>
                    <p class="{$name}-{$id}-tip-position">{$member['member_position']}</p>
                    <div class="{$name}-{$id}-tip-social">
                        {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                        {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                        {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                        {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                        {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                        {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
