<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-header {
        text-align: center;
        font-size: 2rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 3px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
        text-shadow: 0 0 10px {$data['color_3']}40, 0 0 20px {$data['color_3']}20;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
        gap: 20px;
        justify-items: center;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-card {
        background: {$data['color_6']};
        border: 1px solid {$data['color_3']};
        border-radius: 12px;
        overflow: hidden;
        width: 100%;
        max-width: 300px;
        transition: box-shadow 0.35s ease;
        box-shadow: 0 0 0 0 transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-card:hover {
        box-shadow: 0 0 12px {$data['color_3']}60, 0 0 24px {$data['color_3']}30;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-img-wrap {
        position: relative;
        overflow: hidden;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-img {
        width: 100%;
        height: 260px;
        object-fit: cover;
        display: block;
        transition: filter 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-card:hover .{$name}-{$id}-neon-img {
        filter: brightness(0.7);
    }

    .{$name}-{$id} .{$name}-{$id}-neon-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 16px;
        background: linear-gradient(transparent, {$data['color_6']}ee);
        transform: translateY(100%);
        transition: transform 0.35s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-card:hover .{$name}-{$id}-neon-overlay {
        transform: translateY(0);
    }

    .{$name}-{$id} .{$name}-{$id}-neon-overlay-bio {
        font-size: 0.8rem;
        color: {$data['color_5']};
        line-height: 1.5;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-body {
        padding: 16px;
        text-align: center;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-name {
        font-size: 1.1rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-position {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0 0 12px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-social {
        display: flex;
        justify-content: center;
        gap: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 34px;
        height: 34px;
        border-radius: 50%;
        border: 1px solid {$data['color_3']};
        background: transparent;
        color: {$data['color_3']};
        font-size: 14px;
        transition: all 0.3s ease;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-social a:hover {
        background: {$data['color_3']};
        color: {$data['color_4']};
        box-shadow: 0 0 8px {$data['color_3']}60;
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-neon-grid {
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            gap: 14px;
        }
        .{$name}-{$id} .{$name}-{$id}-neon-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-neon-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-neon-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-neon-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-neon-card">
                    <div class="{$name}-{$id}-neon-img-wrap">
                        <img class="{$name}-{$id}-neon-img" src="{$member['member_img']}" alt="{$member['member_name']}">
                        {if $member['member_bio']}
                            <div class="{$name}-{$id}-neon-overlay">
                                <div class="{$name}-{$id}-neon-overlay-bio">{$member['member_bio']}</div>
                            </div>
                        {/if}
                    </div>
                    <div class="{$name}-{$id}-neon-body">
                        <h4 class="{$name}-{$id}-neon-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-neon-position">{$member['member_position']}</p>
                        <div class="{$name}-{$id}-neon-social">
                            {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                            {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                            {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                            {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                            {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                            {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
