<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-grid-wrap {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
        gap: 4px;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-item {
        position: relative;
        overflow: hidden;
        aspect-ratio: 3/4;
        cursor: pointer;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        transition: transform 0.5s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-item:hover .{$name}-{$id}-grid-img {
        transform: scale(1.08);
    }

    .{$name}-{$id} .{$name}-{$id}-grid-info {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 20px;
        background: linear-gradient(transparent, rgba(0,0,0,0.75));
        transform: translateY(calc(100% - 60px));
        transition: transform 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-item:hover .{$name}-{$id}-grid-info {
        transform: translateY(0);
    }

    .{$name}-{$id} .{$name}-{$id}-grid-name {
        font-size: 1.15rem;
        font-weight: 700;
        color: {$data['color_6']};
        margin: 0 0 2px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-position {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0 0 10px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-bio {
        font-size: 0.8rem;
        color: rgba(255,255,255,0.85);
        line-height: 1.5;
        margin: 0 0 12px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-social {
        display: flex;
        gap: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 13px;
        transition: transform 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-grid-social a:hover {
        transform: scale(1.2);
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-grid-wrap {
            grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            gap: 2px;
        }
        .{$name}-{$id} .{$name}-{$id}-grid-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-grid-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-grid-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-grid-wrap">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-grid-item">
                    <img class="{$name}-{$id}-grid-img" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <div class="{$name}-{$id}-grid-info">
                        <h4 class="{$name}-{$id}-grid-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-grid-position">{$member['member_position']}</p>
                        {if $member['member_bio']}
                            <p class="{$name}-{$id}-grid-bio">{$member['member_bio']}</p>
                        {/if}
                        <div class="{$name}-{$id}-grid-social">
                            {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                            {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                            {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                            {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                            {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                            {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
