<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-fade-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
        justify-items: center;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card {
        position: relative;
        border-radius: 10px;
        overflow: hidden;
        width: 100%;
        max-width: 300px;
        aspect-ratio: 3/4;
        cursor: pointer;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        transition: transform 0.5s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card:hover .{$name}-{$id}-fade-img {
        transform: scale(1.05);
    }

    .{$name}-{$id} .{$name}-{$id}-fade-overlay {
        position: absolute;
        inset: 0;
        background: linear-gradient(transparent 30%, {$data['color_6']}ee 70%);
        display: flex;
        flex-direction: column;
        justify-content: flex-end;
        padding: 24px;
        opacity: 0;
        transition: opacity 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card:hover .{$name}-{$id}-fade-overlay {
        opacity: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-bottom {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 16px 20px;
        background: linear-gradient(transparent, rgba(0,0,0,0.6));
        transition: opacity 0.4s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-card:hover .{$name}-{$id}-fade-bottom {
        opacity: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-bottom-name {
        font-size: 1.1rem;
        font-weight: 700;
        color: #fff;
        margin: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-bottom-pos {
        font-size: 0.8rem;
        color: rgba(255,255,255,0.8);
        margin: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-name {
        font-size: 1.2rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-position {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0 0 10px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-bio {
        font-size: 0.8rem;
        color: {$data['color_5']};
        line-height: 1.5;
        margin: 0 0 12px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-social {
        display: flex;
        gap: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 32px;
        border-radius: 50%;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 14px;
        transition: transform 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-fade-social a:hover {
        transform: scale(1.15);
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-fade-grid {
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 12px;
        }
        .{$name}-{$id} .{$name}-{$id}-fade-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-fade-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-fade-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-fade-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-fade-card">
                    <img class="{$name}-{$id}-fade-img" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <div class="{$name}-{$id}-fade-bottom">
                        <h4 class="{$name}-{$id}-fade-bottom-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-fade-bottom-pos">{$member['member_position']}</p>
                    </div>
                    <div class="{$name}-{$id}-fade-overlay">
                        <h4 class="{$name}-{$id}-fade-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-fade-position">{$member['member_position']}</p>
                        {if $member['member_bio']}
                            <p class="{$name}-{$id}-fade-bio">{$member['member_bio']}</p>
                        {/if}
                        <div class="{$name}-{$id}-fade-social">
                            {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                            {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                            {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                            {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                            {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                            {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
