<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2.5rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-circ-grid {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 40px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-member {
        text-align: center;
        width: 200px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-avatar-wrap {
        position: relative;
        width: 160px;
        height: 160px;
        margin: 0 auto 16px auto;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-avatar {
        width: 160px;
        height: 160px;
        border-radius: 50%;
        object-fit: cover;
        border: 4px solid {$data['color_3']};
        transition: border-color 0.3s ease, transform 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-member:hover .{$name}-{$id}-circ-avatar {
        border-color: {$data['color_1']};
        transform: scale(1.05);
    }

    .{$name}-{$id} .{$name}-{$id}-circ-name {
        font-size: 1.1rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-position {
        font-size: 0.85rem;
        color: {$data['color_2']};
        margin: 0 0 10px 0;
        font-style: italic;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-bio {
        font-size: 0.8rem;
        color: {$data['color_5']};
        line-height: 1.5;
        margin: 0 0 12px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-social {
        display: flex;
        justify-content: center;
        gap: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 32px;
        border-radius: 50%;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 14px;
        transition: background 0.2s, color 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-circ-social a:hover {
        background: {$data['color_4']};
        color: {$data['color_3']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-circ-grid {
            gap: 24px;
        }
        .{$name}-{$id} .{$name}-{$id}-circ-member {
            width: 160px;
        }
        .{$name}-{$id} .{$name}-{$id}-circ-avatar-wrap,
        .{$name}-{$id} .{$name}-{$id}-circ-avatar {
            width: 120px;
            height: 120px;
        }
        .{$name}-{$id} .{$name}-{$id}-circ-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-circ-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-circ-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-circ-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-circ-member">
                    <div class="{$name}-{$id}-circ-avatar-wrap">
                        <img class="{$name}-{$id}-circ-avatar" src="{$member['member_img']}" alt="{$member['member_name']}">
                    </div>
                    <h4 class="{$name}-{$id}-circ-name">{$member['member_name']}</h4>
                    <p class="{$name}-{$id}-circ-position">{$member['member_position']}</p>
                    {if $member['member_bio']}
                        <p class="{$name}-{$id}-circ-bio">{$member['member_bio']}</p>
                    {/if}
                    <div class="{$name}-{$id}-circ-social">
                        {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                        {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                        {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                        {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                        {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                        {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
