<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-header {
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 2rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-cards-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 24px;
        justify-items: center;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card {
        background: {$data['color_6']};
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        width: 100%;
        max-width: 320px;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 12px 32px rgba(0,0,0,0.15);
    }

    .{$name}-{$id} .{$name}-{$id}-cards-img {
        width: 100%;
        height: 280px;
        object-fit: cover;
        display: block;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-body {
        padding: 20px;
        text-align: center;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-name {
        font-size: 1.25rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 4px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-position {
        font-size: 0.9rem;
        color: {$data['color_2']};
        margin: 0 0 12px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-bio {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.6;
        margin: 0 0 16px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-social {
        display: flex;
        justify-content: center;
        gap: 8px;
        flex-wrap: wrap;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 15px;
        transition: transform 0.2s ease, background 0.2s ease;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-cards-social a:hover {
        background: {$data['color_4']};
        color: {$data['color_3']};
        transform: scale(1.15);
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-cards-grid {
            grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
            gap: 16px;
        }
        .{$name}-{$id} .{$name}-{$id}-cards-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-cards-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-cards-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-cards-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-cards-card">
                    <img class="{$name}-{$id}-cards-img" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <div class="{$name}-{$id}-cards-body">
                        <h4 class="{$name}-{$id}-cards-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-cards-position">{$member['member_position']}</p>
                        {if $member['member_bio']}
                            <p class="{$name}-{$id}-cards-bio">{$member['member_bio']}</p>
                        {/if}
                        <div class="{$name}-{$id}-cards-social">
                            {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                            {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                            {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                            {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                            {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                            {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
