<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-header {
        text-align: left;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 0.5rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-brd-header-line {
        width: 60px;
        height: 3px;
        background: {$data['color_3']};
        margin-bottom: 2rem;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-card {
        display: flex;
        align-items: stretch;
        background: {$data['color_6']};
        border-left: 4px solid {$data['color_3']};
        padding: 20px;
        transition: border-left-width 0.2s ease, background 0.2s ease;
        border-bottom: 1px solid rgba(0,0,0,0.06);
    }

    .{$name}-{$id} .{$name}-{$id}-brd-card:hover {
        border-left-width: 6px;
        background: rgba(0,0,0,0.02);
    }

    .{$name}-{$id} .{$name}-{$id}-brd-avatar {
        width: 70px;
        height: 70px;
        border-radius: 8px;
        object-fit: cover;
        flex-shrink: 0;
        margin-right: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-info {
        flex: 1;
        min-width: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-name {
        font-size: 1.05rem;
        font-weight: 700;
        color: {$data['color_1']};
        margin: 0 0 2px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-position {
        font-size: 0.8rem;
        color: {$data['color_2']};
        margin: 0 0 8px 0;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-weight: 600;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-bio {
        font-size: 0.85rem;
        color: {$data['color_5']};
        line-height: 1.5;
        margin: 0 0 10px 0;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-social {
        display: flex;
        gap: 6px;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-social a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 28px;
        height: 28px;
        border-radius: 4px;
        background: {$data['color_3']};
        color: {$data['color_4']};
        font-size: 13px;
        transition: background 0.2s, color 0.2s;
        text-decoration: none;
    }

    .{$name}-{$id} .{$name}-{$id}-brd-social a:hover {
        background: {$data['color_4']};
        color: {$data['color_3']};
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-brd-grid {
            grid-template-columns: 1fr;
        }
        .{$name}-{$id} .{$name}-{$id}-brd-header {
            font-size: 1.4rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-brd-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-brd-header">{$data['header']}</h2>
            <div class="{$name}-{$id}-brd-header-line"></div>
        {/if}

        <div class="{$name}-{$id}-brd-grid">
            {foreach $data['members'] as $member}
                <div class="{$name}-{$id}-brd-card">
                    <img class="{$name}-{$id}-brd-avatar" src="{$member['member_img']}" alt="{$member['member_name']}">
                    <div class="{$name}-{$id}-brd-info">
                        <h4 class="{$name}-{$id}-brd-name">{$member['member_name']}</h4>
                        <p class="{$name}-{$id}-brd-position">{$member['member_position']}</p>
                        {if $member['member_bio']}
                            <p class="{$name}-{$id}-brd-bio">{$member['member_bio']}</p>
                        {/if}
                        <div class="{$name}-{$id}-brd-social">
                            {if $member['member_www']}<a href="{$member['member_www']}" target="_blank"><i class="fas fa-globe"></i></a>{/if}
                            {if $member['member_linkedin']}<a href="{$member['member_linkedin']}" target="_blank"><i class="fab fa-linkedin-in"></i></a>{/if}
                            {if $member['member_facebook']}<a href="{$member['member_facebook']}" target="_blank"><i class="fab fa-facebook-f"></i></a>{/if}
                            {if $member['member_twitter']}<a href="{$member['member_twitter']}" target="_blank"><i class="fab fa-twitter"></i></a>{/if}
                            {if $member['member_instagram']}<a href="{$member['member_instagram']}" target="_blank"><i class="fab fa-instagram"></i></a>{/if}
                            {if $member['member_github']}<a href="{$member['member_github']}" target="_blank"><i class="fab fa-github"></i></a>{/if}
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>
