<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
        text-align: center;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 1.5rem 0;
        padding: 0;
        color: {$data['header_text_color']};
    }

    /* Tabs mode */
    .{$name}-{$id} .{$name}-{$id}-puq-tabs-nav {
        display: flex;
        flex-wrap: wrap;
        border-bottom: 2px solid {$data['color_2']};
        margin-bottom: 0;
        justify-content: center;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-tab-btn {
        padding: 12px 25px;
        cursor: pointer;
        font-weight: 600;
        color: {$data['color_1']};
        background: {$data['color_2']};
        border: none;
        border-bottom: 3px solid transparent;
        transition: all 0.3s ease;
        margin-bottom: -2px;
        font-size: 1rem;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-tab-btn:hover {
        background: {$data['color_3']};
        color: {$data['color_6']};
        border-bottom-color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-puq-tab-btn-active {
        color: {$data['color_6']};
        border-bottom-color: {$data['color_6']};
        background: {$data['color_5']};
    }

    .{$name}-{$id} .{$name}-{$id}-puq-tab-content {
        display: none;
        padding: 25px 15px;
        text-align: left;
        color: {$data['color_4']};
        background: {$data['color_5']};
        animation: {$name}-{$id}-fadeIn 0.3s ease;
        font-size: 1rem;
        line-height: 1.7;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-tab-content-active {
        display: block;
    }

    /* Accordion mode */
    .{$name}-{$id} .{$name}-{$id}-puq-acc-list {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-item {
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        transition: box-shadow 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-item:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-header {
        background-color: {$data['color_2']};
        cursor: pointer;
        position: relative;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px 24px;
        transition: background-color 0.3s ease;
        border-radius: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-header:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-header-active {
        color: {$data['color_6']};
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-title {
        text-align: left;
        color: {$data['color_1']};
        font-size: 1.1rem;
        font-weight: 700;
        line-height: 1.5;
        flex: 1;
        padding-right: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-icon {
        color: {$data['color_1']};
        font-size: 1rem;
        flex-shrink: 0;
        transition: transform 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-icon-open {
        transform: rotate(180deg);
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-body {
        background-color: {$data['color_5']};
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
        border-bottom-left-radius: 8px;
        border-bottom-right-radius: 8px;
    }

    .{$name}-{$id} .{$name}-{$id}-puq-acc-body-inner {
        color: {$data['color_4']};
        padding: 24px;
        text-align: left;
        font-size: 1rem;
        line-height: 1.7;
    }

    @keyframes {$name}-{$id}-fadeIn {
        from { opacity: 0; } to { opacity: 1; }
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-puq-header {
            font-size: 1.4rem;
            letter-spacing: 1px;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-tab-btn {
            padding: 10px 16px;
            font-size: 0.9rem;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-tab-content {
            padding: 18px 12px;
            font-size: 0.95rem;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-acc-header {
            padding: 14px 18px;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-acc-title {
            font-size: 1rem;
        }

        .{$name}-{$id} .{$name}-{$id}-puq-acc-body-inner {
            padding: 18px;
            font-size: 0.95rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-puq-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-puq-header">{$data['header']}</h2>
        {/if}

        {if $data['mode'] eq 'tabs'}
            <div class="{$name}-{$id}-puq-tabs-nav">
                {foreach $data['items'] as $idx => $item}
                    <button class="{$name}-{$id}-puq-tab-btn {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-puq-tab-btn-active{/if}" onclick="puqTabSwitch{$id}({$idx})">{$item['title']}</button>
                {/foreach}
            </div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-puq-tab-content {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-puq-tab-content-active{/if}" id="{$name}-{$id}-tab-{$idx}">{$item['content']}</div>
            {/foreach}
        {else}
            <div class="{$name}-{$id}-puq-acc-list">
                {foreach $data['items'] as $idx => $item}
                    <div class="{$name}-{$id}-puq-acc-item">
                        <div class="{$name}-{$id}-puq-acc-header {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-puq-acc-header-active{/if}" onclick="puqAccToggle{$id}({$idx})">
                            <span class="{$name}-{$id}-puq-acc-title">{$item['title']}</span>
                            <i class="fa fa-chevron-down {$name}-{$id}-puq-acc-icon {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-puq-acc-icon-open{/if}" id="{$name}-{$id}-acc-icon-{$idx}"></i>
                        </div>
                        <div class="{$name}-{$id}-puq-acc-body" id="{$name}-{$id}-acc-body-{$idx}" {if $idx == ($data['default_open']|default:0)}style="max-height:2000px"{/if}>
                            <div class="{$name}-{$id}-puq-acc-body-inner">{$item['content']}</div>
                        </div>
                    </div>
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
{if $data['mode'] eq 'tabs'}
function puqTabSwitch{$id}(idx) {
    var btns = document.querySelectorAll('.{$name}-{$id}-puq-tab-btn');
    var contents = document.querySelectorAll('.{$name}-{$id}-puq-tab-content');
    for (var i = 0; i < btns.length; i++) {
        btns[i].classList.remove('{$name}-{$id}-puq-tab-btn-active');
        contents[i].classList.remove('{$name}-{$id}-puq-tab-content-active');
    }
    btns[idx].classList.add('{$name}-{$id}-puq-tab-btn-active');
    document.getElementById('{$name}-{$id}-tab-' + idx).classList.add('{$name}-{$id}-puq-tab-content-active');
}
{else}
function puqAccToggle{$id}(idx) {
    var body = document.getElementById('{$name}-{$id}-acc-body-' + idx);
    var icon = document.getElementById('{$name}-{$id}-acc-icon-' + idx);
    var header = body.previousElementSibling;
    if (body.style.maxHeight) {
        body.style.maxHeight = null;
        icon.classList.remove('{$name}-{$id}-puq-acc-icon-open');
        header.classList.remove('{$name}-{$id}-puq-acc-header-active');
    } else {
        body.style.maxHeight = body.scrollHeight + 'px';
        icon.classList.add('{$name}-{$id}-puq-acc-icon-open');
        header.classList.add('{$name}-{$id}-puq-acc-header-active');
    }
}
{/if}
</script>
