<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-header {
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 3px;
        margin: 0 0 2rem 0;
        padding: 0;
        color: {$data['header_text_color']};
        text-shadow: 0 0 10px {$data['color_6']}40, 0 0 20px {$data['color_6']}20;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-body {
        position: relative;
        padding-left: 22px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-line {
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        width: 2px;
        background: {$data['color_6']};
        border-radius: 1px;
        box-shadow: 0 0 6px {$data['color_6']}60, 0 0 12px {$data['color_6']}30;
    }

    /* Tabs mode - neon pills */
    .{$name}-{$id} .{$name}-{$id}-neon-tabs-nav {
        display: flex;
        flex-wrap: wrap;
        gap: 8px;
        justify-content: center;
        margin-bottom: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-tab-btn {
        padding: 10px 22px;
        cursor: pointer;
        font-weight: 600;
        color: {$data['color_1']};
        background: {$data['color_2']};
        border: 1px solid {$data['color_6']};
        border-radius: 6px;
        transition: all 0.3s ease;
        font-size: 0.95rem;
        box-shadow: 0 0 0 0 transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-tab-btn:hover {
        box-shadow: 0 0 8px {$data['color_6']}40, 0 0 16px {$data['color_6']}20;
        background: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-neon-tab-btn-active {
        background: {$data['color_6']};
        color: #fff;
        box-shadow: 0 0 12px {$data['color_6']}60, 0 0 24px {$data['color_6']}30;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-tab-content {
        display: none;
        background: {$data['color_5']};
        color: {$data['color_4']};
        border: 1px solid {$data['color_6']};
        border-radius: 8px;
        padding: 24px;
        text-align: left;
        font-size: 1rem;
        line-height: 1.7;
        box-shadow: 0 0 6px {$data['color_6']}20;
        animation: {$name}-{$id}-neonFadeIn 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-tab-content-active {
        display: block;
    }

    /* Accordion mode - neon glow */
    .{$name}-{$id} .{$name}-{$id}-neon-acc-list {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-item {
        border-radius: 8px;
        overflow: hidden;
        border: 1px solid {$data['color_6']};
        transition: box-shadow 0.35s ease;
        box-shadow: 0 0 0 0 transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-item:hover {
        box-shadow: 0 0 8px {$data['color_6']}40, 0 0 16px {$data['color_6']}20;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-item-active {
        box-shadow: 0 0 12px {$data['color_6']}60, 0 0 24px {$data['color_6']}30;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-header {
        background-color: {$data['color_2']};
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px 22px;
        transition: background-color 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-header:hover {
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-title {
        text-align: left;
        color: {$data['color_1']};
        font-size: 1.1rem;
        font-weight: 600;
        line-height: 1.5;
        flex: 1;
        padding-right: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-icon {
        color: {$data['color_6']};
        font-size: 1.3rem;
        flex-shrink: 0;
        display: inline-block;
        transition: transform 0.35s ease;
        transform: rotate(0deg);
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-icon-open {
        transform: rotate(90deg);
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-body {
        background-color: {$data['color_5']};
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
        border-top: 0px solid transparent;
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-body-open {
        border-top: 1px solid {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-neon-acc-body-inner {
        color: {$data['color_4']};
        padding: 22px 24px;
        text-align: left;
        font-size: 1rem;
        line-height: 1.7;
    }

    @keyframes {$name}-{$id}-neonFadeIn {
        from { opacity: 0; } to { opacity: 1; }
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-neon-header {
            font-size: 1.4rem;
            letter-spacing: 1px;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-body {
            padding-left: 16px;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-tab-btn {
            padding: 8px 16px;
            font-size: 0.85rem;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-tab-content {
            padding: 18px;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-acc-header {
            padding: 14px 16px;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-acc-title {
            font-size: 1rem;
        }

        .{$name}-{$id} .{$name}-{$id}-neon-acc-body-inner {
            padding: 18px;
            font-size: 0.95rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-neon-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-neon-header">{$data['header']}</h2>
        {/if}

        <div class="{$name}-{$id}-neon-body">
            <div class="{$name}-{$id}-neon-line"></div>

            {if $data['mode'] eq 'tabs'}
                <div class="{$name}-{$id}-neon-tabs-nav">
                    {foreach $data['items'] as $idx => $item}
                        <button class="{$name}-{$id}-neon-tab-btn {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-neon-tab-btn-active{/if}" onclick="puqTabNeon{$id}({$idx})">{$item['title']}</button>
                    {/foreach}
                </div>
                {foreach $data['items'] as $idx => $item}
                    <div class="{$name}-{$id}-neon-tab-content {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-neon-tab-content-active{/if}" id="{$name}-{$id}-neon-tab-{$idx}">{$item['content']}</div>
                {/foreach}
            {else}
                <div class="{$name}-{$id}-neon-acc-list">
                    {foreach $data['items'] as $idx => $item}
                        <div class="{$name}-{$id}-neon-acc-item {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-neon-acc-item-active{/if}" id="{$name}-{$id}-neon-acc-item-{$idx}">
                            <div class="{$name}-{$id}-neon-acc-header" onclick="puqAccNeon{$id}({$idx})">
                                <span class="{$name}-{$id}-neon-acc-title">{$item['title']}</span>
                                <span class="{$name}-{$id}-neon-acc-icon {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-neon-acc-icon-open{/if}" id="{$name}-{$id}-neon-acc-icon-{$idx}">&rsaquo;</span>
                            </div>
                            <div class="{$name}-{$id}-neon-acc-body {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-neon-acc-body-open{/if}" id="{$name}-{$id}-neon-acc-body-{$idx}" {if $idx == ($data['default_open']|default:0)}style="max-height:2000px"{/if}>
                                <div class="{$name}-{$id}-neon-acc-body-inner">{$item['content']}</div>
                            </div>
                        </div>
                    {/foreach}
                </div>
            {/if}
        </div>
    </div>
</div>

<script>
{if $data['mode'] eq 'tabs'}
function puqTabNeon{$id}(idx) {
    var btns = document.querySelectorAll('.{$name}-{$id}-neon-tab-btn');
    var contents = document.querySelectorAll('.{$name}-{$id}-neon-tab-content');
    for (var i = 0; i < btns.length; i++) {
        btns[i].classList.remove('{$name}-{$id}-neon-tab-btn-active');
        contents[i].classList.remove('{$name}-{$id}-neon-tab-content-active');
    }
    btns[idx].classList.add('{$name}-{$id}-neon-tab-btn-active');
    document.getElementById('{$name}-{$id}-neon-tab-' + idx).classList.add('{$name}-{$id}-neon-tab-content-active');
}
{else}
function puqAccNeon{$id}(idx) {
    var bodies = document.querySelectorAll('.{$name}-{$id}-neon-acc-body');
    var icons = document.querySelectorAll('.{$name}-{$id}-neon-acc-icon');
    var items = document.querySelectorAll('.{$name}-{$id}-neon-acc-item');

    for (var i = 0; i < bodies.length; i++) {
        var itemIdx = bodies[i].id.split('-').pop();
        if (parseInt(itemIdx) === idx) {
            if (bodies[i].style.maxHeight) {
                bodies[i].style.maxHeight = null;
                bodies[i].classList.remove('{$name}-{$id}-neon-acc-body-open');
                icons[i].classList.remove('{$name}-{$id}-neon-acc-icon-open');
                items[i].classList.remove('{$name}-{$id}-neon-acc-item-active');
            } else {
                bodies[i].style.maxHeight = bodies[i].scrollHeight + 'px';
                bodies[i].classList.add('{$name}-{$id}-neon-acc-body-open');
                icons[i].classList.add('{$name}-{$id}-neon-acc-icon-open');
                items[i].classList.add('{$name}-{$id}-neon-acc-item-active');
            }
        } else {
            bodies[i].style.maxHeight = null;
            bodies[i].classList.remove('{$name}-{$id}-neon-acc-body-open');
            icons[i].classList.remove('{$name}-{$id}-neon-acc-icon-open');
            items[i].classList.remove('{$name}-{$id}-neon-acc-item-active');
        }
    }
}
{/if}
</script>
