<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-header {
        z-index: 2;
        text-align: left;
        font-size: 2.2rem;
        font-weight: 300;
        letter-spacing: 0;
        margin: 0 0 2rem 0;
        padding: 0;
        color: {$data['header_text_color']};
        line-height: 1.3;
    }

    /* Tabs mode - underline style */
    .{$name}-{$id} .{$name}-{$id}-minimal-tabs-nav {
        display: flex;
        flex-wrap: wrap;
        gap: 0;
        border-bottom: 1px solid {$data['color_2']};
        margin-bottom: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-tab-btn {
        padding: 12px 20px;
        cursor: pointer;
        font-weight: 600;
        color: {$data['color_1']};
        background: transparent;
        border: none;
        border-bottom: 2px solid transparent;
        transition: all 0.2s ease;
        margin-bottom: -1px;
        font-size: 0.95rem;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-tab-btn:hover {
        opacity: 0.7;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-tab-btn-active {
        color: {$data['color_6']};
        border-bottom-color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-tab-content {
        display: none;
        padding: 24px 0;
        text-align: left;
        color: {$data['color_4']};
        font-size: 0.95rem;
        line-height: 1.8;
        animation: {$name}-{$id}-minFadeIn 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-tab-content-active {
        display: block;
    }

    /* Accordion mode - clean lines */
    .{$name}-{$id} .{$name}-{$id}-minimal-acc-list {
        display: flex;
        flex-direction: column;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-item {
        border-bottom: 1px solid {$data['color_2']};
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-item:last-child {
        border-bottom: none;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-header {
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 16px 0;
        transition: opacity 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-header:hover {
        opacity: 0.7;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-title {
        text-align: left;
        color: {$data['color_1']};
        font-size: 1.1rem;
        font-weight: 600;
        line-height: 1.5;
        flex: 1;
        padding-right: 16px;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-icon {
        color: {$data['color_1']};
        font-size: 0.85rem;
        flex-shrink: 0;
        transition: transform 0.35s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-icon-open {
        transform: rotate(180deg);
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-body {
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1), opacity 0.3s ease;
        opacity: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-body-visible {
        opacity: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-body-inner {
        padding: 0 0 20px 20px;
        border-left: 2px solid {$data['color_6']};
        margin-left: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-minimal-acc-body-text {
        color: {$data['color_4']};
        text-align: left;
        font-size: 0.95rem;
        line-height: 1.8;
        font-weight: 400;
    }

    @keyframes {$name}-{$id}-minFadeIn {
        from { opacity: 0; } to { opacity: 1; }
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-minimal-header {
            font-size: 1.6rem;
        }

        .{$name}-{$id} .{$name}-{$id}-minimal-tab-btn {
            padding: 10px 14px;
            font-size: 0.85rem;
        }

        .{$name}-{$id} .{$name}-{$id}-minimal-acc-header {
            padding: 14px 0;
        }

        .{$name}-{$id} .{$name}-{$id}-minimal-acc-title {
            font-size: 1rem;
        }

        .{$name}-{$id} .{$name}-{$id}-minimal-acc-body-text {
            font-size: 0.9rem;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-minimal-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-minimal-header">{$data['header']}</h2>
        {/if}

        {if $data['mode'] eq 'tabs'}
            <div class="{$name}-{$id}-minimal-tabs-nav">
                {foreach $data['items'] as $idx => $item}
                    <button class="{$name}-{$id}-minimal-tab-btn {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-minimal-tab-btn-active{/if}" onclick="puqTabMinimal{$id}({$idx})">{$item['title']}</button>
                {/foreach}
            </div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-minimal-tab-content {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-minimal-tab-content-active{/if}" id="{$name}-{$id}-minimal-tab-{$idx}">{$item['content']}</div>
            {/foreach}
        {else}
            <div class="{$name}-{$id}-minimal-acc-list">
                {foreach $data['items'] as $idx => $item}
                    <div class="{$name}-{$id}-minimal-acc-item">
                        <div class="{$name}-{$id}-minimal-acc-header" onclick="puqAccMinimal{$id}({$idx})">
                            <span class="{$name}-{$id}-minimal-acc-title">{$item['title']}</span>
                            <i class="fas fa-chevron-down {$name}-{$id}-minimal-acc-icon {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-minimal-acc-icon-open{/if}" id="{$name}-{$id}-minimal-acc-icon-{$idx}"></i>
                        </div>
                        <div class="{$name}-{$id}-minimal-acc-body {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-minimal-acc-body-visible{/if}" id="{$name}-{$id}-minimal-acc-body-{$idx}" {if $idx == ($data['default_open']|default:0)}style="max-height:2000px"{/if}>
                            <div class="{$name}-{$id}-minimal-acc-body-inner">
                                <div class="{$name}-{$id}-minimal-acc-body-text">{$item['content']}</div>
                            </div>
                        </div>
                    </div>
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
{if $data['mode'] eq 'tabs'}
function puqTabMinimal{$id}(idx) {
    var btns = document.querySelectorAll('.{$name}-{$id}-minimal-tab-btn');
    var contents = document.querySelectorAll('.{$name}-{$id}-minimal-tab-content');
    for (var i = 0; i < btns.length; i++) {
        btns[i].classList.remove('{$name}-{$id}-minimal-tab-btn-active');
        contents[i].classList.remove('{$name}-{$id}-minimal-tab-content-active');
    }
    btns[idx].classList.add('{$name}-{$id}-minimal-tab-btn-active');
    document.getElementById('{$name}-{$id}-minimal-tab-' + idx).classList.add('{$name}-{$id}-minimal-tab-content-active');
}
{else}
function puqAccMinimal{$id}(idx) {
    var items = document.querySelectorAll('.{$name}-{$id}-minimal-acc-body');
    var icons = document.querySelectorAll('.{$name}-{$id}-minimal-acc-icon');

    for (var i = 0; i < items.length; i++) {
        var itemIdx = items[i].id.split('-').pop();
        if (parseInt(itemIdx) === idx) {
            if (items[i].style.maxHeight) {
                items[i].style.maxHeight = null;
                items[i].classList.remove('{$name}-{$id}-minimal-acc-body-visible');
                icons[i].classList.remove('{$name}-{$id}-minimal-acc-icon-open');
            } else {
                items[i].style.maxHeight = items[i].scrollHeight + 'px';
                items[i].classList.add('{$name}-{$id}-minimal-acc-body-visible');
                icons[i].classList.add('{$name}-{$id}-minimal-acc-icon-open');
            }
        } else {
            items[i].style.maxHeight = null;
            items[i].classList.remove('{$name}-{$id}-minimal-acc-body-visible');
            icons[i].classList.remove('{$name}-{$id}-minimal-acc-icon-open');
        }
    }
}
{/if}
</script>
