<style>
    .{$name}-{$id} {
    {if $data['margin_top'] neq ''}
        padding-top: {$data['margin_top']};
    {else}
        padding-top: 0;
    {/if}
        padding-left: 20px;
        padding-right: 20px;
    }

    .{$name}-{$id} .{$name}-{$id}-border-container {
        position: relative;
        z-index: 2;
        display: block;
        width: 100%;
        text-align: left;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
    {/if}
        margin: 0 auto;
    }

    .{$name}-{$id} .{$name}-{$id}-border-header {
        z-index: 2;
        text-align: left;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 0 0 0.5rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-border-header-line {
        width: 60px;
        height: 3px;
        background-color: {$data['color_6']};
        margin-bottom: 1.5rem;
    }

    /* Tabs mode - left border indicator */
    .{$name}-{$id} .{$name}-{$id}-border-tabs-nav {
        display: flex;
        flex-wrap: wrap;
        gap: 0;
        margin-bottom: 0;
    }

    .{$name}-{$id} .{$name}-{$id}-border-tab-btn {
        padding: 14px 24px;
        cursor: pointer;
        font-weight: 600;
        color: {$data['color_1']};
        background: {$data['color_2']};
        border: none;
        border-left: 4px solid transparent;
        border-bottom: 1px solid {$data['color_2']};
        transition: all 0.2s ease;
        font-size: 0.95rem;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-border-tab-btn:hover {
        background: {$data['color_3']};
        border-left-color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-border-tab-btn-active {
        border-left-color: {$data['color_6']};
        background: {$data['color_5']};
        color: {$data['color_6']};
    }

    .{$name}-{$id} .{$name}-{$id}-border-tab-content {
        display: none;
        background: {$data['color_5']};
        color: {$data['color_4']};
        border-left: 4px solid {$data['color_2']};
        padding: 24px;
        text-align: left;
        font-size: 0.95rem;
        line-height: 1.7;
        animation: {$name}-{$id}-borderFadeIn 0.3s ease;
    {if $data['margin_bottom'] neq ''}
        margin-bottom: {$data['margin_bottom']};
    {else}
        margin-bottom: 0;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-border-tab-content-active {
        display: block;
    }

    /* Accordion mode - left border accent */
    .{$name}-{$id} .{$name}-{$id}-border-acc-list {
        display: flex;
        flex-direction: column;
        gap: 1px;
    {if $data['margin_bottom'] neq ''}
        padding-bottom: {$data['margin_bottom']};
    {else}
        padding-bottom: 0;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-border-acc-header {
        background-color: {$data['color_2']};
        padding: 18px 24px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 16px;
        border-left: 4px solid {$data['color_6']};
        transition: border-left-width 0.2s ease, background-color 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-border-acc-header:hover {
        border-left-width: 6px;
        background-color: {$data['color_3']};
    }

    .{$name}-{$id} .{$name}-{$id}-border-acc-title {
        color: {$data['color_1']};
        font-weight: 600;
        font-size: 1rem;
        flex: 1;
        line-height: 1.4;
        text-align: left;
    }

    .{$name}-{$id} .{$name}-{$id}-border-acc-toggle {
        color: {$data['color_1']};
        font-size: 1.25rem;
        font-weight: 300;
        line-height: 1;
        min-width: 20px;
        text-align: center;
        user-select: none;
        transition: transform 0.2s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-border-acc-body {
        overflow: hidden;
        max-height: 0;
        transition: max-height 0.4s cubic-bezier(0.77, 0, 0.175, 1);
    }

    .{$name}-{$id} .{$name}-{$id}-border-acc-body-inner {
        background-color: {$data['color_5']};
        color: {$data['color_4']};
        border-left: 4px solid {$data['color_2']};
        padding: 20px 24px;
        font-size: 0.95rem;
        line-height: 1.6;
        text-align: left;
    }

    @keyframes {$name}-{$id}-borderFadeIn {
        from { opacity: 0; } to { opacity: 1; }
    }

    @media (max-width: 768px) {
        .{$name}-{$id} .{$name}-{$id}-border-header {
            font-size: 1.4rem;
        }

        .{$name}-{$id} .{$name}-{$id}-border-tab-btn {
            padding: 10px 16px;
            font-size: 0.85rem;
        }

        .{$name}-{$id} .{$name}-{$id}-border-tab-content {
            padding: 18px;
        }

        .{$name}-{$id} .{$name}-{$id}-border-acc-header {
            padding: 14px 18px;
        }

        .{$name}-{$id} .{$name}-{$id}-border-acc-body-inner {
            padding: 16px 18px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}

    <div class="{$name}-{$id}-border-container">
        {if !$data['disable_header']}
            <h2 class="{$name}-{$id}-border-header">{$data['header']}</h2>
            <div class="{$name}-{$id}-border-header-line"></div>
        {/if}

        {if $data['mode'] eq 'tabs'}
            <div class="{$name}-{$id}-border-tabs-nav">
                {foreach $data['items'] as $idx => $item}
                    <button class="{$name}-{$id}-border-tab-btn {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-border-tab-btn-active{/if}" onclick="puqTabBorder{$id}({$idx})">{$item['title']}</button>
                {/foreach}
            </div>
            {foreach $data['items'] as $idx => $item}
                <div class="{$name}-{$id}-border-tab-content {if $idx == ($data['default_open']|default:0)}{$name}-{$id}-border-tab-content-active{/if}" id="{$name}-{$id}-border-tab-{$idx}">{$item['content']}</div>
            {/foreach}
        {else}
            <div class="{$name}-{$id}-border-acc-list">
                {foreach $data['items'] as $idx => $item}
                    <div class="{$name}-{$id}-border-acc-item">
                        <div class="{$name}-{$id}-border-acc-header" onclick="puqAccBorder{$id}({$idx})">
                            <span class="{$name}-{$id}-border-acc-title">{$item['title']}</span>
                            <span class="{$name}-{$id}-border-acc-toggle {$name}-{$id}-border-acc-icon" id="{$name}-{$id}-border-acc-icon-{$idx}">{if $idx == ($data['default_open']|default:0)}&minus;{else}+{/if}</span>
                        </div>
                        <div class="{$name}-{$id}-border-acc-body" id="{$name}-{$id}-border-acc-body-{$idx}" {if $idx == ($data['default_open']|default:0)}style="max-height:2000px"{/if}>
                            <div class="{$name}-{$id}-border-acc-body-inner">{$item['content']}</div>
                        </div>
                    </div>
                {/foreach}
            </div>
        {/if}
    </div>
</div>

<script>
{if $data['mode'] eq 'tabs'}
function puqTabBorder{$id}(idx) {
    var btns = document.querySelectorAll('.{$name}-{$id}-border-tab-btn');
    var contents = document.querySelectorAll('.{$name}-{$id}-border-tab-content');
    for (var i = 0; i < btns.length; i++) {
        btns[i].classList.remove('{$name}-{$id}-border-tab-btn-active');
        contents[i].classList.remove('{$name}-{$id}-border-tab-content-active');
    }
    btns[idx].classList.add('{$name}-{$id}-border-tab-btn-active');
    document.getElementById('{$name}-{$id}-border-tab-' + idx).classList.add('{$name}-{$id}-border-tab-content-active');
}
{else}
function puqAccBorder{$id}(idx) {
    var bodies = document.querySelectorAll('.{$name}-{$id}-border-acc-body');
    var icons = document.querySelectorAll('.{$name}-{$id}-border-acc-icon');

    for (var i = 0; i < bodies.length; i++) {
        var itemIdx = bodies[i].id.split('-').pop();
        if (parseInt(itemIdx) === idx) {
            if (bodies[i].style.maxHeight) {
                bodies[i].style.maxHeight = null;
                icons[i].textContent = "+";
            } else {
                bodies[i].style.maxHeight = bodies[i].scrollHeight + "px";
                icons[i].textContent = "\u2212";
            }
        } else {
            bodies[i].style.maxHeight = null;
            icons[i].textContent = "+";
        }
    }
}
{/if}
</script>
