<style>
    .{$name}-{$id} .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-slider {
        position: relative;
        z-index: 2;
        overflow: hidden;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {/if}
        -webkit-mask-image: linear-gradient(to right, transparent 0%, black 5%, black 95%, transparent 100%);
        mask-image: linear-gradient(to right, transparent 0%, black 5%, black 95%, transparent 100%);
    }

    .{$name}-{$id} .{$name}-{$id}-track {
        display: flex;
        align-items: center;
        width: calc(200px * {$data['logos_count']});
        animation: {$name}-{$id}-scroll-{$data['scroll']} {$data['scroll_speed']}s linear infinite;
    }

    .{$name}-{$id} .{$name}-{$id}-slider:hover .{$name}-{$id}-track {
        animation-play-state: paused;
    }

    .{$name}-{$id} .{$name}-{$id}-item {
        flex-shrink: 0;
        width: 200px;
        height: 100px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0 10px;
        box-sizing: border-box;
        position: relative;
    }

    .{$name}-{$id} .{$name}-{$id}-item img {
        width: 150px;
        height: 56px;
        object-fit: contain;
        transition: transform 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-item:hover img {
        transform: translateY(-4px);
    }

    .{$name}-{$id} .{$name}-{$id}-tip {
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%) translateY(6px);
        background: {$data['color_1']};
        color: {$data['color_5']};
        font-size: 0.7rem;
        font-weight: 600;
        letter-spacing: 0.5px;
        padding: 4px 12px;
        border-radius: 20px;
        white-space: nowrap;
        opacity: 0;
        transition: opacity 0.3s ease, transform 0.3s ease;
        pointer-events: none;
    }

    .{$name}-{$id} .{$name}-{$id}-item:hover .{$name}-{$id}-tip {
        opacity: 1;
        transform: translateX(-50%) translateY(0);
    }

    .{$name}-{$id} .{$name}-{$id}-item a {
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
    }

    @keyframes {$name}-{$id}-scroll-left {
        0% {
            transform: translateX(0);
        }
        100% {
            transform: translateX(-50%);
        }
    }

    @keyframes {$name}-{$id}-scroll-right {
        0% {
            transform: translateX(-50%);
        }
        100% {
            transform: translateX(0);
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    {if !$data['disable_header']}
        <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
    {/if}
    <div class="{$name}-{$id}-slider">
        <div class="{$name}-{$id}-track">
            {foreach $data['logos'] as $logo}
                <div class="{$name}-{$id}-item">
                    {if $logo['logo_url'] neq ''}
                        <a href="{$logo['logo_url']}" target="_blank"><img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" /></a>
                    {else}
                        <img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" />
                    {/if}
                    <span class="{$name}-{$id}-tip">{$logo['logo_name']}</span>
                </div>
            {/foreach}
        </div>
    </div>
</div>
