<style>
    .{$name}-{$id} .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-ribbon {
        position: relative;
        z-index: 2;
        overflow: hidden;
        width: 100%;
        background: {$data['color_1']};
        padding: 16px 0;
        transform: rotate(-1deg);
        margin: 10px 0;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-track {
        display: flex;
        align-items: center;
        width: calc(200px * {$data['logos_count']});
        animation: {$name}-{$id}-scroll-{$data['scroll']} {$data['scroll_speed']}s linear infinite;
    }

    .{$name}-{$id} .{$name}-{$id}-ribbon:hover .{$name}-{$id}-track {
        animation-play-state: paused;
    }

    .{$name}-{$id} .{$name}-{$id}-item {
        flex-shrink: 0;
        width: 200px;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0 16px;
        box-sizing: border-box;
    }

    .{$name}-{$id} .{$name}-{$id}-item img {
        width: 140px;
        height: 40px;
        object-fit: contain;
        filter: brightness(0) invert(1);
        opacity: 0.85;
        transition: opacity 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-item:hover img {
        opacity: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-item a {
        display: flex;
        align-items: center;
        justify-content: center;
    }

    @keyframes {$name}-{$id}-scroll-left {
        0% {
            transform: translateX(0);
        }
        100% {
            transform: translateX(-50%);
        }
    }

    @keyframes {$name}-{$id}-scroll-right {
        0% {
            transform: translateX(-50%);
        }
        100% {
            transform: translateX(0);
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    {if !$data['disable_header']}
        <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
    {/if}
    <div class="{$name}-{$id}-ribbon">
        <div class="{$name}-{$id}-track">
            {foreach $data['logos'] as $logo}
                <div class="{$name}-{$id}-item">
                    {if $logo['logo_url'] neq ''}
                        <a href="{$logo['logo_url']}" target="_blank"><img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" /></a>
                    {else}
                        <img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" />
                    {/if}
                </div>
            {/foreach}
        </div>
    </div>
</div>
