<style>
    .{$name}-{$id} .{$name}-{$id}-header {
        position: relative;
        z-index: 2;
        text-align: center;
        font-size: 2rem;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin: 1rem 0;
        color: {$data['header_text_color']};
    }

    .{$name}-{$id} .{$name}-{$id}-grid {
        position: relative;
        z-index: 2;
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        align-items: center;
        gap: 0;
        width: 100%;
    {if $data['width'] neq ''}
        max-width: {$data['width']};
        margin-left: auto;
        margin-right: auto;
    {/if}
    }

    .{$name}-{$id} .{$name}-{$id}-cell {
        flex: 0 0 auto;
        width: 16.666%;
        height: 100px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 16px;
        box-sizing: border-box;
        border-right: 1px solid {$data['color_6']}1a;
        border-bottom: 1px solid {$data['color_6']}1a;
        transition: background-color 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-cell:hover {
        background-color: {$data['color_5']};
    }

    .{$name}-{$id} .{$name}-{$id}-cell img {
        width: 120px;
        height: 50px;
        object-fit: contain;
        opacity: 0.7;
        transition: opacity 0.3s ease;
    }

    .{$name}-{$id} .{$name}-{$id}-cell:hover img {
        opacity: 1;
    }

    .{$name}-{$id} .{$name}-{$id}-cell a {
        display: flex;
        align-items: center;
        justify-content: center;
    }

    @media (max-width: 991px) {
        .{$name}-{$id} .{$name}-{$id}-cell {
            width: 25%;
        }
    }

    @media (max-width: 600px) {
        .{$name}-{$id} .{$name}-{$id}-cell {
            width: 33.333%;
            height: 80px;
            padding: 12px;
        }
        .{$name}-{$id} .{$name}-{$id}-cell img {
            max-width: 80px;
            max-height: 36px;
        }
    }
</style>

<div class="{$name}-{$id}">
    {if $data['background_image']}
        <div class="{$name}-{$id}-cover"></div>
    {/if}
    {if !$data['disable_header']}
        <h2 class="{$name}-{$id}-header">{$data['header']}</h2>
    {/if}
    <div class="{$name}-{$id}-grid">
        {foreach $data['logos'] as $logo}
            <div class="{$name}-{$id}-cell">
                {if $logo['logo_url'] neq ''}
                    <a href="{$logo['logo_url']}" target="_blank"><img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" /></a>
                {else}
                    <img src="{$logo['logo_img']}" alt="{$logo['logo_name']}" />
                {/if}
            </div>
        {/foreach}
    </div>
</div>
