class PUQSliderLogos {
    static get toolbox() {
        return {
            title: 'Slider Logos',
            icon: '<i class="fas fa-sliders-h"></i>'
        };
    }
    constructor( {data, api, block}){
        this.data = data;
        this.api = api;
        this.block = block;
    }
    static get enableLineBreaks() {
        return true;
    }
    static get sanitize() {
        return {
            table: {
                b: true,
                bold: true,
                strong: true,
                i: true,
                a: true,
                s: true,
                img: true,
                small: true,
                br: true,
                mark: true,
                div: true,
                span: true,
                h1: true,
                h2: true,
                h3: true,
                h4: true,
                h5: true,
                hr: true,
                h6: true,
                ol: true,
                sup: true,
                sub: true,
                ul: true,
                li: true,
                p: true,
                table: true,
                tbody: true,
                tr: true,
                td: true,
                th: true,
            }
        };
    }
    render()
    {
        const render = document.createElement('div');
        render.classList.add('puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));

        const optionTemplates = generateOptionTemplates('PUQSliderLogos');

        $(render).append(`
<table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
    <tbody>
    <tr>
        <td  class="fieldlabel"><h1 style="color: blue;">Slider Logos</h1><i style="color: green;">#${this.block.id.replace(/[^A-Za-z0-9]/g, "")}</i></td>
        <td colspan="3" class="fieldarea">
            <label for="width">width: </label>
            <input type="text" name="width" class="form-control input-inline input-100" value="">
            <label for="margin_top">margin-top: </label>
            <input type="text" name="margin_top" class="form-control input-inline input-100" value="">
            <label for="margin_bottom">margin-bottom: </label>
            <input type="text" name="margin_bottom" class="form-control input-inline input-100" value="">
            <label for="style">Style: </label>
            <select name="style" class="form-control select-inline">
                ${optionTemplates}
            </select>
        </td>
    </tr>

     <tr>
        <td class="fieldlabel"><b>Color</b></td>
        <td colspan="3" class="fieldarea">

            <label for="color_1">Color 1:</label>
            <input type="color" name="color_1" class="form-control input-inline input-50">

            <label for="color_2">Color 2:</label>
            <input type="color" name="color_2" class="form-control input-inline input-50">

            <label for="color_3">Color 3:</label>
            <input type="color" name="color_3" class="form-control input-inline input-50">

            <label for="color_4">Color 4:</label>
            <input type="color" name="color_4" class="form-control input-inline input-50">

            <label for="color_5">Color 5:</label>
            <input type="color" name="color_5" class="form-control input-inline input-50">

            <label for="color_6">Color 6:</label>
            <input type="color" name="color_6" class="form-control input-inline input-50">
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><b>Background image/color</b></td>
        <td colspan="3" class="fieldarea"><input type="text" name="background_image" value="" class="form-control input-inline input-200">

        <input type="color" name="background_color" class="form-control input-inline input-50">
        <label class="checkbox-inline"><input type="checkbox" name="disable_background_shadow"><b>Disable Shadow</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_top"><b>Disable Radius top</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background_radius_bottom"><b>Disable Radius bottom</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="disable_background"><b>Disable Background</b></label>

        <label class="checkbox-inline"><input type="checkbox" name="full_width"><b>Full width</b></label>
        </td>
    </tr>

       <tr>
        <td class="fieldlabel"><b>Header</b><br>e.g. (Our partners)</td>
        <td colspan="3" class="fieldarea">
            <input type="text" name="header" value="" class="form-control input-inline input-200">
            <label for="header_text_color">Text color:</label>
            <input type="color" name="header_text_color" class="form-control input-inline input-50">
            <label class="checkbox-inline">
            <input type="checkbox" name="disable_header"><b>Disable header</b></label>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"><a type="button" name="add-row"><div style="font-size: 24px;" class="fa fa-plus"></div></a></td>
        <td colspan="3" class="fieldarea">
            <label for="scroll">Scroll direction: </label>
            <select name="scroll" class="form-control select-inline">
                <option value="left">Left</option>
                <option value="right">Right</option>
            </select>

            <label for="scroll_speed">Scroll speed: </label>
            <select name="scroll_speed" class="form-control select-inline">
                <option value="60">Very Very Slow</option>
                <option value="40">So slow</option>
                <option value="30">Slowly</option>
                <option value="20">Medium</option>
                <option value="10">Fast</option>
                <option value="5">Very fast</option>
            </select>
        </td>
    </tr>

    <tr>
        <td class="fieldlabel"></td>
        <td colspan="3" class="fieldarea">
            <table name="SliderTable" class="datatable">
                <thead>
                <tr>
                    <th class="text-center"><b>Name</b></th>
                    <th class="text-center" ><b>IMG</b></th>
                    <th class="text-center">URL</th>
                    <th class="text-center"></th>
                    <th class="text-center"></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </td>
    </tr>

    </tbody>
</table>
`);
        const table = render.querySelector("[name='SliderTable']");
        const addRowButton = render.querySelector("[name='add-row']");

        const logos = this.data && this.data.logos ? this.data.logos : "";
        const tbody = table.querySelector("tbody");
        Object.entries(logos).forEach(([key, value]) => {
            const row = document.createElement("tr");

            row.innerHTML = `
                <td class="text-center"><input type="text" name="logo_name" value="${value.logo_name}" class="form-control input-inline input-200"></td>
                <td class="text-center"><input type="text" name="logo_img" value="${value.logo_img}" class="form-control input-inline input-400"></td>
                <td class="text-center"><input type="text" name="logo_url" value="${value.logo_url}" class="form-control input-inline input-400"></td>
                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
            `;
            tbody.appendChild(row);
            addRowListeners(row);
        });

        function addRow() {
            const tbody = table.querySelector("tbody");
            const row = document.createElement("tr");
            row.innerHTML = `
                <td class="text-center"><input type="text" name="logo_name" value="" class="form-control input-inline input-200"></td>
                <td class="text-center"><input type="text" name="logo_img" value="" class="form-control input-inline input-400"></td>
                <td class="text-center"><input type="text" name="logo_url" value="" class="form-control input-inline input-400"></td>
                <td class="text-center">
                  <a type="button" name="move-up" class="btn btn-warning"><div class="fa fa-arrow-up"></div></a>
                  <a type="button" name="move-down" class="btn btn-warning"><div class="fa fa-arrow-down"></div></a>
                </td>
                <td class="text-center"><a type="button" name="remove-row" class="btn btn-danger"><div class="fal fa-trash-alt"></div></a></td>
  `;
            tbody.appendChild(row);
            addRowListeners(row);
        }

        function removeRow(row) {
            row.remove();
        }

        function moveRow(row, direction) {
            const tbody = row.parentNode;
            const rows = Array.from(tbody.children);
            const index = rows.indexOf(row);
            const newIndex = index + direction;

            if (newIndex >= 0 && newIndex < rows.length) {
                const siblingRow = rows[newIndex];
                if (direction === 1) {
                    tbody.insertBefore(row, siblingRow.nextSibling);
                } else {
                    tbody.insertBefore(row, siblingRow);
                }
            } else if (newIndex === -1) {
                tbody.insertBefore(row, rows[0]);
            } else if (newIndex === rows.length) {
                tbody.insertBefore(row, null);
            }
        }

        function addRowListeners(row) {
            const removeButton = row.querySelector("[name='remove-row']");
            const moveUpButton = row.querySelector("[name='move-up']");
            const moveDownButton = row.querySelector("[name='move-down']");

            removeButton.addEventListener("click", () => {
                removeRow(row);
            });

            moveUpButton.addEventListener("click", () => {
                moveRow(row, -1);
            });

            moveDownButton.addEventListener("click", () => {
                moveRow(row, 1);
            });
        }

        addRowButton.addEventListener("click", () => {
            addRow();
        });

        const width = this.data && this.data.width ? this.data.width : "";
        $(render).find("[name='width']").val(width);

        const margin_top = this.data && this.data.margin_top ? this.data.margin_top : "";
        $(render).find("[name='margin_top']").val(margin_top);

        const margin_bottom = this.data && this.data.margin_bottom ? this.data.margin_bottom : "";
        $(render).find("[name='margin_bottom']").val(margin_bottom);

        const style = this.data && this.data.style ? this.data.style : "";
        $(render).find("[name='style']").val(style);
        if (style === '') {
            $(render).find("[name='style']").val('puq');
        }

        const color_1 = this.data && this.data.color_1 ? this.data.color_1 : "";
        $(render).find("[name='color_1']").val(color_1);
        if (color_1 === '') {
            $(render).find("[name='color_1']").val('#6420c0');
        }

        const color_2 = this.data && this.data.color_2 ? this.data.color_2 : "";
        $(render).find("[name='color_2']").val(color_2);
        if (color_2 === '') {
            $(render).find("[name='color_2']").val('#0de1b9');
        }

        const color_3 = this.data && this.data.color_3 ? this.data.color_3 : "";
        $(render).find("[name='color_3']").val(color_3);
        if (color_3 === '') {
            $(render).find("[name='color_3']").val('#6420c0');
        }

        const color_4 = this.data && this.data.color_4 ? this.data.color_4 : "";
        $(render).find("[name='color_4']").val(color_4);
        if (color_4 === '') {
            $(render).find("[name='color_4']").val('#d41111');
        }

        const color_5 = this.data && this.data.color_5 ? this.data.color_5 : "";
        $(render).find("[name='color_5']").val(color_5);
        if (color_5 === '') {
            $(render).find("[name='color_5']").val('#a484d5');
        }

        const color_6 = this.data && this.data.color_6 ? this.data.color_6 : "";
        $(render).find("[name='color_6']").val(color_6);
        if (color_6 === '') {
            $(render).find("[name='color_6']").val('#000000');
        }

        const background_image = this.data && this.data.background_image ? this.data.background_image : "";
        $(render).find("[name='background_image']").val(background_image);

        const background_color = this.data && this.data.background_color ? this.data.background_color : "";
        $(render).find("[name='background_color']").val(background_color);
        if (background_color === '') {
            $(render).find("[name='background_color']").val('#ffffff');
        }

        if (this.data.disable_background_shadow === true) {
            $(render).find("[name='disable_background_shadow']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_top === true) {
            $(render).find("[name='disable_background_radius_top']").attr('checked', 'checked');
        }

        if (this.data.disable_background_radius_bottom === true) {
            $(render).find("[name='disable_background_radius_bottom']").attr('checked', 'checked');
        }

        if (this.data.disable_background === true) {
            $(render).find("[name='disable_background']").attr('checked', 'checked');
        }

        if (this.data.full_width === true) {
            $(render).find("[name='full_width']").attr('checked', 'checked');
        }

        const header = this.data && this.data.header ? this.data.header : "";
        $(render).find("[name='header']").val(header);
        if (header === '') {
            $(render).find("[name='header']").val('Our partners');
        }

        const header_text_color = this.data && this.data.header_text_color ? this.data.header_text_color : "";
        $(render).find("[name='header_text_color']").val(header_text_color);
        if (header_text_color === '') {
            $(render).find("[name='header_text_color']").val('#000000');
        }

        if (this.data.disable_header === true) {
            $(render).find("[name='disable_header']").attr('checked', 'checked');
        }

        const scroll = this.data && this.data.scroll ? this.data.scroll : "";
        $(render).find("[name='scroll']").val(scroll);
        if (scroll === '') {
            $(render).find("[name='scroll']").val('left');
        }

        const scroll_speed = this.data && this.data.scroll_speed ? this.data.scroll_speed : "";
        $(render).find("[name='scroll_speed']").val(scroll_speed);
        if (scroll_speed === '') {
            $(render).find("[name='scroll_speed']").val('20');
        }

        function generateOptionTemplates(key) {
            const templates = JSON.parse(widgetsTemplatesJson);
            const lowerCaseKey = key.toLowerCase();
            if (lowerCaseKey in templates) {
                const templatesArray = templates[lowerCaseKey];
                let options = "";

                templatesArray.forEach((value) => {
                    options += '<option value="' + value + '">' + value + '</option>';
                });
                return options;
            }
            return "";
        }

        return render;
    }

    renderSettings(){
        return [
            {
                icon: `<i class="fa fa-clone"></i>`,
                label: 'Clone',
                onActivate: () => {
                    const render = window.document.querySelector('.puq'+this.block.id.replace(/[^A-Za-z0-9]/g, ""));
                    this.api.blocks.insert(this.block.name, this.save(render), this.block.config, this.block.index, true);
                }
            },
        ];
    }

    save(content) {

        var disable_background_shadow = false;
        if ($(content).find("[name='disable_background_shadow']").is(':checked')) {
            disable_background_shadow = true;
        }

        var disable_background_radius_top = false;
        if ($(content).find("[name='disable_background_radius_top']").is(':checked')) {
            disable_background_radius_top = true;
        }

        var disable_background_radius_bottom = false;
        if ($(content).find("[name='disable_background_radius_bottom']").is(':checked')) {
            disable_background_radius_bottom = true;
        }

        var disable_background = false;
        if ($(content).find("[name='disable_background']").is(':checked')) {
            disable_background = true;
        }

        var disable_header = false;
        if ($(content).find("[name='disable_header']").is(':checked')) {
            disable_header = true;
        }

        var full_width = false;
        if ($(content).find("[name='full_width']").is(':checked')) {
            full_width = true;
        }

        var style = $(content).find("[name='style']").val();
        if (!style) {
            style = 'puq';
        }

        const table = content.querySelector("[name='SliderTable']")
        const rows = table.querySelectorAll('tbody tr');
        const data = {};
        rows.forEach((row, index) => {
            const inputs = row.querySelectorAll('input');

            const values = {};
            inputs.forEach(input => {
                const name = input.getAttribute('name');
                if (name === 'logo_name' || name === 'logo_img' || name === 'logo_url') {
                    values[name] = input.value;
                }
            });

            if (Object.keys(values).length > 0) {
                data[index] = values;
            }
        });

        return {
            "width": $(content).find("[name='width']").val().replace(/	/g, ""),
            "margin_top": $(content).find("[name='margin_top']").val().replace(/	/g, ""),
            "margin_bottom": $(content).find("[name='margin_bottom']").val().replace(/	/g, ""),
            "style": style.replace(/	/g, ""),

            "color_1": $(content).find("[name='color_1']").val().replace(/	/g, ""),
            "color_2": $(content).find("[name='color_2']").val().replace(/	/g, ""),
            "color_3": $(content).find("[name='color_3']").val().replace(/	/g, ""),
            "color_4": $(content).find("[name='color_4']").val().replace(/	/g, ""),
            "color_5": $(content).find("[name='color_5']").val().replace(/	/g, ""),
            "color_6": $(content).find("[name='color_6']").val().replace(/	/g, ""),

            "background_image": $(content).find("[name='background_image']").val().replace(/	/g, ""),
            "background_color": $(content).find("[name='background_color']").val().replace(/	/g, ""),
            "disable_background_shadow": disable_background_shadow,
            "disable_background_radius_top": disable_background_radius_top,
            "disable_background_radius_bottom": disable_background_radius_bottom,
            "disable_background": disable_background,
            "full_width": full_width,

            "header": $(content).find("[name='header']").val().replace(/	/g, ""),
            "header_text_color": $(content).find("[name='header_text_color']").val().replace(/	/g, ""),
            "disable_header": disable_header,

            "scroll": $(content).find("[name='scroll']").val().replace(/	/g, ""),
            "scroll_speed": $(content).find("[name='scroll_speed']").val().replace(/	/g, ""),

            "logos": data
        };
    }
}
